/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.propagators;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.generated.tags.Tag;
import com.contrastsecurity.agent.messages.finding.trace.EventActionDTM;
import com.contrastsecurity.agent.plugins.security.policy.Location;
import com.contrastsecurity.agent.plugins.security.policy.e;
import com.contrastsecurity.agent.plugins.security.policy.k;
import com.contrastsecurity.agent.plugins.security.policy.n;
import com.contrastsecurity.agent.plugins.security.policy.q;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@DontObfuscate
public class Propagator
extends e
implements Cloneable {
    private EventActionDTM propagationType;
    private final Command cmd;
    private Location[] sources;
    private final String[] cmdArguments;
    private int[] integerCmdArguments;
    private boolean[] isLiteralCmdArguments;
    private final Set<Tag> tags;
    private final Set<Tag> untags;
    private final boolean cloneOnUnchangedCloneableSource;
    private final boolean shouldTagsApplyWhenInvokedDuringSources;
    private final AtomicInteger totalTimesHit;
    private final AtomicBoolean currentlyDeadzoning;
    private final AtomicBoolean loggedMaximumEvents;
    private Set<String> requiredParameterTypes;
    private static final Logger logger = LoggerFactory.getLogger(Propagator.class);

    public Propagator(int n2, String string, String string2, Location[] locationArray, Location[] locationArray2, Command command, String[] stringArray, Set<Tag> set, Set<Tag> set2, boolean bl2, boolean bl3, k k2) {
        super(n2, string, string2, locationArray2, k2);
        this.sources = Objects.requireNonNull(locationArray);
        Preconditions.check(locationArray.length > 0, "Propagator with ID=%s has no sources", string2);
        this.isLiteralCmdArguments = new boolean[2];
        this.cmd = command;
        this.cmdArguments = stringArray;
        this.totalTimesHit = new AtomicInteger();
        this.currentlyDeadzoning = new AtomicBoolean();
        this.loggedMaximumEvents = new AtomicBoolean();
        this.requiredParameterTypes = Collections.emptySet();
        this.tags = set != null ? set : Collections.emptySet();
        this.untags = set2 != null ? set2 : Collections.emptySet();
        for (Tag tag : this.tags) {
            if (!this.untags.contains((Object)tag)) continue;
            throw new IllegalArgumentException("Propagator with ID=" + string2 + " has overlapping tags and untags");
        }
        this.cloneOnUnchangedCloneableSource = bl2;
        if (bl3) {
            Preconditions.check(this.tags.size() + this.untags.size() > 0, "Propagator with ID=%s has no tags, but is configured to apply during sources", string2);
        }
        this.shouldTagsApplyWhenInvokedDuringSources = bl3;
        this.parseCommandArguments();
        this.initializePropagationType();
    }

    public boolean loggedMaximumEvents() {
        return this.loggedMaximumEvents.getAndSet(true);
    }

    public Location[] getSources() {
        return this.sources;
    }

    public Set<String> getRequiredParameterTypes() {
        return this.requiredParameterTypes;
    }

    public void setSources(Location[] locationArray) {
        this.sources = locationArray;
    }

    public int getCountOfArgSources() {
        if (this.sources == null) {
            return 0;
        }
        int n2 = 0;
        for (Location location : this.sources) {
            n2 += location.isParameter() ? 1 : 0;
        }
        return n2;
    }

    public int getCountOfArgTargets() {
        if (this.targets == null) {
            return 0;
        }
        int n2 = 0;
        for (Location location : this.targets) {
            n2 += location.isParameter() ? 1 : 0;
        }
        return n2;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public Set<Tag> getUntags() {
        return this.untags;
    }

    public boolean isCloneOnUnchangedCloneableSource() {
        return this.cloneOnUnchangedCloneableSource;
    }

    public boolean isShouldTagsApplyWhenInvokedDuringSources() {
        return this.shouldTagsApplyWhenInvokedDuringSources;
    }

    public int onHit() {
        return this.totalTimesHit.incrementAndGet();
    }

    public boolean attemptToEnterExclusiveAccess() {
        return this.currentlyDeadzoning.compareAndSet(false, true);
    }

    public void exitExclusiveAccess() {
        boolean bl2 = this.currentlyDeadzoning.compareAndSet(true, false);
        if (!bl2) {
            logger.warn("Leaving adaptive optimisation for propagation deadzoning, exclusive check failed on exit: {}", (Object)this.getId());
        }
    }

    public void setTargetDescription(String string) {
        this.targetType = string;
    }

    public EventActionDTM getPropagationType() {
        return this.propagationType;
    }

    public String[] getCommandArguments() {
        return this.cmdArguments;
    }

    public int getParameterValue(int n2, Object[] objectArray) throws IllegalArgumentException {
        return this.isLiteralCmdArguments != null && this.isLiteralCmdArguments[n2] ? this.integerCmdArguments[n2] : ((Number)objectArray[this.integerCmdArguments[n2]]).intValue();
    }

    public Command getCommand() {
        return this.cmd;
    }

    private void parseCommandArguments() {
        boolean bl2 = this.cmdArguments != null;
        int n2 = bl2 ? this.cmdArguments.length : 0;
        this.integerCmdArguments = new int[n2];
        this.isLiteralCmdArguments = new boolean[n2];
        if (!bl2 || n2 == 1 && this.cmdArguments[0].isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < this.cmdArguments.length; ++i2) {
            if (this.cmdArguments[i2].charAt(0) == 'P') {
                this.cmdArguments[i2] = this.cmdArguments[i2].substring(1);
                this.integerCmdArguments[i2] = Integer.parseInt(this.cmdArguments[i2]) - 1;
                continue;
            }
            this.isLiteralCmdArguments[i2] = true;
            this.integerCmdArguments[i2] = Integer.parseInt(this.cmdArguments[i2]);
        }
        this.validateCommandArguments();
    }

    private void validateCommandArguments() {
        if (!(this.matcher instanceof q)) {
            return;
        }
        String[] stringArray = ((q)this.matcher).a().c();
        for (int i2 = 0; i2 < this.cmdArguments.length; ++i2) {
            String string;
            if (this.isLiteralCmdArguments[i2] || "int".equals(string = stringArray[this.integerCmdArguments[i2]]) || "long".equals(string) || "byte".equals(string) || "short".equals(string)) continue;
            throw new n(this.getId() + " is invalid. Command arguments must correspond to long, int, short, or byte types.");
        }
    }

    private void setLiteralCommandArguments(boolean[] blArray) {
        this.isLiteralCmdArguments = blArray;
    }

    private void setIntegerCommandArguments(int[] nArray) {
        this.integerCmdArguments = nArray;
    }

    void setRequiredParameterTypes(Set<String> set) {
        this.requiredParameterTypes = set;
    }

    public void logExceededMaximumEvents() {
        String string = this.getId();
        if (this.loggedMaximumEvents()) {
            logger.debug("Ignoring propagator {} because maximum reached", (Object)string);
        } else {
            logger.warn("Ignoring propagator {} because maximum reached, consider increasing maximum events via the `assess.max_propagation_events` property. Further events will be logged at the `DEBUG` level", (Object)string);
        }
    }

    private void initializePropagationType() {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        for (Location location : this.sources) {
            bl2 = bl2 || location.isObject();
            bl3 = bl3 || location.isParameter();
        }
        Location[] locationArray = this.targets;
        int n2 = locationArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Location location;
            location = locationArray[i2];
            bl4 = bl4 || location.isObject();
            bl5 = bl5 || location.isParameter();
            bl6 = bl6 || location.isReturn();
        }
        boolean bl7 = bl2 && bl3;
        int n3 = n2 = bl4 && bl5 || bl4 && bl6 || bl5 && bl6 ? 1 : 0;
        if (bl7) {
            if (n2 != 0) {
                this.propagationType = EventActionDTM.A2A;
            } else if (bl4) {
                this.propagationType = EventActionDTM.A2O;
            } else if (bl5) {
                this.propagationType = EventActionDTM.A2P;
            } else if (bl6) {
                this.propagationType = EventActionDTM.A2R;
            }
        } else if (bl2) {
            if (n2 != 0) {
                this.propagationType = EventActionDTM.O2A;
            } else if (bl4) {
                this.propagationType = EventActionDTM.O2O;
            } else if (bl5) {
                this.propagationType = EventActionDTM.O2P;
            } else if (bl6) {
                this.propagationType = EventActionDTM.O2R;
            }
        } else if (bl3) {
            if (n2 != 0) {
                this.propagationType = EventActionDTM.P2A;
            } else if (bl4) {
                this.propagationType = EventActionDTM.P2O;
            } else if (bl5) {
                this.propagationType = EventActionDTM.P2P;
            } else if (bl6) {
                this.propagationType = EventActionDTM.P2R;
            }
        }
    }

    public Propagator clone() {
        Propagator propagator = new Propagator(this.policyId, this.policyLocation, this.getId(), this.sources, this.targets, this.cmd, this.cmdArguments != null ? (String[])this.cmdArguments.clone() : null, this.tags, this.untags, this.cloneOnUnchangedCloneableSource, this.shouldTagsApplyWhenInvokedDuringSources, this.getMethodMatcher());
        propagator.setLiteralCommandArguments(this.isLiteralCmdArguments != null ? (boolean[])this.isLiteralCmdArguments.clone() : null);
        propagator.setIntegerCommandArguments(this.integerCmdArguments != null ? (int[])this.integerCmdArguments.clone() : null);
        propagator.deep = this.deep;
        propagator.scoped = this.scoped;
        propagator.operation = this.operation;
        return propagator;
    }

    @Override
    protected String getTypeLabel() {
        return "propagator";
    }

    @DontObfuscate
    public static enum Command {
        ALL,
        INSERT,
        APPEND,
        REMOVE,
        REPLACE,
        SUBSET,
        KEEP,
        GUESS,
        CONCAT,
        PREPEND,
        OVERWRITE,
        STRIP_WHITESPACE,
        STRIP_TRAILING_WHITESPACE,
        STRIP_LEADING_WHITESPACE;

    }
}

