/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.telemetry;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.services.a;
import com.contrastsecurity.agent.telemetry.b.b;
import com.contrastsecurity.agent.telemetry.errors.TelemetryErrorEmitter;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.telemetry.metrics.DistributionSummary;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.util.ContrastAgentUtil;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@DontObfuscate
public final class CpuProfiler
implements a {
    private final boolean telemetryEnabled;
    private final boolean cpuSamplingEnabled;
    private final long intervalMs;
    private final ScheduledExecutorService commonExecutorService;
    private final DistributionSummary contrastPercentageOfProcessCpu;
    private final DistributionSummary contrastBackgroundThreadPercentageOfProcessCpu;
    private final Counter contrastSamples;
    private final Counter totalSamples;
    private final TelemetryErrorEmitter emitter;
    static final AtomicBoolean VIRTUAL_THREAD_CREATED = new AtomicBoolean(false);
    private static final Logger logger = LoggerFactory.getLogger(CpuProfiler.class);

    public CpuProfiler(Config config, ScheduledExecutorService scheduledExecutorService, TelemetryMetrics telemetryMetrics, TelemetryErrorEmitter telemetryErrorEmitter) {
        this.telemetryEnabled = b.a(config);
        this.cpuSamplingEnabled = config.getBoolean(ConfigProperty.SUPPORTER_TELEMETRY);
        this.intervalMs = config.getLong(ConfigProperty.CPU_PROFILE_INTERVAL_MS);
        this.commonExecutorService = scheduledExecutorService;
        this.contrastPercentageOfProcessCpu = telemetryMetrics.newDistributionSummary("contrastPercentageOfProcessCpu", TelemetryMetrics.TelemetryCategory.GENERAL).withDescription("Sampling-based calculation of the CPU overhead of Contrast for the process.").withBaseUnit("percent").withBucketBoundaries(2.5, 5.0, 7.5, 10.0, 12.5, 15.0, 17.5, 20.0, 22.5, 25.0, 30.0, 35.0, 50.0).register();
        this.contrastSamples = telemetryMetrics.newCounter("contrastRunningThreadSampleCount", TelemetryMetrics.TelemetryCategory.GENERAL).withDescription("The number of Contrast CPU samples.").register();
        this.totalSamples = telemetryMetrics.newCounter("totalRunningThreadSampleCount", TelemetryMetrics.TelemetryCategory.GENERAL).withDescription("The total number of CPU samples.").register();
        this.contrastBackgroundThreadPercentageOfProcessCpu = telemetryMetrics.newDistributionSummary("contrastBackgroundThreadPercentageOfProcessCpu", TelemetryMetrics.TelemetryCategory.GENERAL).withDescription("CPU overhead of Contrast background threads based on CPU time.").withBaseUnit("percent").withBucketBoundaries(0.001, 0.005, 0.01, 0.05, 0.1, 0.5, 1.0, 1.5, 2.0, 2.5, 5.0, 10.0, 50.0).register(telemetryMetrics);
        this.emitter = telemetryErrorEmitter;
    }

    @Override
    public String getName() {
        return "CpuProfilerStartupTaskService";
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean blocksOnStop() {
        return false;
    }

    private static void cancel(AtomicReference<ScheduledFuture<?>> atomicReference) {
        if (atomicReference.get() == null) {
            return;
        }
        atomicReference.get().cancel(false);
    }

    private static boolean isThreadCpuTimeEnabled(ThreadMXBean threadMXBean) {
        try {
            return threadMXBean.isThreadCpuTimeEnabled();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
    }

    @Override
    public void start(Instrumentation instrumentation, List<? extends ContrastPlugin> list) {
        boolean bl2;
        if (!this.telemetryEnabled) {
            logger.debug("Disabling CPU telemetry since telemetry is disabled.");
            return;
        }
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean == null) {
            logger.debug("Disabling CPU telemetry since ThreadMXBean is unavailable.");
            return;
        }
        OperatingSystem operatingSystem = new OperatingSystem();
        boolean bl3 = bl2 = threadMXBean.isCurrentThreadCpuTimeSupported() && threadMXBean.isThreadCpuTimeSupported() && CpuProfiler.isThreadCpuTimeEnabled(threadMXBean) && operatingSystem.processCpuTimeNs() != -1L;
        if (!this.cpuSamplingEnabled && !bl2) {
            logger.debug("Disabling CPU telemetry since sampling and thread CPU time capturing are disabled.");
            return;
        }
        AtomicReference atomicReference = new AtomicReference();
        atomicReference.set(this.commonExecutorService.scheduleAtFixedRate(() -> {
            try {
                boolean bl3;
                boolean bl4 = this.cpuSamplingEnabled && !CpuProfiler.wasVirtualThreadCreated();
                boolean bl5 = bl3 = bl2 && CpuProfiler.isThreadCpuTimeEnabled(threadMXBean);
                if (!bl4 && !bl3) {
                    logger.debug("Disabling CPU telemetry since sampling and thread CPU time capturing are disabled.");
                    CpuProfiler.cancel(atomicReference);
                    return;
                }
                CpuProfiler.captureSamples(bl4, threadMXBean, this.contrastSamples, this.totalSamples, this.contrastPercentageOfProcessCpu, bl3, operatingSystem, this.contrastBackgroundThreadPercentageOfProcessCpu);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                this.emitter.emit(throwable2);
                logger.debug("Failed to capture Contrast CPU samples. Cancelling CPU profiling.", throwable2);
                CpuProfiler.cancel(atomicReference);
            }
        }, this.intervalMs, this.intervalMs, TimeUnit.MILLISECONDS));
    }

    @q
    public static void captureSamples(boolean bl2, ThreadMXBean threadMXBean, Counter counter, Counter counter2, DistributionSummary distributionSummary, boolean bl3, OperatingSystem operatingSystem, DistributionSummary distributionSummary2) {
        ThreadInfo[] threadInfoArray;
        long l2 = operatingSystem.processCpuTimeNs();
        long l3 = 0L;
        double d2 = 0.0;
        double d3 = 0.0;
        block6: for (ThreadInfo threadInfo : threadInfoArray = threadMXBean.dumpAllThreads(false, false)) {
            boolean bl4;
            if (threadInfo == null) continue;
            StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
            boolean bl5 = bl4 = stackTraceElementArray.length > 0 && ContrastAgentUtil.isAgentClass(stackTraceElementArray[stackTraceElementArray.length - 1].getClassName());
            if (bl4 && bl3) {
                long l4 = -1L;
                try {
                    l4 = threadMXBean.getThreadCpuTime(threadInfo.getThreadId());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    bl3 = false;
                }
                if (l4 > -1L) {
                    l3 += l4;
                } else {
                    bl3 = CpuProfiler.isThreadCpuTimeEnabled(threadMXBean);
                }
            }
            if (!bl2) continue;
            switch (threadInfo.getThreadState()) {
                case RUNNABLE: {
                    break;
                }
                case NEW: 
                case BLOCKED: 
                case WAITING: 
                case TIMED_WAITING: 
                case TERMINATED: {
                    continue block6;
                }
                default: {
                    throw new UnsupportedOperationException("Unhandled thread state: " + (Object)((Object)threadInfo.getThreadState()));
                }
            }
            d3 += 1.0;
            if (stackTraceElementArray.length == 0) continue;
            if (bl4) {
                d2 += 1.0;
                continue;
            }
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (!ContrastAgentUtil.isAgentClass(stackTraceElement.getClassName())) continue;
                d2 += 1.0;
                continue block6;
            }
        }
        if (bl3) {
            distributionSummary2.record((double)l3 / (double)l2 * 100.0);
            logger.debug("Profiled CPU and found that Contrast background threads used {}ns and the JVM used {}ns CPU time.", (Object)l3, (Object)l2);
        } else {
            logger.debug("Skipping CPU timing since it is disabled.");
        }
        if (bl2 && !CpuProfiler.wasVirtualThreadCreated() && d3 > 0.0) {
            distributionSummary.record(d2 / d3 * 100.0);
            counter2.increment(d3);
            counter.increment(d2);
            logger.debug("Sampled CPU and found {} Contrast samples out of {} total samples.", (Object)d2, (Object)d3);
        } else {
            logger.debug("Skipping CPU sampling since it is disabled.");
        }
    }

    @q
    public static boolean wasVirtualThreadCreated() {
        return VIRTUAL_THREAD_CREATED.get();
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    @DontObfuscate
    @q
    public static final class OperatingSystem {
        private final OperatingSystemMXBean wrapped = ManagementFactory.getOperatingSystemMXBean();
        private final Reflect reflect = Reflect.reflect(this.wrapped, CpuProfiler.access$000());

        @ScopedSensor
        @q
        public long processCpuTimeNs() {
            ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
            try {
                this.reflect.reset(this.wrapped);
                long l2 = this.reflect.invokePublic("getProcessCpuTime").asLong(-1L);
                scopeProvider.leaveScope();
                return l2;
            }
            catch (Throwable throwable) {
                scopeProvider.leaveScope();
                throw throwable;
            }
        }
    }
}

