/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.telemetry;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.generated.tags.Tag;
import com.contrastsecurity.agent.k.g;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.security.policy.Location;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.stack.l;
import com.contrastsecurity.agent.telemetry.HeapProfiler;
import com.contrastsecurity.agent.telemetry.errors.TelemetryErrorEmitter;
import com.contrastsecurity.agent.telemetry.metrics.DistributionSummary;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.ArrayUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.lang.instrument.Instrumentation;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

@DontObfuscate
@o
public class HeapProfilerImpl
implements HeapProfiler {
    private final Config config;
    private final long intervalMs;
    private final Instrumentation instrumentation;
    private final ScheduledExecutorService commonExecutorService;
    private final DistributionSummary traceMapsHeapUsageDistribution;
    private final DistributionSummary traceMapsHeapUsagePercentageDistribution;
    private final Supplier<List<Collection<? extends Object>>> trackedContextsSupplier;
    private final TelemetryErrorEmitter emitter;
    private static final int MAX_RECURSION = 100;
    private static final Logger logger = LoggerFactory.getLogger(HeapProfilerImpl.class);

    public HeapProfilerImpl(Config config, Instrumentation instrumentation, ScheduledExecutorService scheduledExecutorService, Supplier<List<Collection<? extends Object>>> supplier, TelemetryMetrics telemetryMetrics, TelemetryErrorEmitter telemetryErrorEmitter) {
        this.config = config;
        this.intervalMs = config.getLong(ConfigProperty.HEAP_PROFILER_INTERVAL_MS);
        this.instrumentation = instrumentation;
        this.commonExecutorService = scheduledExecutorService;
        long l2 = 1000000L;
        long l3 = 1000000000L;
        this.traceMapsHeapUsageDistribution = telemetryMetrics.newDistributionSummary("assessTraceMapHeapUsage", TelemetryMetrics.TelemetryCategory.ASSESS).withDescription("Low-end estimate of Assess Trace Map heap usage.").withBaseUnit("bytes").withBucketBoundaries(1000000.0, 1.0E7, 1.0E8, 2.5E8, 5.0E8, 7.5E8, 9.0E8, 1.0E9).register(telemetryMetrics);
        this.traceMapsHeapUsagePercentageDistribution = telemetryMetrics.newDistributionSummary("assessTraceMapHeapUsagePercentage", TelemetryMetrics.TelemetryCategory.ASSESS).withDescription("Low-end estimate of Assess Trace Map heap usage percentage.").withBaseUnit("percent").withBucketBoundaries(0.1, 1.0, 2.0, 5.0, 7.0, 10.0, 12.0, 15.0, 17.0, 20.0, 25.0, 50.0).register(telemetryMetrics);
        this.emitter = telemetryErrorEmitter;
        this.trackedContextsSupplier = supplier;
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean blocksOnStop() {
        return false;
    }

    @Override
    public void start(Instrumentation instrumentation, List<? extends ContrastPlugin> list) {
        this.commonExecutorService.scheduleAtFixedRate(() -> {
            try {
                if (!this.config.getBoolean(ConfigProperty.ASSESS_ENABLED)) {
                    logger.debug("Skipping trace map heap profiling since assess is not enabled.");
                    return;
                }
                logger.debug("Beginning profiling retained heap for trace maps.");
                Set<Object> set = Collections.newSetFromMap(new IdentityHashMap());
                long l2 = 0L;
                for (Collection<? extends Object> collection : this.trackedContextsSupplier.get()) {
                    l2 += this.heapSizeForCollection(collection, set);
                }
                if (l2 == 0L) {
                    return;
                }
                this.traceMapsHeapUsageDistribution.record(l2);
                logger.debug("Total retained heap for all trace maps: {}", (Object)l2);
                double d2 = (double)l2 / (double)Runtime.getRuntime().totalMemory() * 100.0;
                this.traceMapsHeapUsagePercentageDistribution.record(d2);
                logger.debug("Percentage of total heap for all trace maps: {}", (Object)d2);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                this.emitter.emit(throwable2);
                logger.debug("Failed to calculate retained heap for trace maps:", throwable2);
            }
        }, this.intervalMs, this.intervalMs, TimeUnit.MILLISECONDS);
    }

    private long heapSizeForCollection(Collection<? extends Object> collection, Set<Object> set) {
        Iterator<? extends Object> iterator = collection.iterator();
        long l2 = 0L;
        while (iterator.hasNext()) {
            Object object;
            try {
                object = iterator.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            long l3 = HeapProfilerImpl.sizeOfRetainedHeapInBytes(object, this.instrumentation, set);
            if (l3 <= 0L) continue;
            l2 += l3;
        }
        return l2;
    }

    @Override
    public String getName() {
        return "HeapProfilerService";
    }

    private static long sizeOfRetainedHeapInBytes(Object object, Instrumentation instrumentation, Set<Object> set) {
        TreeMap<String, AtomicLong> treeMap = logger.isTraceEnabled() ? new TreeMap<String, AtomicLong>(String.CASE_INSENSITIVE_ORDER) : null;
        return HeapProfilerImpl.sizeOfRetainedHeapInBytes(object, instrumentation, set, treeMap);
    }

    @q
    public static long sizeOfRetainedHeapInBytes(Object object, Instrumentation instrumentation, Set<Object> set, Map<String, AtomicLong> map) {
        try {
            HeapUsage.SupportsHeapProfiling supportsHeapProfiling = object.getClass().getAnnotation(HeapUsage.SupportsHeapProfiling.class);
            Class<?>[] classArray = supportsHeapProfiling != null ? supportsHeapProfiling.ownedCaches() : Empty.CLASS_ARRAY;
            long l2 = HeapProfilerImpl.sizeOfRetainedHeapInBytes(object, instrumentation, 1, set, classArray, map);
            if (map != null) {
                for (Map.Entry<String, AtomicLong> entry : map.entrySet()) {
                    AtomicLong atomicLong = entry.getValue();
                    logger.trace("Shallow retained heap for {} = {}", (Object)entry.getKey(), (Object)(atomicLong != null ? atomicLong.get() : 0L));
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Total retained heap for {}: {}", (Object)JVMUtils.getSafeToString(object), (Object)l2);
            }
            return l2;
        }
        catch (b b2) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not calculate retained heap for {}. More than {} levels of nested objects found.", (Object)JVMUtils.getSafeToString(object), (Object)100);
            }
            return -1L;
        }
    }

    private static long sizeOfRetainedHeapInBytes(Object object, Instrumentation instrumentation, int n2, Set<Object> set, Class<?>[] classArray, Map<String, AtomicLong> map) throws b {
        if (n2 > 100) {
            throw new b();
        }
        if (object == null) {
            return 0L;
        }
        if (a.a.contains(object)) {
            return 0L;
        }
        if (!(object instanceof StackTraceElement) && !set.add(object)) {
            return 0L;
        }
        Class<?> clazz = object.getClass();
        switch (HeapUsage.supportsHeapProfiling(object, clazz)) {
            case NONE: {
                return 0L;
            }
            case SHALLOW: {
                long l2 = instrumentation.getObjectSize(object);
                if (map != null) {
                    map.computeIfAbsent(clazz.getTypeName(), string -> new AtomicLong()).addAndGet(l2);
                }
                return l2;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)HeapUsage.supportsHeapProfiling(object, clazz)) + " not supported.");
            }
            case DEEP: 
        }
        long l3 = instrumentation.getObjectSize(object);
        if (map != null) {
            map.computeIfAbsent(clazz.getTypeName(), string -> new AtomicLong()).addAndGet(l3);
        }
        if (clazz.isArray() && object instanceof Object[]) {
            Object[] objectArray;
            for (Object object2 : objectArray = (Object[])object) {
                l3 += HeapProfilerImpl.sizeOfRetainedHeapInBytes(object2, instrumentation, n2 + 1, set, classArray, map);
            }
            return l3;
        }
        boolean bl2 = object instanceof Reference;
        for (Class<?> clazz2 = clazz; clazz2 != null && !Object.class.equals(clazz2); clazz2 = clazz2.getSuperclass()) {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz2.getDeclaredFields()) {
                Object object3;
                HeapUsage.Cacheable cacheable;
                field.setAccessible(true);
                Class<?> clazz3 = field.getType();
                if (clazz3.isPrimitive() || Modifier.isStatic(field.getModifiers()) || bl2 && Object.class.equals(clazz3) || bl2 && Reference.class.equals(clazz3) || field.getAnnotation(HeapUsage.Shallow.class) != null || (cacheable = field.getAnnotation(HeapUsage.Cacheable.class)) != null && classArray.length > 0 && !ArrayUtils.contains(classArray, cacheable.cache()) || field.isSynthetic() && (clazz3 == clazz2.getDeclaringClass() || clazz3 == clazz2.getEnclosingClass()) && (object3 = clazz2.getAnnotation(HeapUsage.SupportsHeapProfiling.class)) != null && object3.implicitOuterReference() == HeapUsage.SHALLOW) continue;
                try {
                    object3 = field.get(object);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("Field \"" + field.getName() + "\" on class type \"" + clazz2.getTypeName() + "\" was inaccessible.", illegalAccessException);
                }
                try {
                    l3 += HeapProfilerImpl.sizeOfRetainedHeapInBytes(object3, instrumentation, n2 + 1, set, classArray, map);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    if (unsupportedOperationException.getCause() != null) {
                        throw unsupportedOperationException;
                    }
                    throw new UnsupportedOperationException(HeapProfilerImpl.failureMessage(clazz, field), unsupportedOperationException);
                }
                catch (b b2) {
                    if (b2.getCause() != null) {
                        throw b2;
                    }
                    throw new b(HeapProfilerImpl.failureMessage(clazz, field), b2);
                }
            }
        }
        return l3;
    }

    private static String failureMessage(Class<?> clazz, Field field) {
        return "Failed to calculate heap usage for " + clazz.getTypeName() + "#" + field.getName();
    }

    private static final class b
    extends Exception {
        private b() {
        }

        private b(String string, Throwable throwable) {
            super(string, throwable);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class a {
        static final Set<Object> a;

        private a() {
        }

        static {
            Set set = Collections.newSetFromMap(new IdentityHashMap());
            List<Class> list = Lists.of(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Character.class);
            for (Class<PropertyKey> clazz : Lists.builder().addAll(list).add(Collections.class).add(HashSet.class).add(ReferenceQueue.class).add(Throwable.class).add(Empty.class).add(Location.class).add(ObjectShare.class).add(l.class).add(g.class).add(Tag.class).add(PropertyKey.class).build()) {
                Class<?>[] classArray = clazz.getDeclaredClasses();
                for (int i2 = -1; i2 < classArray.length; ++i2) {
                    Class<PropertyKey> clazz2 = i2 < 0 ? clazz : classArray[i2];
                    for (Field field : clazz2.getDeclaredFields()) {
                        field.setAccessible(true);
                        Class<?> clazz3 = field.getType();
                        if (clazz3.isPrimitive() || !Modifier.isStatic(field.getModifiers())) continue;
                        try {
                            Object object = field.get(null);
                            if (object == null) continue;
                            set.add(object);
                            if (!list.contains(clazz) || !object.getClass().isArray() || !(object instanceof Number[]) && !(object instanceof Character[])) continue;
                            Collections.addAll(set, (Object[])object);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new RuntimeException("Field \"" + field.getName() + "\" on class type \"" + clazz.getTypeName() + "\" was inaccessible.", illegalAccessException);
                        }
                    }
                }
            }
            for (Location location : Location.ALL) {
                set.add(location.getParameterType());
                set.add(location.getDescriptor());
                set.add(location.getZeroIndexedName());
            }
            a = Collections.unmodifiableSet(set);
        }
    }
}

