/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.telemetry.metrics.micrometer;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.telemetry.b.a;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.micrometer.ExistingTagNameChecker;
import com.contrastsecurity.agent.telemetry.metrics.micrometer.k;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

@DontObfuscate
public final class MetricValidator {
    private final ExistingTagNameChecker nameProvider;
    private static final Pattern NAME_REGEX = Pattern.compile("[a-zA-Z0-9\\._\\-]+");
    private static final Pattern TAG_KEY_REGEX = Pattern.compile("[a-zA-Z0-9\\._\\-]{1,33}");
    private static final String METRIC_REJECTED_MESSAGE = "Metric rejected because";
    private static final Logger logger = LoggerFactory.getLogger(k.class);

    public MetricValidator(ExistingTagNameChecker existingTagNameChecker) {
        this.nameProvider = Objects.requireNonNull(existingTagNameChecker);
    }

    public String validateMeterNameAndTags(String string, TelemetryMetrics.TelemetryCategory telemetryCategory, Map<String, String> map) {
        List<String> list = a.b();
        if (list.contains(string)) {
            throw new IllegalArgumentException("Metric rejected because metric name is using a reserved word - " + string);
        }
        if (this.invalidName(string)) {
            throw new IllegalArgumentException("Metric rejected because metric name contains invalid characters - " + string);
        }
        String string2 = this.fullPath(telemetryCategory, string);
        if (this.nameProvider.nameAndTagsExist(string2, map)) {
            throw new IllegalArgumentException("Metric rejected because a metric with that name/tags combination has already been created - " + string);
        }
        if (map.size() < 1) {
            return string2;
        }
        ArrayList<String> arrayList = new ArrayList<String>(0);
        for (Map.Entry<String, String> object : map.entrySet()) {
            String string3 = object.getKey();
            String string4 = object.getValue();
            if (!list.contains(string3) && !this.nameProvider.nameExists(string3) && !string2.equals(string3) && !this.invalidTagKey(string3) && !this.invalidTagValue(string4)) continue;
            logger.debug("Not adding tag ({},{}) to meter ({}), either because its key uses a reserved word, or because the tag as a whole does not meet the telemetry spec.", string3, string4, string2);
            arrayList.add(string3);
        }
        for (String string5 : arrayList) {
            map.remove(string5);
        }
        return string2;
    }

    @q
    public String fullPath(TelemetryMetrics.TelemetryCategory telemetryCategory, String string) {
        return telemetryCategory.getPath() + "/" + string;
    }

    private boolean invalidName(String string) {
        return !NAME_REGEX.matcher(string).matches();
    }

    private boolean invalidTagKey(String string) {
        return !TAG_KEY_REGEX.matcher(string).matches();
    }

    private boolean invalidTagValue(String string) {
        return string.trim().length() == 0 || string.length() >= 200;
    }
}

