/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.util;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.util.G;
import com.contrastsecurity.agent.util.PreConfigUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;

@DontObfuscate
public final class FileUtil {
    private FileUtil() {
    }

    public static boolean isInaccessible(File file) {
        return !FileUtil.isAccessible(file);
    }

    public static boolean isAccessible(File file) {
        return file != null && file.exists() && file.canRead();
    }

    public static boolean isWriteableFile(File file) {
        return file != null && file.exists() && file.isFile() && file.canRead() && file.canWrite();
    }

    public static boolean isWriteableDir(File file) {
        return file != null && file.exists() && file.isDirectory() && file.canRead() && file.canWrite() && file.canExecute();
    }

    public static String getAbsolutePath(File file, String string) {
        return file != null ? file.getAbsolutePath() : string;
    }

    public static File autoDeletingTempFile(String string, String string2) throws IOException {
        return FileUtil.deleteOnExit(File.createTempFile(string, string2));
    }

    public static File deleteOnExit(Path path) {
        return FileUtil.deleteOnExit(path.toFile());
    }

    public static File deleteOnExit(File file) {
        file.deleteOnExit();
        return file;
    }

    public static File autoDeletingFile(File file, String string) throws IOException {
        boolean bl2 = file.mkdirs();
        File file2 = FileUtil.deleteOnExit(new File(file, string));
        boolean bl3 = file2.createNewFile();
        return file2;
    }

    public static File getOrCreateFile(File file, String string) throws IOException {
        File file2 = new File(file, string);
        boolean bl2 = file2.createNewFile();
        return file2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean findInFile(File file, String[] stringArray) throws IOException {
        Object object;
        Object object2;
        if (stringArray == null) throw new IllegalArgumentException("Search terms cannot be NULL or empty");
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Search terms cannot be NULL or empty");
        }
        if (FileUtil.isInaccessible(file)) {
            PreConfigUtil.out("Unable to process: " + file.getAbsolutePath() + ", the file is inaccessible");
            return false;
        }
        FileReader fileReader = new FileReader(file);
        try {
            boolean bl2;
            object2 = new BufferedReader(fileReader);
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                if (!G.a((String)object, stringArray)) continue;
                bl2 = true;
            }
            {
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    try {
                        ((BufferedReader)object2).close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable4 = throwable3;
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            {
                ((BufferedReader)object2).close();
                fileReader.close();
                return bl2;
            }
            ((BufferedReader)object2).close();
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            object2 = throwable;
            try {
                fileReader.close();
                throw object2;
            }
            catch (Throwable throwable5) {
                Throwables.throwIfCritical(throwable5);
                object = throwable5;
                ((Throwable)object2).addSuppressed((Throwable)object);
            }
            throw object2;
        }
        fileReader.close();
        return false;
    }

    public static URL toFileUrl(File file) {
        URL uRL = null;
        try {
            try {
                uRL = file.toURI().toURL();
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                PreConfigUtil.out("Couldn't translate File {} to URL " + uRL + " to File - attempting our way: " + exception2.getMessage());
                uRL = new URL("file", "", FileUtil.slashify(file.getAbsolutePath(), file.isDirectory()));
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            PreConfigUtil.err("Unable to construct the URL " + uRL + " to File " + file.getAbsolutePath() + ": " + throwable2.getMessage());
        }
        return uRL;
    }

    public static File toFile(URL uRL) {
        File file = null;
        try {
            try {
                file = new File(uRL.toURI());
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                PreConfigUtil.out("Couldn't translate URL " + uRL + " to File - attempting our way: " + exception2.getMessage());
                String string = uRL.getPath();
                if (File.separatorChar != '/') {
                    string = string.replace('/', File.separatorChar);
                }
                file = new File(string);
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            PreConfigUtil.err("Couldn't translate URL " + uRL + " to File: " + throwable2.getMessage());
        }
        return file;
    }

    private static String slashify(String string, boolean bl2) {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && bl2) {
            string2 = string2 + "/";
        }
        return string2;
    }
}

