/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cggl.protobuf;

import com.contrastsecurity.thirdparty.cggl.protobuf.AbstractProtobufList;
import com.contrastsecurity.thirdparty.cggl.protobuf.Internal;
import com.contrastsecurity.thirdparty.cggl.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class BooleanArrayList
extends AbstractProtobufList<Boolean>
implements Internal.BooleanList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final BooleanArrayList EMPTY_LIST = new BooleanArrayList(new boolean[0], 0);
    private boolean[] array;
    private int size;

    public static BooleanArrayList emptyList() {
        return EMPTY_LIST;
    }

    BooleanArrayList() {
        this(new boolean[10], 0);
    }

    private BooleanArrayList(boolean[] blArray, int n2) {
        this.array = blArray;
        this.size = n2;
    }

    @Override
    protected void removeRange(int n2, int n3) {
        this.ensureIsMutable();
        if (n3 < n2) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, n3, this.array, n2, this.size - n3);
        this.size -= n3 - n2;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BooleanArrayList)) {
            return super.equals(object);
        }
        BooleanArrayList booleanArrayList = (BooleanArrayList)object;
        if (this.size != booleanArrayList.size) {
            return false;
        }
        boolean[] blArray = booleanArrayList.array;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.array[i2] == blArray[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            n2 = 31 * n2 + Internal.hashBoolean(this.array[i2]);
        }
        return n2;
    }

    @Override
    public Internal.BooleanList mutableCopyWithCapacity(int n2) {
        if (n2 < this.size) {
            throw new IllegalArgumentException();
        }
        return new BooleanArrayList(Arrays.copyOf(this.array, n2), this.size);
    }

    @Override
    public Boolean get(int n2) {
        return this.getBoolean(n2);
    }

    @Override
    public boolean getBoolean(int n2) {
        this.ensureIndexInRange(n2);
        return this.array[n2];
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof Boolean)) {
            return -1;
        }
        boolean bl2 = (Boolean)object;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.array[i2] != bl2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Boolean set(int n2, Boolean bl2) {
        return this.setBoolean(n2, bl2);
    }

    @Override
    public boolean setBoolean(int n2, boolean bl2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n2);
        boolean bl3 = this.array[n2];
        this.array[n2] = bl2;
        return bl3;
    }

    @Override
    public boolean add(Boolean bl2) {
        this.addBoolean(bl2);
        return true;
    }

    @Override
    public void add(int n2, Boolean bl2) {
        this.addBoolean(n2, bl2);
    }

    @Override
    public void addBoolean(boolean bl2) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int n2 = this.size * 3 / 2 + 1;
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.array, 0, blArray, 0, this.size);
            this.array = blArray;
        }
        this.array[this.size++] = bl2;
    }

    private void addBoolean(int n2, boolean bl2) {
        this.ensureIsMutable();
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n2));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n2, this.array, n2 + 1, this.size - n2);
        } else {
            int n3 = this.size * 3 / 2 + 1;
            boolean[] blArray = new boolean[n3];
            System.arraycopy(this.array, 0, blArray, 0, n2);
            System.arraycopy(this.array, n2, blArray, n2 + 1, this.size - n2);
            this.array = blArray;
        }
        this.array[n2] = bl2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Boolean> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof BooleanArrayList)) {
            return super.addAll(collection);
        }
        BooleanArrayList booleanArrayList = (BooleanArrayList)collection;
        if (booleanArrayList.size == 0) {
            return false;
        }
        int n2 = Integer.MAX_VALUE - this.size;
        if (n2 < booleanArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n3 = this.size + booleanArrayList.size;
        if (n3 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n3);
        }
        System.arraycopy(booleanArrayList.array, 0, this.array, this.size, booleanArrayList.size);
        this.size = n3;
        ++this.modCount;
        return true;
    }

    @Override
    public Boolean remove(int n2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n2);
        boolean bl2 = this.array[n2];
        if (n2 < this.size - 1) {
            System.arraycopy(this.array, n2 + 1, this.array, n2, this.size - n2 - 1);
        }
        --this.size;
        ++this.modCount;
        return bl2;
    }

    private void ensureIndexInRange(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n2));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int n2) {
        return "Index:" + n2 + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

