/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client;

import com.contrastsecurity.thirdparty.crmq.client.Address;
import com.contrastsecurity.thirdparty.crmq.client.AddressResolver;
import com.contrastsecurity.thirdparty.crmq.client.ConnectionFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class DnsRecordIpAddressResolver
implements AddressResolver {
    private final Address address;
    private final boolean ssl;

    public DnsRecordIpAddressResolver(String string, int n2, boolean bl2) {
        this(new Address(string, n2), bl2);
    }

    public DnsRecordIpAddressResolver(String string, int n2) {
        this(new Address(string, n2), false);
    }

    public DnsRecordIpAddressResolver() {
        this("localhost");
    }

    public DnsRecordIpAddressResolver(String string) {
        this(new Address(string), false);
    }

    public DnsRecordIpAddressResolver(Address address) {
        this(address, false);
    }

    public DnsRecordIpAddressResolver(Address address, boolean bl2) {
        this.address = address;
        this.ssl = bl2;
    }

    @Override
    public List<Address> getAddresses() throws UnknownHostException {
        String string = this.address.getHost();
        int n2 = ConnectionFactory.portOrDefault(this.address.getPort(), this.ssl);
        InetAddress[] inetAddressArray = this.resolveIpAddresses(string);
        ArrayList<Address> arrayList = new ArrayList<Address>();
        for (InetAddress inetAddress : inetAddressArray) {
            arrayList.add(new Address(inetAddress.getHostAddress(), n2));
        }
        return arrayList;
    }

    protected InetAddress[] resolveIpAddresses(String string) throws UnknownHostException {
        return InetAddress.getAllByName(string);
    }
}

