/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client.impl;

import com.contrastsecurity.thirdparty.crmq.client.LongString;
import com.contrastsecurity.thirdparty.crmq.client.impl.ValueWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class ContentHeaderPropertyWriter {
    private final ValueWriter out;
    public int flagWord;
    public int bitCount;

    public ContentHeaderPropertyWriter(DataOutputStream dataOutputStream) {
        this.out = new ValueWriter(dataOutputStream);
        this.flagWord = 0;
        this.bitCount = 0;
    }

    private void emitFlagWord(boolean bl2) throws IOException {
        this.out.writeShort(bl2 ? this.flagWord | 1 : this.flagWord);
        this.flagWord = 0;
        this.bitCount = 0;
    }

    public void writePresence(boolean bl2) throws IOException {
        if (this.bitCount == 15) {
            this.emitFlagWord(true);
        }
        if (bl2) {
            int n2 = 15 - this.bitCount;
            this.flagWord |= 1 << n2;
        }
        ++this.bitCount;
    }

    public void finishPresence() throws IOException {
        this.emitFlagWord(false);
    }

    public void writeShortstr(String string) throws IOException {
        this.out.writeShortstr(string);
    }

    public void writeLongstr(String string) throws IOException {
        this.out.writeLongstr(string);
    }

    public void writeLongstr(LongString longString) throws IOException {
        this.out.writeLongstr(longString);
    }

    public void writeShort(Integer n2) throws IOException {
        this.out.writeShort(n2);
    }

    public void writeLong(Integer n2) throws IOException {
        this.out.writeLong(n2);
    }

    public void writeLonglong(Long l2) throws IOException {
        this.out.writeLonglong(l2);
    }

    public void writeTable(Map<String, Object> map) throws IOException {
        this.out.writeTable(map);
    }

    public void writeOctet(Integer n2) throws IOException {
        this.out.writeOctet(n2);
    }

    public void writeOctet(int n2) throws IOException {
        this.out.writeOctet(n2);
    }

    public void writeTimestamp(Date date) throws IOException {
        this.out.writeTimestamp(date);
    }
}

