/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client.impl;

import com.contrastsecurity.thirdparty.crmq.client.AlreadyClosedException;
import com.contrastsecurity.thirdparty.crmq.client.Channel;
import com.contrastsecurity.thirdparty.crmq.client.Connection;
import com.contrastsecurity.thirdparty.crmq.client.Consumer;
import com.contrastsecurity.thirdparty.crmq.client.ExceptionHandler;
import com.contrastsecurity.thirdparty.crmq.client.TopologyRecoveryException;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.IOException;
import java.net.ConnectException;

public class ForgivingExceptionHandler
implements ExceptionHandler {
    @Override
    public void handleUnexpectedConnectionDriverException(Connection connection, Throwable throwable) {
        this.log("An unexpected connection driver error occured", throwable);
    }

    @Override
    public void handleReturnListenerException(Channel channel, Throwable throwable) {
        this.handleChannelKiller(channel, throwable, "ReturnListener.handleReturn");
    }

    @Override
    public void handleFlowListenerException(Channel channel, Throwable throwable) {
        this.handleChannelKiller(channel, throwable, "FlowListener.handleFlow");
    }

    @Override
    public void handleConfirmListenerException(Channel channel, Throwable throwable) {
        this.handleChannelKiller(channel, throwable, "ConfirmListener.handle{N,A}ck");
    }

    @Override
    public void handleBlockedListenerException(Connection connection, Throwable throwable) {
        this.handleConnectionKiller(connection, throwable, "BlockedListener");
    }

    @Override
    public void handleConsumerException(Channel channel, Throwable throwable, Consumer consumer, String string, String string2) {
        this.handleChannelKiller(channel, throwable, "Consumer " + consumer + " (" + string + ") method " + string2 + " for channel " + channel);
    }

    @Override
    public void handleConnectionRecoveryException(Connection connection, Throwable throwable) {
        if (!(throwable instanceof ConnectException)) {
            this.log("Caught an exception during connection recovery!", throwable);
        }
    }

    @Override
    public void handleChannelRecoveryException(Channel channel, Throwable throwable) {
        this.log("Caught an exception when recovering channel " + channel.getChannelNumber(), throwable);
    }

    @Override
    public void handleTopologyRecoveryException(Connection connection, Channel channel, TopologyRecoveryException topologyRecoveryException) {
        this.log("Caught an exception when recovering topology " + topologyRecoveryException.getMessage(), topologyRecoveryException);
    }

    protected void handleChannelKiller(Channel channel, Throwable throwable, String string) {
        this.log(string + "threw an exception for channel " + channel, throwable);
    }

    protected void handleConnectionKiller(Connection connection, Throwable throwable, String string) {
        this.log(string + " threw an exception for connection " + connection, throwable);
        try {
            connection.close(200, "Closed due to exception from " + string);
        }
        catch (AlreadyClosedException alreadyClosedException) {
        }
        catch (IOException iOException) {
            this.log("Failure during close of connection " + connection + " after " + throwable, iOException);
            connection.abort(541, "Internal error closing connection for " + string);
        }
    }

    protected void log(String string, Throwable throwable) {
        if (ForgivingExceptionHandler.isSocketClosedOrConnectionReset(throwable)) {
            LoggerFactory.getLogger(ForgivingExceptionHandler.class).warn(string + " (Exception message: " + throwable.getMessage() + ")");
        } else {
            LoggerFactory.getLogger(ForgivingExceptionHandler.class).error(string, throwable);
        }
    }

    private static boolean isSocketClosedOrConnectionReset(Throwable throwable) {
        return throwable instanceof IOException && ("Connection reset".equals(throwable.getMessage()) || "Socket closed".equals(throwable.getMessage()) || "Connection reset by peer".equals(throwable.getMessage()));
    }
}

