/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client.impl.nio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ByteBufferOutputStream
extends OutputStream {
    private final WritableByteChannel channel;
    private final ByteBuffer buffer;

    public ByteBufferOutputStream(WritableByteChannel writableByteChannel, ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        this.channel = writableByteChannel;
    }

    @Override
    public void write(int n2) throws IOException {
        if (!this.buffer.hasRemaining()) {
            ByteBufferOutputStream.drain(this.channel, this.buffer);
        }
        this.buffer.put((byte)n2);
    }

    @Override
    public void flush() throws IOException {
        ByteBufferOutputStream.drain(this.channel, this.buffer);
    }

    public static void drain(WritableByteChannel writableByteChannel, ByteBuffer byteBuffer) throws IOException {
        byteBuffer.flip();
        while (byteBuffer.hasRemaining() && writableByteChannel.write(byteBuffer) != -1) {
        }
        byteBuffer.clear();
    }
}

