/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.aop;

import com.contrastsecurity.thirdparty.imm.common.KeyValue;
import com.contrastsecurity.thirdparty.imm.common.annotation.AnnotationHandler;
import com.contrastsecurity.thirdparty.imm.common.annotation.NoOpValueResolver;
import com.contrastsecurity.thirdparty.imm.common.annotation.ValueExpressionResolver;
import com.contrastsecurity.thirdparty.imm.common.annotation.ValueResolver;
import com.contrastsecurity.thirdparty.imm.common.util.StringUtils;
import com.contrastsecurity.thirdparty.imm.core.aop.MeterTag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Timer;
import java.util.function.Function;

public class MeterTagAnnotationHandler
extends AnnotationHandler<Timer.Builder> {
    public MeterTagAnnotationHandler(Function<Class<? extends ValueResolver>, ? extends ValueResolver> function, Function<Class<? extends ValueExpressionResolver>, ? extends ValueExpressionResolver> function2) {
        super((keyValue, builder) -> builder.tag(keyValue.getKey(), keyValue.getValue()), function, function2, MeterTag.class, (annotation, object) -> {
            if (!(annotation instanceof MeterTag)) {
                return null;
            }
            MeterTag meterTag = (MeterTag)annotation;
            return KeyValue.of(MeterTagAnnotationHandler.resolveTagKey(meterTag), MeterTagAnnotationHandler.resolveTagValue(meterTag, object, function, function2));
        });
    }

    private static String resolveTagKey(MeterTag meterTag) {
        return StringUtils.isNotBlank(meterTag.value()) ? meterTag.value() : meterTag.key();
    }

    static String resolveTagValue(MeterTag meterTag, Object object, Function<Class<? extends ValueResolver>, ? extends ValueResolver> function, Function<Class<? extends ValueExpressionResolver>, ? extends ValueExpressionResolver> function2) {
        String string = null;
        if (meterTag.resolver() != NoOpValueResolver.class) {
            ValueResolver valueResolver = function.apply(meterTag.resolver());
            string = valueResolver.resolve(object);
        } else if (StringUtils.isNotBlank(meterTag.expression())) {
            string = function2.apply(ValueExpressionResolver.class).resolve(meterTag.expression(), object);
        } else if (object != null) {
            string = object.toString();
        }
        return string == null ? "" : string;
    }
}

