/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.StrongReferenceGaugeFunction;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

public interface TimeGauge
extends Gauge {
    public static <T> Builder<T> builder(String string, @Nullable T t2, TimeUnit timeUnit, ToDoubleFunction<T> toDoubleFunction) {
        return new Builder(string, t2, timeUnit, toDoubleFunction);
    }

    @Incubating(since="1.7.0")
    public static Builder<Supplier<Number>> builder(String string, Supplier<Number> supplier2, TimeUnit timeUnit) {
        return new Builder(string, supplier2, timeUnit, supplier -> {
            Number number = (Number)supplier.get();
            return number == null ? Double.NaN : number.doubleValue();
        }).strongReference(true);
    }

    public TimeUnit baseTimeUnit();

    default public double value(TimeUnit timeUnit) {
        return TimeUtils.convert(this.value(), this.baseTimeUnit(), timeUnit);
    }

    public static class Builder<T> {
        private final String name;
        private final TimeUnit fUnits;
        private final ToDoubleFunction<T> f;
        private Tags tags = Tags.empty();
        private boolean strongReference = false;
        @Nullable
        private final T obj;
        @Nullable
        private String description;

        private Builder(String string, @Nullable T t2, TimeUnit timeUnit, ToDoubleFunction<T> toDoubleFunction) {
            this.name = string;
            this.obj = t2;
            this.fUnits = timeUnit;
            this.f = toDoubleFunction;
        }

        public Builder<T> tags(String ... stringArray) {
            return this.tags(Tags.of(stringArray));
        }

        public Builder<T> tags(Iterable<Tag> iterable) {
            this.tags = this.tags.and(iterable);
            return this;
        }

        public Builder<T> tag(String string, String string2) {
            this.tags = this.tags.and(string, string2);
            return this;
        }

        public Builder<T> description(@Nullable String string) {
            this.description = string;
            return this;
        }

        @Incubating(since="1.7.0")
        public Builder<T> strongReference(boolean bl2) {
            this.strongReference = bl2;
            return this;
        }

        public TimeGauge register(MeterRegistry meterRegistry) {
            return meterRegistry.more().timeGauge(new Meter.Id(this.name, this.tags, null, this.description, Meter.Type.GAUGE), this.obj, this.fUnits, this.strongReference ? new StrongReferenceGaugeFunction<T>(this.obj, this.f) : this.f);
        }
    }
}

