/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.cumulative;

import com.contrastsecurity.thirdparty.imm.core.instrument.AbstractMeter;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.util.TimeUtils;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class CumulativeFunctionTimer<T>
extends AbstractMeter
implements FunctionTimer {
    private final WeakReference<T> ref;
    private final ToLongFunction<T> countFunction;
    private final ToDoubleFunction<T> totalTimeFunction;
    private final TimeUnit totalTimeFunctionUnit;
    private final TimeUnit baseTimeUnit;
    private volatile long lastCount;
    private volatile double lastTime;

    public CumulativeFunctionTimer(Meter.Id id, T t2, ToLongFunction<T> toLongFunction, ToDoubleFunction<T> toDoubleFunction, TimeUnit timeUnit, TimeUnit timeUnit2) {
        super(id);
        this.ref = new WeakReference<T>(t2);
        this.countFunction = toLongFunction;
        this.totalTimeFunction = toDoubleFunction;
        this.totalTimeFunctionUnit = timeUnit;
        this.baseTimeUnit = timeUnit2;
    }

    @Override
    public double count() {
        double d2;
        Object t2 = this.ref.get();
        if (t2 != null) {
            this.lastCount = Math.max(this.countFunction.applyAsLong(t2), 0L);
            d2 = this.lastCount;
        } else {
            d2 = this.lastCount;
        }
        return d2;
    }

    @Override
    public double totalTime(TimeUnit timeUnit) {
        Object t2 = this.ref.get();
        if (t2 != null) {
            this.lastTime = Math.max(TimeUtils.convert(this.totalTimeFunction.applyAsDouble(t2), this.totalTimeFunctionUnit, this.baseTimeUnit()), 0.0);
        }
        return TimeUtils.convert(this.lastTime, this.baseTimeUnit(), timeUnit);
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return this.baseTimeUnit;
    }

    public Meter.Type type() {
        return Meter.Type.TIMER;
    }
}

