/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.distribution;

import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.CountAtBucket;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLongArray;

class FixedBoundaryHistogram {
    final AtomicLongArray values;
    private final double[] buckets;
    private final boolean isCumulativeBucketCounts;

    FixedBoundaryHistogram(double[] dArray, boolean bl2) {
        this.buckets = dArray;
        this.values = new AtomicLongArray(dArray.length);
        this.isCumulativeBucketCounts = bl2;
    }

    long countAtValue(double d2) {
        int n2 = Arrays.binarySearch(this.buckets, d2);
        if (n2 < 0) {
            return 0L;
        }
        return this.values.get(n2);
    }

    void reset() {
        for (int i2 = 0; i2 < this.values.length(); ++i2) {
            this.values.set(i2, 0L);
        }
    }

    void record(long l2) {
        int n2 = this.leastLessThanOrEqualTo(l2);
        if (n2 > -1) {
            this.values.incrementAndGet(n2);
        }
    }

    int leastLessThanOrEqualTo(long l2) {
        int n2 = 0;
        int n3 = this.buckets.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            if (this.buckets[n4] < (double)l2) {
                n2 = n4 + 1;
                continue;
            }
            if (this.buckets[n4] > (double)l2) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return n2 < this.buckets.length ? n2 : -1;
    }

    Iterator<CountAtBucket> countsAtValues(final Iterator<Double> iterator) {
        return new Iterator<CountAtBucket>(){
            private double cumulativeCount = 0.0;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public CountAtBucket next() {
                double d2 = (Double)iterator.next();
                double d3 = FixedBoundaryHistogram.this.countAtValue(d2);
                if (FixedBoundaryHistogram.this.isCumulativeBucketCounts) {
                    this.cumulativeCount += d3;
                    return new CountAtBucket(d2, this.cumulativeCount);
                }
                return new CountAtBucket(d2, d3);
            }
        };
    }
}

