/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.dropwizard;

import com.codahale.metrics.Histogram;
import com.contrastsecurity.thirdparty.imm.core.instrument.AbstractDistributionSummary;
import com.contrastsecurity.thirdparty.imm.core.instrument.Clock;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.TimeWindowMax;
import java.util.concurrent.atomic.DoubleAdder;

public class DropwizardDistributionSummary
extends AbstractDistributionSummary {
    private final Histogram impl;
    private final DoubleAdder totalAmount = new DoubleAdder();
    private final TimeWindowMax max;

    DropwizardDistributionSummary(Meter.Id id, Clock clock, Histogram histogram, DistributionStatisticConfig distributionStatisticConfig, double d2) {
        super(id, clock, distributionStatisticConfig, d2, false);
        this.impl = histogram;
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    @Override
    protected void recordNonNegative(double d2) {
        if (d2 >= 0.0) {
            this.impl.update((long)d2);
            this.totalAmount.add(d2);
            this.max.record(d2);
        }
    }

    @Override
    public long count() {
        return this.impl.getCount();
    }

    @Override
    public double totalAmount() {
        return this.totalAmount.doubleValue();
    }

    @Override
    public double max() {
        return this.max.poll();
    }
}

