/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.observation.contextpropagation;

import com.contrastsecurity.thirdparty.imm.context.ThreadLocalAccessor;
import com.contrastsecurity.thirdparty.imm.observation.Observation;
import com.contrastsecurity.thirdparty.imm.observation.ObservationRegistry;

public class ObservationThreadLocalAccessor
implements ThreadLocalAccessor<Observation> {
    public static final String KEY = "micrometer.observation";
    private static final ObservationRegistry observationRegistry = ObservationRegistry.create();

    public Object key() {
        return KEY;
    }

    public Observation getValue() {
        return observationRegistry.getCurrentObservation();
    }

    public void setValue(Observation observation) {
        observation.openScope();
    }

    public void reset() {
        Observation.Scope scope = observationRegistry.getCurrentObservationScope();
        if (scope != null) {
            scope.reset();
        }
    }

    public void restore(Observation observation) {
        this.reset();
        Observation.Scope scope = observation.getEnclosingScope();
        if (scope != null) {
            scope.makeCurrent();
        }
        this.setValue(observation);
    }
}

