/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.api.common;

import com.contrastsecurity.thirdparty.iot.api.common.AttributeType;
import com.contrastsecurity.thirdparty.iot.api.internal.InternalAttributeKeyImpl;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface AttributeKey<T> {
    public String getKey();

    public AttributeType getType();

    public static AttributeKey<String> stringKey(String string) {
        return InternalAttributeKeyImpl.create(string, AttributeType.STRING);
    }

    public static AttributeKey<Boolean> booleanKey(String string) {
        return InternalAttributeKeyImpl.create(string, AttributeType.BOOLEAN);
    }

    public static AttributeKey<Long> longKey(String string) {
        return InternalAttributeKeyImpl.create(string, AttributeType.LONG);
    }

    public static AttributeKey<Double> doubleKey(String string) {
        return InternalAttributeKeyImpl.create(string, AttributeType.DOUBLE);
    }

    public static AttributeKey<List<String>> stringArrayKey(String string) {
        return InternalAttributeKeyImpl.create(string, AttributeType.STRING_ARRAY);
    }

    public static AttributeKey<List<Boolean>> booleanArrayKey(String string) {
        return InternalAttributeKeyImpl.create(string, AttributeType.BOOLEAN_ARRAY);
    }

    public static AttributeKey<List<Long>> longArrayKey(String string) {
        return InternalAttributeKeyImpl.create(string, AttributeType.LONG_ARRAY);
    }

    public static AttributeKey<List<Double>> doubleArrayKey(String string) {
        return InternalAttributeKeyImpl.create(string, AttributeType.DOUBLE_ARRAY);
    }
}

