/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics;

import com.contrastsecurity.thirdparty.iot.api.metrics.ObservableDoubleMeasurement;
import com.contrastsecurity.thirdparty.iot.api.metrics.ObservableLongMeasurement;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.AbstractInstrument;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.InstrumentType;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.InstrumentValueType;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.SdkObservableInstrument;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.descriptor.Advice;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.CallbackRegistration;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.MeterProviderSharedState;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.MeterSharedState;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.SdkObservableMeasurement;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Consumer;

abstract class AbstractInstrumentBuilder<BuilderT extends AbstractInstrumentBuilder<?>> {
    static final String DEFAULT_UNIT = "";
    private final MeterProviderSharedState meterProviderSharedState;
    private final InstrumentType type;
    private final InstrumentValueType valueType;
    private String description;
    private String unit;
    private Advice advice;
    protected final MeterSharedState meterSharedState;
    protected final String instrumentName;

    AbstractInstrumentBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, InstrumentType instrumentType, InstrumentValueType instrumentValueType, String string, String string2, String string3) {
        this(meterProviderSharedState, meterSharedState, instrumentType, instrumentValueType, string, string2, string3, Advice.empty());
    }

    AbstractInstrumentBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, InstrumentType instrumentType, InstrumentValueType instrumentValueType, String string, String string2, String string3, Advice advice) {
        this.type = instrumentType;
        this.valueType = instrumentValueType;
        this.instrumentName = string;
        this.description = string2;
        this.unit = string3;
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = meterSharedState;
        this.advice = advice;
    }

    protected abstract BuilderT getThis();

    public BuilderT setUnit(String string) {
        this.unit = string;
        return this.getThis();
    }

    public BuilderT setDescription(String string) {
        this.description = string;
        return this.getThis();
    }

    protected <T> T swapBuilder(SwapBuilder<T> swapBuilder) {
        return swapBuilder.newBuilder(this.meterProviderSharedState, this.meterSharedState, this.instrumentName, this.description, this.unit, this.advice);
    }

    protected void setAdvice(Advice advice) {
        this.advice = advice;
    }

    final <I extends AbstractInstrument> I buildSynchronousInstrument(BiFunction<InstrumentDescriptor, WriteableMetricStorage, I> biFunction) {
        InstrumentDescriptor instrumentDescriptor = InstrumentDescriptor.create(this.instrumentName, this.description, this.unit, this.type, this.valueType, this.advice);
        WriteableMetricStorage writeableMetricStorage = this.meterSharedState.registerSynchronousMetricStorage(instrumentDescriptor, this.meterProviderSharedState);
        return (I)((AbstractInstrument)biFunction.apply(instrumentDescriptor, writeableMetricStorage));
    }

    final SdkObservableInstrument registerDoubleAsynchronousInstrument(InstrumentType instrumentType, Consumer<ObservableDoubleMeasurement> consumer) {
        SdkObservableMeasurement sdkObservableMeasurement = this.buildObservableMeasurement(instrumentType);
        Runnable runnable = () -> consumer.accept(sdkObservableMeasurement);
        CallbackRegistration callbackRegistration = CallbackRegistration.create(Collections.singletonList(sdkObservableMeasurement), runnable);
        this.meterSharedState.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.meterSharedState, callbackRegistration);
    }

    final SdkObservableInstrument registerLongAsynchronousInstrument(InstrumentType instrumentType, Consumer<ObservableLongMeasurement> consumer) {
        SdkObservableMeasurement sdkObservableMeasurement = this.buildObservableMeasurement(instrumentType);
        Runnable runnable = () -> consumer.accept(sdkObservableMeasurement);
        CallbackRegistration callbackRegistration = CallbackRegistration.create(Collections.singletonList(sdkObservableMeasurement), runnable);
        this.meterSharedState.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.meterSharedState, callbackRegistration);
    }

    final SdkObservableMeasurement buildObservableMeasurement(InstrumentType instrumentType) {
        InstrumentDescriptor instrumentDescriptor = InstrumentDescriptor.create(this.instrumentName, this.description, this.unit, instrumentType, this.valueType, this.advice);
        return this.meterSharedState.registerObservableMeasurement(instrumentDescriptor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{descriptor=" + InstrumentDescriptor.create(this.instrumentName, this.description, this.unit, this.type, this.valueType, this.advice) + "}";
    }

    @FunctionalInterface
    protected static interface SwapBuilder<T> {
        public T newBuilder(MeterProviderSharedState var1, MeterSharedState var2, String var3, String var4, String var5, Advice var6);
    }
}

