/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator;

import java.util.Arrays;
import javax.annotation.Nullable;

final class AdaptingIntegerArray {
    @Nullable
    private byte[] byteBacking;
    @Nullable
    private short[] shortBacking;
    @Nullable
    private int[] intBacking;
    @Nullable
    private long[] longBacking;
    private ArrayCellSize cellSize;

    AdaptingIntegerArray(int n2) {
        this.cellSize = ArrayCellSize.BYTE;
        this.byteBacking = new byte[n2];
    }

    private AdaptingIntegerArray(AdaptingIntegerArray adaptingIntegerArray) {
        this.cellSize = adaptingIntegerArray.cellSize;
        switch (this.cellSize) {
            case BYTE: {
                this.byteBacking = Arrays.copyOf(adaptingIntegerArray.byteBacking, adaptingIntegerArray.byteBacking.length);
                break;
            }
            case SHORT: {
                this.shortBacking = Arrays.copyOf(adaptingIntegerArray.shortBacking, adaptingIntegerArray.shortBacking.length);
                break;
            }
            case INT: {
                this.intBacking = Arrays.copyOf(adaptingIntegerArray.intBacking, adaptingIntegerArray.intBacking.length);
                break;
            }
            case LONG: {
                this.longBacking = Arrays.copyOf(adaptingIntegerArray.longBacking, adaptingIntegerArray.longBacking.length);
            }
        }
    }

    AdaptingIntegerArray copy() {
        return new AdaptingIntegerArray(this);
    }

    void increment(int n2, long l2) {
        switch (this.cellSize) {
            case BYTE: {
                long l3 = (long)this.byteBacking[n2] + l2;
                if (l3 > 127L) {
                    this.resizeToShort();
                    this.increment(n2, l2);
                    return;
                }
                this.byteBacking[n2] = (byte)l3;
                return;
            }
            case SHORT: {
                long l4 = (long)this.shortBacking[n2] + l2;
                if (l4 > 32767L) {
                    this.resizeToInt();
                    this.increment(n2, l2);
                    return;
                }
                this.shortBacking[n2] = (short)l4;
                return;
            }
            case INT: {
                long l5 = (long)this.intBacking[n2] + l2;
                if (l5 > Integer.MAX_VALUE) {
                    this.resizeToLong();
                    this.increment(n2, l2);
                    return;
                }
                this.intBacking[n2] = (int)l5;
                return;
            }
            case LONG: {
                this.longBacking[n2] = this.longBacking[n2] + l2;
                return;
            }
        }
    }

    long get(int n2) {
        long l2 = 0L;
        switch (this.cellSize) {
            case BYTE: {
                l2 = this.byteBacking[n2];
                break;
            }
            case SHORT: {
                l2 = this.shortBacking[n2];
                break;
            }
            case INT: {
                l2 = this.intBacking[n2];
                break;
            }
            case LONG: {
                l2 = this.longBacking[n2];
            }
        }
        return l2;
    }

    int length() {
        int n2 = 0;
        switch (this.cellSize) {
            case BYTE: {
                n2 = this.byteBacking.length;
                break;
            }
            case SHORT: {
                n2 = this.shortBacking.length;
                break;
            }
            case INT: {
                n2 = this.intBacking.length;
                break;
            }
            case LONG: {
                n2 = this.longBacking.length;
            }
        }
        return n2;
    }

    void clear() {
        switch (this.cellSize) {
            case BYTE: {
                Arrays.fill(this.byteBacking, (byte)0);
                break;
            }
            case SHORT: {
                Arrays.fill(this.shortBacking, (short)0);
                break;
            }
            case INT: {
                Arrays.fill(this.intBacking, 0);
                break;
            }
            case LONG: {
                Arrays.fill(this.longBacking, 0L);
            }
        }
    }

    private void resizeToShort() {
        short[] sArray = new short[this.byteBacking.length];
        for (int i2 = 0; i2 < this.byteBacking.length; ++i2) {
            sArray[i2] = this.byteBacking[i2];
        }
        this.cellSize = ArrayCellSize.SHORT;
        this.shortBacking = sArray;
        this.byteBacking = null;
    }

    private void resizeToInt() {
        int[] nArray = new int[this.shortBacking.length];
        for (int i2 = 0; i2 < this.shortBacking.length; ++i2) {
            nArray[i2] = this.shortBacking[i2];
        }
        this.cellSize = ArrayCellSize.INT;
        this.intBacking = nArray;
        this.shortBacking = null;
    }

    private void resizeToLong() {
        long[] lArray = new long[this.intBacking.length];
        for (int i2 = 0; i2 < this.intBacking.length; ++i2) {
            lArray[i2] = this.intBacking[i2];
        }
        this.cellSize = ArrayCellSize.LONG;
        this.longBacking = lArray;
        this.intBacking = null;
    }

    private static enum ArrayCellSize {
        BYTE,
        SHORT,
        INT,
        LONG;

    }
}

