/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.trace;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.iot.api.trace.Tracer;
import com.contrastsecurity.thirdparty.iot.api.trace.TracerBuilder;
import com.contrastsecurity.thirdparty.iot.api.trace.TracerProvider;
import com.contrastsecurity.thirdparty.iot.sdk.common.Clock;
import com.contrastsecurity.thirdparty.iot.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.iot.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.iot.sdk.internal.ComponentRegistry;
import com.contrastsecurity.thirdparty.iot.sdk.resources.Resource;
import com.contrastsecurity.thirdparty.iot.sdk.trace.IdGenerator;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SdkTracer;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SdkTracerBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SdkTracerProviderBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SpanLimits;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SpanProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.trace.TracerSharedState;
import com.contrastsecurity.thirdparty.iot.sdk.trace.samplers.Sampler;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class SdkTracerProvider
implements TracerProvider,
Closeable {
    private static final e logger = e.a(SdkTracerProvider.class.getName());
    static final String DEFAULT_TRACER_NAME = "";
    private final TracerSharedState sharedState;
    private final ComponentRegistry<SdkTracer> tracerSdkComponentRegistry;

    public static SdkTracerProviderBuilder builder() {
        return new SdkTracerProviderBuilder();
    }

    SdkTracerProvider(Clock clock, IdGenerator idGenerator, Resource resource, Supplier<SpanLimits> supplier, Sampler sampler, List<SpanProcessor> list) {
        this.sharedState = new TracerSharedState(clock, idGenerator, resource, supplier, sampler, list);
        this.tracerSdkComponentRegistry = new ComponentRegistry<SdkTracer>(instrumentationScopeInfo -> new SdkTracer(this.sharedState, (InstrumentationScopeInfo)instrumentationScopeInfo));
    }

    @Override
    public Tracer get(String string) {
        return this.tracerBuilder(string).build();
    }

    @Override
    public Tracer get(String string, String string2) {
        return this.tracerBuilder(string).setInstrumentationVersion(string2).build();
    }

    @Override
    public TracerBuilder tracerBuilder(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            logger.f("Tracer requested without instrumentation scope name.");
            string = DEFAULT_TRACER_NAME;
        }
        return new SdkTracerBuilder(this.tracerSdkComponentRegistry, string);
    }

    public SpanLimits getSpanLimits() {
        return this.sharedState.getSpanLimits();
    }

    public Sampler getSampler() {
        return this.sharedState.getSampler();
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            logger.a(e.a.d, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getActiveSpanProcessor().forceFlush();
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "SdkTracerProvider{clock=" + this.sharedState.getClock() + ", idGenerator=" + this.sharedState.getIdGenerator() + ", resource=" + this.sharedState.getResource() + ", spanLimitsSupplier=" + this.sharedState.getSpanLimits() + ", sampler=" + this.sharedState.getSampler() + ", spanProcessor=" + this.sharedState.getActiveSpanProcessor() + '}';
    }
}

