/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.trace;

import com.contrastsecurity.thirdparty.iot.sdk.common.Clock;
import com.contrastsecurity.thirdparty.iot.sdk.resources.Resource;
import com.contrastsecurity.thirdparty.iot.sdk.trace.IdGenerator;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SdkTracerProvider;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SpanLimits;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SpanProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.trace.samplers.Sampler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class SdkTracerProviderBuilder {
    private static final Sampler DEFAULT_SAMPLER = Sampler.parentBased(Sampler.alwaysOn());
    private final List<SpanProcessor> spanProcessors = new ArrayList<SpanProcessor>();
    private Clock clock = Clock.getDefault();
    private IdGenerator idsGenerator = IdGenerator.random();
    private Resource resource = Resource.getDefault();
    private Supplier<SpanLimits> spanLimitsSupplier = SpanLimits::getDefault;
    private Sampler sampler = DEFAULT_SAMPLER;

    public SdkTracerProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkTracerProviderBuilder setIdGenerator(IdGenerator idGenerator) {
        Objects.requireNonNull(idGenerator, "idGenerator");
        this.idsGenerator = idGenerator;
        return this;
    }

    public SdkTracerProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkTracerProviderBuilder addResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = this.resource.merge(resource);
        return this;
    }

    public SdkTracerProviderBuilder setSpanLimits(SpanLimits spanLimits) {
        Objects.requireNonNull(spanLimits, "spanLimits");
        this.spanLimitsSupplier = () -> spanLimits;
        return this;
    }

    public SdkTracerProviderBuilder setSpanLimits(Supplier<SpanLimits> supplier) {
        Objects.requireNonNull(supplier, "spanLimitsSupplier");
        this.spanLimitsSupplier = supplier;
        return this;
    }

    public SdkTracerProviderBuilder setSampler(Sampler sampler) {
        Objects.requireNonNull(sampler, "sampler");
        this.sampler = sampler;
        return this;
    }

    public SdkTracerProviderBuilder addSpanProcessor(SpanProcessor spanProcessor) {
        this.spanProcessors.add(spanProcessor);
        return this;
    }

    public SdkTracerProvider build() {
        return new SdkTracerProvider(this.clock, this.idsGenerator, this.resource, this.spanLimitsSupplier, this.sampler, this.spanProcessors);
    }

    SdkTracerProviderBuilder() {
    }
}

