/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.trace.export;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.iot.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.iot.sdk.trace.data.SpanData;
import com.contrastsecurity.thirdparty.iot.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

final class MultiSpanExporter
implements SpanExporter {
    private static final e logger = e.a(MultiSpanExporter.class.getName());
    private final SpanExporter[] spanExporters;

    static SpanExporter create(List<SpanExporter> list) {
        return new MultiSpanExporter(list.toArray(new SpanExporter[0]));
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> collection) {
        ArrayList<CompletableResultCode> arrayList = new ArrayList<CompletableResultCode>(this.spanExporters.length);
        for (SpanExporter spanExporter : this.spanExporters) {
            CompletableResultCode completableResultCode;
            try {
                completableResultCode = spanExporter.export(collection);
            }
            catch (RuntimeException runtimeException) {
                Throwables.throwIfCritical(runtimeException);
                RuntimeException runtimeException2 = runtimeException;
                logger.a(e.a.c, "Exception thrown by the export.", runtimeException2);
                arrayList.add(CompletableResultCode.ofFailure());
                continue;
            }
            arrayList.add(completableResultCode);
        }
        return CompletableResultCode.ofAll(arrayList);
    }

    @Override
    public CompletableResultCode flush() {
        ArrayList<CompletableResultCode> arrayList = new ArrayList<CompletableResultCode>(this.spanExporters.length);
        for (SpanExporter spanExporter : this.spanExporters) {
            CompletableResultCode completableResultCode;
            try {
                completableResultCode = spanExporter.flush();
            }
            catch (RuntimeException runtimeException) {
                Throwables.throwIfCritical(runtimeException);
                RuntimeException runtimeException2 = runtimeException;
                logger.a(e.a.c, "Exception thrown by the flush.", runtimeException2);
                arrayList.add(CompletableResultCode.ofFailure());
                continue;
            }
            arrayList.add(completableResultCode);
        }
        return CompletableResultCode.ofAll(arrayList);
    }

    @Override
    public CompletableResultCode shutdown() {
        ArrayList<CompletableResultCode> arrayList = new ArrayList<CompletableResultCode>(this.spanExporters.length);
        for (SpanExporter spanExporter : this.spanExporters) {
            CompletableResultCode completableResultCode;
            try {
                completableResultCode = spanExporter.shutdown();
            }
            catch (RuntimeException runtimeException) {
                Throwables.throwIfCritical(runtimeException);
                RuntimeException runtimeException2 = runtimeException;
                logger.a(e.a.c, "Exception thrown by the shutdown.", runtimeException2);
                arrayList.add(CompletableResultCode.ofFailure());
                continue;
            }
            arrayList.add(completableResultCode);
        }
        return CompletableResultCode.ofAll(arrayList);
    }

    private MultiSpanExporter(SpanExporter[] spanExporterArray) {
        this.spanExporters = spanExporterArray;
    }

    public String toString() {
        return "MultiSpanExporter{spanExporters=" + Arrays.toString(this.spanExporters) + '}';
    }
}

