/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.nsjsqlp.util.deparser;

import com.contrastsecurity.thirdparty.nsjsqlp.expression.Expression;
import com.contrastsecurity.thirdparty.nsjsqlp.expression.ExpressionVisitor;
import com.contrastsecurity.thirdparty.nsjsqlp.expression.operators.relational.ExpressionList;
import com.contrastsecurity.thirdparty.nsjsqlp.expression.operators.relational.ItemsListVisitor;
import com.contrastsecurity.thirdparty.nsjsqlp.expression.operators.relational.MultiExpressionList;
import com.contrastsecurity.thirdparty.nsjsqlp.schema.Column;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.select.SelectVisitor;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.select.SubSelect;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.select.WithItem;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.upsert.Upsert;
import java.util.Iterator;

public class UpsertDeParser
implements ItemsListVisitor {
    private StringBuilder buffer;
    private ExpressionVisitor expressionVisitor;
    private SelectVisitor selectVisitor;

    public UpsertDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
    }

    public void deParse(Upsert upsert) {
        this.buffer.append("UPSERT INTO ");
        this.buffer.append(upsert.getTable().getFullyQualifiedName());
        if (upsert.getColumns() != null) {
            this.appendColumns(upsert);
        }
        if (upsert.getItemsList() != null) {
            upsert.getItemsList().accept(this);
        }
        if (upsert.getSelect() != null) {
            this.appendSelect(upsert);
        }
        if (upsert.isUseDuplicate()) {
            this.appendDuplicate(upsert);
        }
    }

    private void appendColumns(Upsert upsert) {
        this.buffer.append(" (");
        Iterator<Column> iterator = upsert.getColumns().iterator();
        while (iterator.hasNext()) {
            Column column = iterator.next();
            this.buffer.append(column.getColumnName());
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    private void appendSelect(Upsert upsert) {
        this.buffer.append(" ");
        if (upsert.isUseSelectBrackets()) {
            this.buffer.append("(");
        }
        if (upsert.getSelect().getWithItemsList() != null) {
            this.buffer.append("WITH ");
            for (WithItem withItem : upsert.getSelect().getWithItemsList()) {
                withItem.accept(this.selectVisitor);
            }
            this.buffer.append(" ");
        }
        upsert.getSelect().getSelectBody().accept(this.selectVisitor);
        if (upsert.isUseSelectBrackets()) {
            this.buffer.append(")");
        }
    }

    private void appendDuplicate(Upsert upsert) {
        this.buffer.append(" ON DUPLICATE KEY UPDATE ");
        for (int i2 = 0; i2 < upsert.getDuplicateUpdateColumns().size(); ++i2) {
            Column column = upsert.getDuplicateUpdateColumns().get(i2);
            this.buffer.append(column.getFullyQualifiedName()).append(" = ");
            Expression expression = upsert.getDuplicateUpdateExpressionList().get(i2);
            expression.accept(this.expressionVisitor);
            if (i2 >= upsert.getDuplicateUpdateColumns().size() - 1) continue;
            this.buffer.append(", ");
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        this.buffer.append(" VALUES (");
        Iterator<Expression> iterator = expressionList.getExpressions().iterator();
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            expression.accept(this.expressionVisitor);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(MultiExpressionList multiExpressionList) {
        this.buffer.append(" VALUES ");
        Iterator<ExpressionList> iterator = multiExpressionList.getExprList().iterator();
        while (iterator.hasNext()) {
            this.buffer.append("(");
            Iterator<Expression> iterator2 = iterator.next().getExpressions().iterator();
            while (iterator2.hasNext()) {
                Expression expression = iterator2.next();
                expression.accept(this.expressionVisitor);
                if (!iterator2.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    public void setSelectVisitor(SelectVisitor selectVisitor) {
        this.selectVisitor = selectVisitor;
    }
}

