/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.io.input;

import java.io.IOException;
import java.io.InputStream;

public class UnixLineEndingInputStream
extends InputStream {
    private boolean slashNSeen = false;
    private boolean slashRSeen = false;
    private boolean eofSeen = false;
    private final InputStream target;
    private final boolean ensureLineFeedAtEndOfFile;

    public UnixLineEndingInputStream(InputStream inputStream, boolean bl2) {
        this.target = inputStream;
        this.ensureLineFeedAtEndOfFile = bl2;
    }

    private int readWithUpdate() throws IOException {
        int n2 = this.target.read();
        boolean bl2 = this.eofSeen = n2 == -1;
        if (this.eofSeen) {
            return n2;
        }
        this.slashNSeen = n2 == 10;
        this.slashRSeen = n2 == 13;
        return n2;
    }

    @Override
    public int read() throws IOException {
        boolean bl2 = this.slashRSeen;
        if (this.eofSeen) {
            return this.eofGame(bl2);
        }
        int n2 = this.readWithUpdate();
        if (this.eofSeen) {
            return this.eofGame(bl2);
        }
        if (this.slashRSeen) {
            return 10;
        }
        if (bl2 && this.slashNSeen) {
            return this.read();
        }
        return n2;
    }

    private int eofGame(boolean bl2) {
        if (bl2 || !this.ensureLineFeedAtEndOfFile) {
            return -1;
        }
        if (!this.slashNSeen) {
            this.slashNSeen = true;
            return 10;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.target.close();
    }

    @Override
    public synchronized void mark(int n2) {
        throw new UnsupportedOperationException("Mark notsupported");
    }
}

