/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.lang3.event;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.ArrayUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.Validate;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.exception.ExceptionUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.function.FailableConsumer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventListenerSupport<L>
implements Serializable {
    private static final long serialVersionUID = 3593265990380473632L;
    private List<L> listeners = new CopyOnWriteArrayList<L>();
    private transient L proxy;
    private transient L[] prototypeArray;

    public static <T> EventListenerSupport<T> create(Class<T> clazz) {
        return new EventListenerSupport<T>(clazz);
    }

    private EventListenerSupport() {
    }

    public EventListenerSupport(Class<L> clazz) {
        this(clazz, Thread.currentThread().getContextClassLoader());
    }

    public EventListenerSupport(Class<L> clazz, ClassLoader classLoader) {
        this();
        Objects.requireNonNull(clazz, "listenerInterface");
        Objects.requireNonNull(classLoader, "classLoader");
        Validate.isTrue(clazz.isInterface(), "Class %s is not an interface", clazz.getName());
        super.initializeTransientFields(clazz, classLoader);
    }

    public void addListener(L l2) {
        this.addListener(l2, true);
    }

    public void addListener(L l2, boolean bl2) {
        Objects.requireNonNull(l2, "listener");
        if (bl2 || !this.listeners.contains(l2)) {
            this.listeners.add(l2);
        }
    }

    protected InvocationHandler createInvocationHandler() {
        return new ProxyInvocationHandler();
    }

    private void createProxy(Class<L> clazz, ClassLoader classLoader) {
        this.proxy = clazz.cast(Proxy.newProxyInstance(classLoader, new Class[]{clazz}, this.createInvocationHandler()));
    }

    public L fire() {
        return this.proxy;
    }

    int getListenerCount() {
        return this.listeners.size();
    }

    public L[] getListeners() {
        return this.listeners.toArray(this.prototypeArray);
    }

    private void initializeTransientFields(Class<L> clazz, ClassLoader classLoader) {
        this.prototypeArray = ArrayUtils.newInstance(clazz, 0);
        this.createProxy(clazz, classLoader);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object[] objectArray = (Object[])objectInputStream.readObject();
        this.listeners = new CopyOnWriteArrayList<Object>(objectArray);
        Class<Object> clazz = ArrayUtils.getComponentType(objectArray);
        this.initializeTransientFields(clazz, Thread.currentThread().getContextClassLoader());
    }

    public void removeListener(L l2) {
        Objects.requireNonNull(l2, "listener");
        this.listeners.remove(l2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ArrayList<L> arrayList = new ArrayList<L>();
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(new ByteArrayOutputStream());
        for (L l2 : this.listeners) {
            try {
                objectOutputStream2.writeObject(l2);
                arrayList.add(l2);
            }
            catch (IOException iOException) {
                objectOutputStream2 = new ObjectOutputStream(new ByteArrayOutputStream());
            }
        }
        objectOutputStream.writeObject(arrayList.toArray(this.prototypeArray));
    }

    protected class ProxyInvocationHandler
    implements InvocationHandler {
        private final FailableConsumer<Throwable, IllegalAccessException> handler;

        public ProxyInvocationHandler() {
            this(ExceptionUtils::rethrow);
        }

        public ProxyInvocationHandler(FailableConsumer<Throwable, IllegalAccessException> failableConsumer) {
            this.handler = Objects.requireNonNull(failableConsumer);
        }

        protected void handle(Throwable throwable) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.handler.accept(throwable);
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            for (Object e2 : EventListenerSupport.this.listeners) {
                try {
                    method.invoke(e2, objectArray);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    this.handle(throwable2);
                }
            }
            return null;
        }
    }
}

