/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.client.protocol;

import com.contrastsecurity.thirdparty.oa4j.commons.logging.Log;
import com.contrastsecurity.thirdparty.oa4j.commons.logging.LogFactory;
import com.contrastsecurity.thirdparty.oa4j.http.HttpException;
import com.contrastsecurity.thirdparty.oa4j.http.HttpHost;
import com.contrastsecurity.thirdparty.oa4j.http.HttpRequest;
import com.contrastsecurity.thirdparty.oa4j.http.HttpRequestInterceptor;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.auth.AuthProtocolState;
import com.contrastsecurity.thirdparty.oa4j.http.auth.AuthScheme;
import com.contrastsecurity.thirdparty.oa4j.http.auth.AuthScope;
import com.contrastsecurity.thirdparty.oa4j.http.auth.AuthState;
import com.contrastsecurity.thirdparty.oa4j.http.auth.Credentials;
import com.contrastsecurity.thirdparty.oa4j.http.client.AuthCache;
import com.contrastsecurity.thirdparty.oa4j.http.client.CredentialsProvider;
import com.contrastsecurity.thirdparty.oa4j.http.client.protocol.HttpClientContext;
import com.contrastsecurity.thirdparty.oa4j.http.conn.routing.RouteInfo;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestAuthCache
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        AuthScheme authScheme;
        Object object;
        AuthState authState;
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(httpContext, "HTTP context");
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        AuthCache authCache = httpClientContext.getAuthCache();
        if (authCache == null) {
            this.log.debug("Auth cache not set in the context");
            return;
        }
        CredentialsProvider credentialsProvider = httpClientContext.getCredentialsProvider();
        if (credentialsProvider == null) {
            this.log.debug("Credentials provider not set in the context");
            return;
        }
        RouteInfo routeInfo = httpClientContext.getHttpRoute();
        if (routeInfo == null) {
            this.log.debug("Route info not set in the context");
            return;
        }
        HttpHost httpHost = httpClientContext.getTargetHost();
        if (httpHost == null) {
            this.log.debug("Target host not set in the context");
            return;
        }
        if (httpHost.getPort() < 0) {
            httpHost = new HttpHost(httpHost.getHostName(), routeInfo.getTargetHost().getPort(), httpHost.getSchemeName());
        }
        if ((authState = httpClientContext.getTargetAuthState()) != null && authState.getState() == AuthProtocolState.UNCHALLENGED && (object = authCache.get(httpHost)) != null) {
            this.doPreemptiveAuth(httpHost, (AuthScheme)object, authState, credentialsProvider);
        }
        object = routeInfo.getProxyHost();
        AuthState authState2 = httpClientContext.getProxyAuthState();
        if (object != null && authState2 != null && authState2.getState() == AuthProtocolState.UNCHALLENGED && (authScheme = authCache.get((HttpHost)object)) != null) {
            this.doPreemptiveAuth((HttpHost)object, authScheme, authState2, credentialsProvider);
        }
    }

    private void doPreemptiveAuth(HttpHost httpHost, AuthScheme authScheme, AuthState authState, CredentialsProvider credentialsProvider) {
        AuthScope authScope;
        Credentials credentials;
        String string = authScheme.getSchemeName();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Re-using cached '" + string + "' auth scheme for " + httpHost);
        }
        if ((credentials = credentialsProvider.getCredentials(authScope = new AuthScope(httpHost, AuthScope.ANY_REALM, string))) != null) {
            authState.update(authScheme, credentials);
        } else {
            this.log.debug("No credentials for preemptive authentication");
        }
    }
}

