/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.auth;

import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.auth.AuthScheme;
import com.contrastsecurity.thirdparty.oa4j.http.auth.AuthSchemeFactory;
import com.contrastsecurity.thirdparty.oa4j.http.auth.AuthSchemeProvider;
import com.contrastsecurity.thirdparty.oa4j.http.impl.auth.SPNegoScheme;
import com.contrastsecurity.thirdparty.oa4j.http.params.HttpParams;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class SPNegoSchemeFactory
implements AuthSchemeFactory,
AuthSchemeProvider {
    private final boolean stripPort;
    private final boolean useCanonicalHostname;

    public SPNegoSchemeFactory(boolean bl2, boolean bl3) {
        this.stripPort = bl2;
        this.useCanonicalHostname = bl3;
    }

    public SPNegoSchemeFactory(boolean bl2) {
        this.stripPort = bl2;
        this.useCanonicalHostname = true;
    }

    public SPNegoSchemeFactory() {
        this(true, true);
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    @Override
    public AuthScheme newInstance(HttpParams httpParams) {
        return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
    }

    @Override
    public AuthScheme create(HttpContext httpContext) {
        return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
    }
}

