/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.client;

import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.client.HttpClient;
import com.contrastsecurity.thirdparty.oa4j.http.client.ResponseHandler;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.HttpUriRequest;
import com.contrastsecurity.thirdparty.oa4j.http.concurrent.FutureCallback;
import com.contrastsecurity.thirdparty.oa4j.http.impl.client.FutureRequestExecutionMetrics;
import com.contrastsecurity.thirdparty.oa4j.http.impl.client.HttpRequestFutureTask;
import com.contrastsecurity.thirdparty.oa4j.http.impl.client.HttpRequestTaskCallable;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpContext;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

@Contract(threading=ThreadingBehavior.SAFE)
public class FutureRequestExecutionService
implements Closeable {
    private final HttpClient httpclient;
    private final ExecutorService executorService;
    private final FutureRequestExecutionMetrics metrics = new FutureRequestExecutionMetrics();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public FutureRequestExecutionService(HttpClient httpClient, ExecutorService executorService) {
        this.httpclient = httpClient;
        this.executorService = executorService;
    }

    public <T> HttpRequestFutureTask<T> execute(HttpUriRequest httpUriRequest, HttpContext httpContext, ResponseHandler<T> responseHandler) {
        return this.execute(httpUriRequest, httpContext, responseHandler, null);
    }

    public <T> HttpRequestFutureTask<T> execute(HttpUriRequest httpUriRequest, HttpContext httpContext, ResponseHandler<T> responseHandler, FutureCallback<T> futureCallback) {
        if (this.closed.get()) {
            throw new IllegalStateException("Close has been called on this httpclient instance.");
        }
        this.metrics.getScheduledConnections().incrementAndGet();
        HttpRequestTaskCallable<T> httpRequestTaskCallable = new HttpRequestTaskCallable<T>(this.httpclient, httpUriRequest, httpContext, responseHandler, futureCallback, this.metrics);
        HttpRequestFutureTask<T> httpRequestFutureTask = new HttpRequestFutureTask<T>(httpUriRequest, httpRequestTaskCallable);
        this.executorService.execute(httpRequestFutureTask);
        return httpRequestFutureTask;
    }

    public FutureRequestExecutionMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void close() throws IOException {
        this.closed.set(true);
        this.executorService.shutdownNow();
        if (this.httpclient instanceof Closeable) {
            ((Closeable)((Object)this.httpclient)).close();
        }
    }
}

