/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.pool;

import com.contrastsecurity.thirdparty.oa4j.http.HttpClientConnection;
import com.contrastsecurity.thirdparty.oa4j.http.HttpHost;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.config.ConnectionConfig;
import com.contrastsecurity.thirdparty.oa4j.http.config.SocketConfig;
import com.contrastsecurity.thirdparty.oa4j.http.impl.pool.BasicConnFactory;
import com.contrastsecurity.thirdparty.oa4j.http.impl.pool.BasicPoolEntry;
import com.contrastsecurity.thirdparty.oa4j.http.params.HttpParams;
import com.contrastsecurity.thirdparty.oa4j.http.pool.AbstractConnPool;
import com.contrastsecurity.thirdparty.oa4j.http.pool.ConnFactory;
import java.util.concurrent.atomic.AtomicLong;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams httpParams) {
        super(new BasicConnFactory(httpParams), 2, 20);
    }

    public BasicConnPool(SocketConfig socketConfig, ConnectionConfig connectionConfig) {
        super(new BasicConnFactory(socketConfig, connectionConfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost httpHost, HttpClientConnection httpClientConnection) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), httpHost, httpClientConnection);
    }

    @Override
    protected boolean validate(BasicPoolEntry basicPoolEntry) {
        return !((HttpClientConnection)basicPoolEntry.getConnection()).isStale();
    }
}

