/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.protocol;

import com.contrastsecurity.thirdparty.oa4j.http.HttpEntity;
import com.contrastsecurity.thirdparty.oa4j.http.HttpEntityEnclosingRequest;
import com.contrastsecurity.thirdparty.oa4j.http.HttpException;
import com.contrastsecurity.thirdparty.oa4j.http.HttpRequest;
import com.contrastsecurity.thirdparty.oa4j.http.HttpRequestInterceptor;
import com.contrastsecurity.thirdparty.oa4j.http.HttpVersion;
import com.contrastsecurity.thirdparty.oa4j.http.ProtocolException;
import com.contrastsecurity.thirdparty.oa4j.http.ProtocolVersion;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestContent
implements HttpRequestInterceptor {
    private final boolean overwrite;

    public RequestContent() {
        this(false);
    }

    public RequestContent(boolean bl2) {
        this.overwrite = bl2;
    }

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            if (this.overwrite) {
                httpRequest.removeHeaders("Transfer-Encoding");
                httpRequest.removeHeaders("Content-Length");
            } else {
                if (httpRequest.containsHeader("Transfer-Encoding")) {
                    throw new ProtocolException("Transfer-encoding header already present");
                }
                if (httpRequest.containsHeader("Content-Length")) {
                    throw new ProtocolException("Content-Length header already present");
                }
            }
            ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
            HttpEntity httpEntity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
            if (httpEntity == null) {
                httpRequest.addHeader("Content-Length", "0");
                return;
            }
            if (httpEntity.isChunked() || httpEntity.getContentLength() < 0L) {
                if (protocolVersion.lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + protocolVersion);
                }
                httpRequest.addHeader("Transfer-Encoding", "chunked");
            } else {
                httpRequest.addHeader("Content-Length", Long.toString(httpEntity.getContentLength()));
            }
            if (httpEntity.getContentType() != null && !httpRequest.containsHeader("Content-Type")) {
                httpRequest.addHeader(httpEntity.getContentType());
            }
            if (httpEntity.getContentEncoding() != null && !httpRequest.containsHeader("Content-Encoding")) {
                httpRequest.addHeader(httpEntity.getContentEncoding());
            }
        }
    }
}

