/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async;

import com.contrastsecurity.thirdparty.com.lmax.disruptor.BlockingWaitStrategy;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.BusySpinWaitStrategy;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.SleepingWaitStrategy;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.WaitStrategy;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.YieldingWaitStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.AsyncWaitStrategyFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.TimeoutBlockingWaitStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertiesUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Strings;
import java.util.concurrent.TimeUnit;

class DefaultAsyncWaitStrategyFactory
implements AsyncWaitStrategyFactory {
    static final String DEFAULT_WAIT_STRATEGY_CLASSNAME = TimeoutBlockingWaitStrategy.class.getName();
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String propertyName;

    public DefaultAsyncWaitStrategyFactory(String string) {
        this.propertyName = string;
    }

    @Override
    public WaitStrategy createWaitStrategy() {
        String string;
        String string2 = PropertiesUtil.getProperties().getStringProperty(this.propertyName, "TIMEOUT");
        LOGGER.trace("DefaultAsyncWaitStrategyFactory property {}={}", (Object)this.propertyName, (Object)string2);
        switch (string = Strings.toRootUpperCase(string2)) {
            case "SLEEP": {
                long l2 = DefaultAsyncWaitStrategyFactory.parseAdditionalLongProperty(this.propertyName, "SleepTimeNs", 100L);
                String string3 = DefaultAsyncWaitStrategyFactory.getFullPropertyKey(this.propertyName, "Retries");
                int n2 = PropertiesUtil.getProperties().getIntegerProperty(string3, 200);
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating SleepingWaitStrategy(retries={}, sleepTimeNs={})", (Object)n2, (Object)l2);
                return new SleepingWaitStrategy(n2, l2);
            }
            case "YIELD": {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating YieldingWaitStrategy");
                return new YieldingWaitStrategy();
            }
            case "BLOCK": {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating BlockingWaitStrategy");
                return new BlockingWaitStrategy();
            }
            case "BUSYSPIN": {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating BusySpinWaitStrategy");
                return new BusySpinWaitStrategy();
            }
            case "TIMEOUT": {
                return DefaultAsyncWaitStrategyFactory.createDefaultWaitStrategy(this.propertyName);
            }
        }
        return DefaultAsyncWaitStrategyFactory.createDefaultWaitStrategy(this.propertyName);
    }

    static WaitStrategy createDefaultWaitStrategy(String string) {
        long l2 = DefaultAsyncWaitStrategyFactory.parseAdditionalLongProperty(string, "Timeout", 10L);
        LOGGER.trace("DefaultAsyncWaitStrategyFactory creating TimeoutBlockingWaitStrategy(timeout={}, unit=MILLIS)", (Object)l2);
        return new TimeoutBlockingWaitStrategy(l2, TimeUnit.MILLISECONDS);
    }

    private static String getFullPropertyKey(String string, String string2) {
        if (string.startsWith("AsyncLogger.")) {
            return "AsyncLogger." + string2;
        }
        if (string.startsWith("AsyncLoggerConfig.")) {
            return "AsyncLoggerConfig." + string2;
        }
        return string + string2;
    }

    private static long parseAdditionalLongProperty(String string, String string2, long l2) {
        String string3 = DefaultAsyncWaitStrategyFactory.getFullPropertyKey(string, string2);
        return PropertiesUtil.getProperties().getLongProperty(string3, l2);
    }
}

