/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.ExceptionHandler;
import com.contrastsecurity.thirdparty.com.lmax.disruptor.WaitStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.AsyncLoggerConfigDefaultExceptionHandler;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.AsyncLoggerConfigDisruptor;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.AsyncLoggerDefaultExceptionHandler;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.AsyncWaitStrategyFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.DefaultAsyncWaitStrategyFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.RingBufferLogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Constants;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Integers;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertiesUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

final class DisruptorUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int RINGBUFFER_MIN_SIZE = 128;
    private static final int RINGBUFFER_DEFAULT_SIZE = 262144;
    private static final int RINGBUFFER_NO_GC_DEFAULT_SIZE = 4096;
    static final boolean ASYNC_LOGGER_SYNCHRONIZE_ENQUEUE_WHEN_QUEUE_FULL = PropertiesUtil.getProperties().getBooleanProperty("AsyncLogger.SynchronizeEnqueueWhenQueueFull", true);
    static final boolean ASYNC_CONFIG_SYNCHRONIZE_ENQUEUE_WHEN_QUEUE_FULL = PropertiesUtil.getProperties().getBooleanProperty("AsyncLoggerConfig.SynchronizeEnqueueWhenQueueFull", true);

    private DisruptorUtil() {
    }

    static WaitStrategy createWaitStrategy(String string, AsyncWaitStrategyFactory asyncWaitStrategyFactory) {
        if (asyncWaitStrategyFactory == null) {
            LOGGER.debug("No AsyncWaitStrategyFactory was configured in the configuration, using default factory...");
            return new DefaultAsyncWaitStrategyFactory(string).createWaitStrategy();
        }
        LOGGER.debug("Using configured AsyncWaitStrategyFactory {}", (Object)asyncWaitStrategyFactory.getClass().getName());
        return asyncWaitStrategyFactory.createWaitStrategy();
    }

    static int calculateRingBufferSize(String string) {
        int n2 = Constants.ENABLE_THREADLOCALS ? 4096 : 262144;
        String string2 = PropertiesUtil.getProperties().getStringProperty(string, String.valueOf(n2));
        try {
            int n3 = Integers.parseInt(string2);
            if (n3 < 128) {
                n3 = 128;
                LOGGER.warn("Invalid RingBufferSize {}, using minimum size {}.", (Object)string2, (Object)128);
            }
            n2 = n3;
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.warn("Invalid RingBufferSize {}, using default size {}.", (Object)string2, (Object)n2);
        }
        return Integers.ceilingNextPowerOfTwo(n2);
    }

    static ExceptionHandler<RingBufferLogEvent> getAsyncLoggerExceptionHandler() {
        String string = PropertiesUtil.getProperties().getStringProperty("AsyncLogger.ExceptionHandler");
        if (string == null) {
            return new AsyncLoggerDefaultExceptionHandler();
        }
        try {
            Class<?> clazz = Loader.loadClass(string);
            return (ExceptionHandler)clazz.newInstance();
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.debug("Invalid AsyncLogger.ExceptionHandler value: error creating {}: ", (Object)string, (Object)exception2);
            return new AsyncLoggerDefaultExceptionHandler();
        }
    }

    static ExceptionHandler<AsyncLoggerConfigDisruptor.Log4jEventWrapper> getAsyncLoggerConfigExceptionHandler() {
        String string = PropertiesUtil.getProperties().getStringProperty("AsyncLoggerConfig.ExceptionHandler");
        if (string == null) {
            return new AsyncLoggerConfigDefaultExceptionHandler();
        }
        try {
            Class<?> clazz = Loader.loadClass(string);
            return (ExceptionHandler)clazz.newInstance();
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.debug("Invalid AsyncLoggerConfig.ExceptionHandler value: error creating {}: ", (Object)string, (Object)exception2);
            return new AsyncLoggerConfigDefaultExceptionHandler();
        }
    }

    public static long getExecutorThreadId(ExecutorService executorService) {
        Future<Long> future = executorService.submit(() -> Thread.currentThread().getId());
        try {
            return future.get();
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            String string = "Could not obtain executor thread Id. Giving up to avoid the risk of application deadlock.";
            throw new IllegalStateException("Could not obtain executor thread Id. Giving up to avoid the risk of application deadlock.", exception2);
        }
    }
}

