/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Level;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.AbstractConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.ConfigurationSource;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.DefaultConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.OrderComparator;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.composite.CompositeConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.util.PluginManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.util.PluginType;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.lookup.ConfigurationStrSubstitutor;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.lookup.Interpolator;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.lookup.StrSubstitutor;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.AuthorizationProvider;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.BasicAuthorizationProvider;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.NetUtils;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.ReflectionUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.LoaderUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertiesUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class ConfigurationFactory
extends ConfigurationBuilderFactory {
    public static final String CONFIGURATION_FACTORY_PROPERTY = "com.contrastsecurity.thirdparty.log4j.configurationFactory";
    public static final String CONFIGURATION_FILE_PROPERTY = "com.contrastsecurity.thirdparty.log4j.configurationFile";
    public static final String LOG4J1_CONFIGURATION_FILE_PROPERTY = "com.contrastsecurity.thirdparty.log4j.configuration";
    public static final String LOG4J1_EXPERIMENTAL = "log4j1.compatibility";
    public static final String AUTHORIZATION_PROVIDER = "authorizationProvider";
    public static final String CATEGORY = "ConfigurationFactory";
    protected static final Logger LOGGER = StatusLogger.getLogger();
    protected static final String TEST_PREFIX = "com/contrastsecurity/thirdparty/log4j2-test";
    protected static final String DEFAULT_PREFIX = "log4j2";
    protected static final String LOG4J1_VERSION = "1";
    protected static final String LOG4J2_VERSION = "2";
    private static final String CLASS_LOADER_SCHEME = "classloader";
    private static final String CLASS_PATH_SCHEME = "classpath";
    private static final String OVERRIDE_PARAM = "override";
    private static volatile List<ConfigurationFactory> factories;
    private static ConfigurationFactory configFactory;
    protected final StrSubstitutor substitutor = new ConfigurationStrSubstitutor(new Interpolator());
    private static final Lock LOCK;
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final String[] PREFIXES;
    private static volatile AuthorizationProvider authorizationProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationFactory getInstance() {
        if (factories == null) {
            LOCK.lock();
            try {
                if (factories == null) {
                    ArrayList<ConfigurationFactory> arrayList = new ArrayList<ConfigurationFactory>();
                    PropertiesUtil propertiesUtil = PropertiesUtil.getProperties();
                    String string = propertiesUtil.getStringProperty(CONFIGURATION_FACTORY_PROPERTY);
                    if (string != null) {
                        ConfigurationFactory.addFactory(arrayList, string);
                    }
                    PluginManager pluginManager = new PluginManager(CATEGORY);
                    pluginManager.collectPlugins();
                    Map<String, PluginType<?>> map = pluginManager.getPlugins();
                    ArrayList<Class<ConfigurationFactory>> arrayList2 = new ArrayList<Class<ConfigurationFactory>>(map.size());
                    for (PluginType<?> object : map.values()) {
                        try {
                            arrayList2.add(object.getPluginClass().asSubclass(ConfigurationFactory.class));
                        }
                        catch (Exception exception) {
                            Throwables.throwIfCritical(exception);
                            Exception exception2 = exception;
                            LOGGER.warn("Unable to add class {}", (Object)object.getPluginClass(), (Object)exception2);
                        }
                    }
                    Collections.sort(arrayList2, OrderComparator.getInstance());
                    for (Class clazz : arrayList2) {
                        ConfigurationFactory.addFactory(arrayList, clazz);
                    }
                    factories = Collections.unmodifiableList(arrayList);
                    authorizationProvider = ConfigurationFactory.authorizationProvider(propertiesUtil);
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        LOGGER.debug("Using configurationFactory {}", (Object)configFactory);
        return configFactory;
    }

    public static AuthorizationProvider authorizationProvider(PropertiesUtil propertiesUtil) {
        String string = propertiesUtil.getStringProperty(PREFIXES, AUTHORIZATION_PROVIDER, null);
        AuthorizationProvider authorizationProvider = null;
        if (string != null) {
            try {
                Object t2 = LoaderUtil.newInstanceOf(string);
                if (t2 instanceof AuthorizationProvider) {
                    authorizationProvider = (AuthorizationProvider)t2;
                } else {
                    LOGGER.warn("{} is not an AuthorizationProvider, using default", (Object)t2.getClass().getName());
                }
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                LOGGER.warn("Unable to create {}, using default: {}", (Object)string, (Object)exception2.getMessage());
            }
        }
        if (authorizationProvider == null) {
            authorizationProvider = new BasicAuthorizationProvider(propertiesUtil);
        }
        return authorizationProvider;
    }

    public static AuthorizationProvider getAuthorizationProvider() {
        return authorizationProvider;
    }

    private static void addFactory(Collection<ConfigurationFactory> collection, String string) {
        try {
            ConfigurationFactory.addFactory(collection, Loader.loadClass(string).asSubclass(ConfigurationFactory.class));
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.error("Unable to load class {}", (Object)string, (Object)exception2);
        }
    }

    private static void addFactory(Collection<ConfigurationFactory> collection, Class<? extends ConfigurationFactory> clazz) {
        try {
            collection.add(ReflectionUtil.instantiate(clazz));
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.error("Unable to create instance of {}", (Object)clazz.getName(), (Object)exception2);
        }
    }

    public static void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        configFactory = configurationFactory;
    }

    public static void resetConfigurationFactory() {
        configFactory = new Factory();
    }

    public static void removeConfigurationFactory(ConfigurationFactory configurationFactory) {
        if (configFactory == configurationFactory) {
            configFactory = new Factory();
        }
    }

    protected abstract String[] getSupportedTypes();

    protected String getTestPrefix() {
        return TEST_PREFIX;
    }

    protected String getDefaultPrefix() {
        return DEFAULT_PREFIX;
    }

    protected String getVersion() {
        return LOG4J2_VERSION;
    }

    protected boolean isActive() {
        return true;
    }

    public abstract Configuration getConfiguration(LoggerContext var1, ConfigurationSource var2);

    public Configuration getConfiguration(LoggerContext loggerContext, String string, URI uRI) {
        ConfigurationSource configurationSource;
        if (!this.isActive()) {
            return null;
        }
        if (uRI != null && (configurationSource = ConfigurationSource.fromUri(uRI)) != null) {
            return this.getConfiguration(loggerContext, configurationSource);
        }
        return null;
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String string, URI uRI, ClassLoader classLoader) {
        Configuration configuration;
        String string2;
        ConfigurationSource configurationSource;
        if (!this.isActive()) {
            return null;
        }
        if (classLoader == null) {
            return this.getConfiguration(loggerContext, string, uRI);
        }
        if (ConfigurationFactory.isClassLoaderUri(uRI) && (configurationSource = ConfigurationSource.fromResource(string2 = ConfigurationFactory.extractClassLoaderUriPath(uRI), classLoader)) != null && (configuration = this.getConfiguration(loggerContext, configurationSource)) != null) {
            return configuration;
        }
        return this.getConfiguration(loggerContext, string, uRI);
    }

    static boolean isClassLoaderUri(URI uRI) {
        if (uRI == null) {
            return false;
        }
        String string = uRI.getScheme();
        return string == null || string.equals(CLASS_LOADER_SCHEME) || string.equals(CLASS_PATH_SCHEME);
    }

    static String extractClassLoaderUriPath(URI uRI) {
        return uRI.getScheme() == null ? uRI.getPath() : uRI.getSchemeSpecificPart();
    }

    @Deprecated
    protected ConfigurationSource getInputFromString(String string, ClassLoader classLoader) {
        return ConfigurationSource.fromUri(NetUtils.toURI(string));
    }

    static List<ConfigurationFactory> getFactories() {
        return factories;
    }

    static {
        configFactory = new Factory();
        LOCK = new ReentrantLock();
        PREFIXES = new String[]{"com.contrastsecurity.thirdparty.log4j2.", "com.contrastsecurity.thirdparty.log4j2.Configuration."};
    }

    private static class Factory
    extends ConfigurationFactory {
        private static final String ALL_TYPES = "*";

        private Factory() {
        }

        @Override
        public Configuration getConfiguration(LoggerContext loggerContext, String string, URI uRI) {
            Object object;
            if (uRI == null) {
                object = this.substitutor.replace(PropertiesUtil.getProperties().getStringProperty(ConfigurationFactory.CONFIGURATION_FILE_PROPERTY));
                if (object != null) {
                    String[] stringArray = this.parseConfigLocations((String)object);
                    if (stringArray.length > 1) {
                        ArrayList<AbstractConfiguration> arrayList = new ArrayList<AbstractConfiguration>();
                        for (String string2 : stringArray) {
                            Configuration configuration = this.getConfiguration(loggerContext, string2.trim());
                            if (configuration != null) {
                                if (configuration instanceof AbstractConfiguration) {
                                    arrayList.add((AbstractConfiguration)configuration);
                                    continue;
                                }
                                LOGGER.error("Failed to created configuration at {}", (Object)string2);
                                return null;
                            }
                            LOGGER.warn("Unable to create configuration for {}, ignoring", (Object)string2);
                        }
                        if (arrayList.size() > 1) {
                            return new CompositeConfiguration(arrayList);
                        }
                        if (arrayList.size() == 1) {
                            return (Configuration)arrayList.get(0);
                        }
                    }
                    return this.getConfiguration(loggerContext, (String)object);
                }
                String string3 = this.substitutor.replace(PropertiesUtil.getProperties().getStringProperty(ConfigurationFactory.LOG4J1_CONFIGURATION_FILE_PROPERTY));
                if (string3 != null) {
                    System.setProperty(ConfigurationFactory.LOG4J1_EXPERIMENTAL, "true");
                    return this.getConfiguration(ConfigurationFactory.LOG4J1_VERSION, loggerContext, string3);
                }
                for (ConfigurationFactory configurationFactory : Factory.getFactories()) {
                    String[] stringArray = configurationFactory.getSupportedTypes();
                    if (stringArray == null) continue;
                    for (String string4 : stringArray) {
                        Configuration configuration;
                        if (!string4.equals(ALL_TYPES) || (configuration = configurationFactory.getConfiguration(loggerContext, string, uRI)) == null) continue;
                        return configuration;
                    }
                }
            } else {
                object = this.parseConfigLocations(uRI);
                if (((String[])object).length > 1) {
                    ArrayList<AbstractConfiguration> arrayList = new ArrayList<AbstractConfiguration>();
                    for (String string5 : object) {
                        Configuration configuration = this.getConfiguration(loggerContext, string5.trim());
                        if (!(configuration instanceof AbstractConfiguration)) {
                            LOGGER.error("Failed to created configuration at {}", (Object)string5);
                            return null;
                        }
                        arrayList.add((AbstractConfiguration)configuration);
                    }
                    return new CompositeConfiguration(arrayList);
                }
                String string6 = uRI.toString();
                for (ConfigurationFactory configurationFactory : Factory.getFactories()) {
                    String[] stringArray = configurationFactory.getSupportedTypes();
                    if (stringArray == null) continue;
                    for (String string7 : stringArray) {
                        Configuration configuration;
                        if (!string7.equals(ALL_TYPES) && !string6.endsWith(string7) || (configuration = configurationFactory.getConfiguration(loggerContext, string, uRI)) == null) continue;
                        return configuration;
                    }
                }
            }
            if ((object = this.getConfiguration(loggerContext, true, string)) == null && (object = this.getConfiguration(loggerContext, true, null)) == null && (object = this.getConfiguration(loggerContext, false, string)) == null) {
                object = this.getConfiguration(loggerContext, false, null);
            }
            if (object != null) {
                return object;
            }
            LOGGER.warn("No Log4j 2 configuration file found. Using default configuration (logging only errors to the console), or user programmatically provided configurations. Set system property 'log4j2.debug' to show Log4j 2 internal initialization logging. See https://logging.apache.org/log4j/2.x/manual/configuration.html for instructions on how to configure Log4j 2");
            return new DefaultConfiguration();
        }

        private Configuration getConfiguration(LoggerContext loggerContext, String string) {
            return this.getConfiguration(null, loggerContext, string);
        }

        private Configuration getConfiguration(String string, LoggerContext loggerContext, String string2) {
            Iterator<ConfigurationFactory> iterator;
            ConfigurationSource configurationSource = null;
            try {
                configurationSource = ConfigurationSource.fromUri(NetUtils.toURI(string2));
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                iterator = exception;
                LOGGER.catching(Level.DEBUG, (Throwable)((Object)iterator));
            }
            if (configurationSource == null) {
                iterator = LoaderUtil.getThreadContextClassLoader();
                configurationSource = this.getInputFromString(string2, (ClassLoader)((Object)iterator));
            }
            if (configurationSource != null) {
                for (ConfigurationFactory configurationFactory : Factory.getFactories()) {
                    String[] stringArray;
                    if (string != null && !configurationFactory.getVersion().equals(string) || (stringArray = configurationFactory.getSupportedTypes()) == null) continue;
                    for (String string3 : stringArray) {
                        Configuration configuration;
                        if (!string3.equals(ALL_TYPES) && !string2.endsWith(string3) || (configuration = configurationFactory.getConfiguration(loggerContext, configurationSource)) == null) continue;
                        return configuration;
                    }
                }
            }
            return null;
        }

        private Configuration getConfiguration(LoggerContext loggerContext, boolean bl2, String string) {
            boolean bl3 = Strings.isNotEmpty(string);
            ClassLoader classLoader = LoaderUtil.getThreadContextClassLoader();
            for (ConfigurationFactory configurationFactory : Factory.getFactories()) {
                String string2 = bl2 ? configurationFactory.getTestPrefix() : configurationFactory.getDefaultPrefix();
                String[] stringArray = configurationFactory.getSupportedTypes();
                if (stringArray == null) continue;
                for (String string3 : stringArray) {
                    String string4;
                    ConfigurationSource configurationSource;
                    if (string3.equals(ALL_TYPES) || (configurationSource = ConfigurationSource.fromResource(string4 = bl3 ? string2 + string + string3 : string2 + string3, classLoader)) == null) continue;
                    if (!configurationFactory.isActive()) {
                        LOGGER.warn("Found configuration file {} for inactive ConfigurationFactory {}", (Object)string4, (Object)configurationFactory.getClass().getName());
                    }
                    return configurationFactory.getConfiguration(loggerContext, configurationSource);
                }
            }
            return null;
        }

        @Override
        public String[] getSupportedTypes() {
            return null;
        }

        @Override
        public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource configurationSource) {
            if (configurationSource != null) {
                String string = configurationSource.getLocation();
                for (ConfigurationFactory configurationFactory : Factory.getFactories()) {
                    String[] stringArray = configurationFactory.getSupportedTypes();
                    if (stringArray == null) continue;
                    for (String string2 : stringArray) {
                        if (!string2.equals(ALL_TYPES) && (string == null || !string.endsWith(string2))) continue;
                        Configuration configuration = configurationFactory.getConfiguration(loggerContext, configurationSource);
                        if (configuration != null) {
                            LOGGER.debug("Loaded configuration from {}", (Object)configurationSource);
                            return configuration;
                        }
                        LOGGER.error("Cannot determine the ConfigurationFactory to use for {}", (Object)string);
                        return null;
                    }
                }
            }
            LOGGER.error("Cannot process configuration, input source is null");
            return null;
        }

        private String[] parseConfigLocations(URI uRI) {
            String[] stringArray = uRI.toString().split("\\?");
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray.length > 1) {
                String[] stringArray2;
                arrayList.add(stringArray[0]);
                for (String string : stringArray2 = uRI.getQuery().split("&")) {
                    int n2 = string.indexOf("=");
                    try {
                        String string2;
                        String string3 = string2 = n2 > 0 ? URLDecoder.decode(string.substring(0, n2), "UTF-8") : string;
                        if (!string2.equalsIgnoreCase(ConfigurationFactory.OVERRIDE_PARAM)) continue;
                        arrayList.add(URLDecoder.decode(string.substring(n2 + 1), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        LOGGER.warn("Invalid query parameter in {}", (Object)uRI);
                    }
                }
                return arrayList.toArray(Strings.EMPTY_ARRAY);
            }
            return new String[]{stringArray[0]};
        }

        private String[] parseConfigLocations(String string) {
            String[] stringArray = string.split(",");
            if (stringArray.length > 1) {
                return stringArray;
            }
            try {
                return this.parseConfigLocations(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Error parsing URI {}", (Object)string);
                return new String[]{string};
            }
        }
    }
}

