/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Level;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Marker;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Appender;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.AsyncLoggerConfig;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.AsyncLoggerContext;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.AsyncLoggerContextSelector;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.AppenderControl;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.AppenderControlArraySet;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.AppenderRef;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.DefaultReliabilityStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.ReliabilityStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.validation.constraints.Required;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.properties.PropertiesConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.filter.AbstractFilterable;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.DefaultLogEventFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.LocationAware;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.Log4jLogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.LogEventFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.ReusableLogEventFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Booleans;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Constants;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.Message;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PerformanceSensitive;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertiesUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.StackLocatorUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Plugin(name="logger", category="Core", printObject=true)
public class LoggerConfig
extends AbstractFilterable
implements LocationAware {
    public static final String ROOT = "root";
    private static LogEventFactory LOG_EVENT_FACTORY = null;
    private List<AppenderRef> appenderRefs = new ArrayList<AppenderRef>();
    private final AppenderControlArraySet appenders = new AppenderControlArraySet();
    private final String name;
    private LogEventFactory logEventFactory = LOG_EVENT_FACTORY;
    private Level level;
    private boolean additive = true;
    private boolean includeLocation = true;
    private LoggerConfig parent;
    private Map<Property, Boolean> propertiesMap;
    private final List<Property> properties;
    private final boolean propertiesRequireLookup;
    private final Configuration config;
    private final ReliabilityStrategy reliabilityStrategy;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return new Builder().asBuilder();
    }

    public LoggerConfig() {
        this.level = Level.ERROR;
        this.name = "";
        this.properties = null;
        this.propertiesRequireLookup = false;
        this.config = null;
        this.reliabilityStrategy = new DefaultReliabilityStrategy(this);
    }

    public LoggerConfig(String string, Level level, boolean bl2) {
        this.name = string;
        this.level = level;
        this.additive = bl2;
        this.properties = null;
        this.propertiesRequireLookup = false;
        this.config = null;
        this.reliabilityStrategy = new DefaultReliabilityStrategy(this);
    }

    protected LoggerConfig(String string, List<AppenderRef> list, Filter filter, Level level, boolean bl2, Property[] propertyArray, Configuration configuration, boolean bl3) {
        super(filter);
        this.name = string;
        this.appenderRefs = list;
        this.level = level;
        this.additive = bl2;
        this.includeLocation = bl3;
        this.config = configuration;
        this.properties = propertyArray != null && propertyArray.length > 0 ? Collections.unmodifiableList(Arrays.asList(Arrays.copyOf(propertyArray, propertyArray.length))) : null;
        this.propertiesRequireLookup = LoggerConfig.containsPropertyRequiringLookup(propertyArray);
        this.reliabilityStrategy = configuration.getReliabilityStrategy(this);
    }

    private static boolean containsPropertyRequiringLookup(Property[] propertyArray) {
        if (propertyArray == null) {
            return false;
        }
        for (int i2 = 0; i2 < propertyArray.length; ++i2) {
            if (!propertyArray[i2].isValueNeedsLookup()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Filter getFilter() {
        return super.getFilter();
    }

    public String getName() {
        return this.name;
    }

    public void setParent(LoggerConfig loggerConfig) {
        this.parent = loggerConfig;
    }

    public LoggerConfig getParent() {
        return this.parent;
    }

    public void addAppender(Appender appender, Level level, Filter filter) {
        this.appenders.add(new AppenderControl(appender, level, filter));
    }

    public void removeAppender(String string) {
        AppenderControl appenderControl = null;
        while ((appenderControl = this.appenders.remove(string)) != null) {
            this.cleanupFilter(appenderControl);
        }
    }

    public Map<String, Appender> getAppenders() {
        return this.appenders.asMap();
    }

    protected void clearAppenders() {
        do {
            AppenderControl[] appenderControlArray;
            for (AppenderControl appenderControl : appenderControlArray = this.appenders.clear()) {
                this.cleanupFilter(appenderControl);
            }
        } while (!this.appenders.isEmpty());
    }

    private void cleanupFilter(AppenderControl appenderControl) {
        Filter filter = appenderControl.getFilter();
        if (filter != null) {
            appenderControl.removeFilter(filter);
            filter.stop();
        }
    }

    public List<AppenderRef> getAppenderRefs() {
        return this.appenderRefs;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level == null ? (this.parent == null ? Level.ERROR : this.parent.getLevel()) : this.level;
    }

    public Level getExplicitLevel() {
        return this.level;
    }

    public LogEventFactory getLogEventFactory() {
        return this.logEventFactory;
    }

    public void setLogEventFactory(LogEventFactory logEventFactory) {
        this.logEventFactory = logEventFactory;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAdditive(boolean bl2) {
        this.additive = bl2;
    }

    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    @Deprecated
    public Map<Property, Boolean> getProperties() {
        if (this.properties == null) {
            return null;
        }
        if (this.propertiesMap == null) {
            HashMap<Property, Boolean> hashMap = new HashMap<Property, Boolean>(this.properties.size() * 2);
            for (int i2 = 0; i2 < this.properties.size(); ++i2) {
                hashMap.put(this.properties.get(i2), this.properties.get(i2).isValueNeedsLookup());
            }
            this.propertiesMap = Collections.unmodifiableMap(hashMap);
        }
        return this.propertiesMap;
    }

    public List<Property> getPropertyList() {
        return this.properties;
    }

    public boolean isPropertiesRequireLookup() {
        return this.propertiesRequireLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerformanceSensitive(value={"allocation"})
    public void log(String string, String string2, Marker marker, Level level, Message message, Throwable throwable) {
        List<Property> list = this.getProperties(string, string2, marker, level, message, throwable);
        LogEvent logEvent = this.logEventFactory.createEvent(string, marker, string2, this.location(string2), level, message, list, throwable);
        try {
            this.log(logEvent, LoggerConfigPredicate.ALL);
        }
        finally {
            ReusableLogEventFactory.release(logEvent);
        }
    }

    private StackTraceElement location(String string) {
        return this.requiresLocation() ? StackLocatorUtil.calcLocation(string) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerformanceSensitive(value={"allocation"})
    public void log(String string, String string2, StackTraceElement stackTraceElement, Marker marker, Level level, Message message, Throwable throwable) {
        List<Property> list = this.getProperties(string, string2, marker, level, message, throwable);
        LogEvent logEvent = this.logEventFactory.createEvent(string, marker, string2, stackTraceElement, level, message, list, throwable);
        try {
            this.log(logEvent, LoggerConfigPredicate.ALL);
        }
        finally {
            ReusableLogEventFactory.release(logEvent);
        }
    }

    private List<Property> getProperties(String string, String string2, Marker marker, Level level, Message message, Throwable throwable) {
        List<Property> list = this.properties;
        if (list == null || !this.propertiesRequireLookup) {
            return list;
        }
        return this.getPropertiesWithLookups(string, string2, marker, level, message, throwable, list);
    }

    private List<Property> getPropertiesWithLookups(String string, String string2, Marker marker, Level level, Message message, Throwable throwable, List<Property> list) {
        ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
        Log4jLogEvent log4jLogEvent = Log4jLogEvent.newBuilder().setMessage(message).setMarker(marker).setLevel(level).setLoggerName(string).setLoggerFqcn(string2).setThrown(throwable).build();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Property property = list.get(i2);
            String string3 = property.evaluate(this.config.getStrSubstitutor());
            arrayList.add(Property.createProperty(property.getName(), property.getRawValue(), string3));
        }
        return arrayList;
    }

    public void log(LogEvent logEvent) {
        this.log(logEvent, LoggerConfigPredicate.ALL);
    }

    protected void log(LogEvent logEvent, LoggerConfigPredicate loggerConfigPredicate) {
        if (!this.isFiltered(logEvent)) {
            this.processLogEvent(logEvent, loggerConfigPredicate);
        }
    }

    public ReliabilityStrategy getReliabilityStrategy() {
        return this.reliabilityStrategy;
    }

    private void processLogEvent(LogEvent logEvent, LoggerConfigPredicate loggerConfigPredicate) {
        logEvent.setIncludeLocation(this.isIncludeLocation());
        if (loggerConfigPredicate.allow(this)) {
            this.callAppenders(logEvent);
        }
        this.logParent(logEvent, loggerConfigPredicate);
    }

    @Override
    public boolean requiresLocation() {
        if (!this.includeLocation) {
            return false;
        }
        AppenderControl[] appenderControlArray = this.appenders.get();
        LoggerConfig loggerConfig = this;
        while (loggerConfig != null) {
            for (AppenderControl appenderControl : appenderControlArray) {
                Appender appender = appenderControl.getAppender();
                if (!(appender instanceof LocationAware) || !((LocationAware)((Object)appender)).requiresLocation()) continue;
                return true;
            }
            if (!loggerConfig.additive) break;
            loggerConfig = loggerConfig.parent;
            if (loggerConfig == null) continue;
            appenderControlArray = loggerConfig.appenders.get();
        }
        return false;
    }

    private void logParent(LogEvent logEvent, LoggerConfigPredicate loggerConfigPredicate) {
        if (this.additive && this.parent != null) {
            this.parent.log(logEvent, loggerConfigPredicate);
        }
    }

    @PerformanceSensitive(value={"allocation"})
    protected void callAppenders(LogEvent logEvent) {
        AppenderControl[] appenderControlArray = this.appenders.get();
        for (int i2 = 0; i2 < appenderControlArray.length; ++i2) {
            appenderControlArray[i2].callAppender(logEvent);
        }
    }

    public String toString() {
        return Strings.isEmpty(this.name) ? ROOT : this.name;
    }

    @Deprecated
    public static LoggerConfig createLogger(String string, Level level, @PluginAttribute(value="name") String string2, String string3, AppenderRef[] appenderRefArray, Property[] propertyArray, @PluginConfiguration Configuration configuration, Filter filter) {
        if (string2 == null) {
            LOGGER.error("Loggers cannot be configured without a name");
            return null;
        }
        List<AppenderRef> list = Arrays.asList(appenderRefArray);
        String string4 = string2.equals(ROOT) ? "" : string2;
        boolean bl2 = Booleans.parseBoolean(string, true);
        return new LoggerConfig(string4, list, filter, level, bl2, propertyArray, configuration, LoggerConfig.includeLocation(string3, configuration));
    }

    @Deprecated
    public static LoggerConfig createLogger(@PluginAttribute(value="additivity", defaultBoolean=true) boolean bl2, @PluginAttribute(value="level") Level level, @Required(message="Loggers cannot be configured without a name") @PluginAttribute(value="name") String string, @PluginAttribute(value="includeLocation") String string2, @PluginElement(value="AppenderRef") AppenderRef[] appenderRefArray, @PluginElement(value="Properties") Property[] propertyArray, @PluginConfiguration Configuration configuration, @PluginElement(value="Filter") Filter filter) {
        String string3 = string.equals(ROOT) ? "" : string;
        return new LoggerConfig(string3, Arrays.asList(appenderRefArray), filter, level, bl2, propertyArray, configuration, LoggerConfig.includeLocation(string2, configuration));
    }

    protected static boolean includeLocation(String string) {
        return LoggerConfig.includeLocation(string, null);
    }

    protected static boolean includeLocation(String string, Configuration configuration) {
        if (string == null) {
            LoggerContext loggerContext = null;
            if (configuration != null) {
                loggerContext = configuration.getLoggerContext();
            }
            if (loggerContext != null) {
                return !(loggerContext instanceof AsyncLoggerContext);
            }
            return !AsyncLoggerContextSelector.isSelected();
        }
        return Boolean.parseBoolean(string);
    }

    protected final boolean hasAppenders() {
        return !this.appenders.isEmpty();
    }

    protected static LevelAndRefs getLevelAndRefs(Level level, AppenderRef[] appenderRefArray, String string2, Configuration configuration) {
        LevelAndRefs levelAndRefs = new LevelAndRefs();
        if (string2 != null) {
            if (configuration instanceof PropertiesConfiguration) {
                if (level != null) {
                    LOGGER.warn("Level is ignored when levelAndRefs syntax is used.");
                }
                if (appenderRefArray != null && appenderRefArray.length > 0) {
                    LOGGER.warn("Appender references are ignored when levelAndRefs syntax is used");
                }
                String[] stringArray = Strings.splitList(string2);
                levelAndRefs.level = Level.getLevel(stringArray[0]);
                if (stringArray.length > 1) {
                    ArrayList<AppenderRef> arrayList = new ArrayList<AppenderRef>();
                    Arrays.stream(stringArray).skip(1L).forEach(string -> arrayList.add(AppenderRef.createAppenderRef(string, null, null)));
                    levelAndRefs.refs = arrayList;
                }
            } else {
                LOGGER.warn("levelAndRefs are only allowed in a properties configuration. The value is ignored.");
                levelAndRefs.level = level;
                levelAndRefs.refs = appenderRefArray != null ? Arrays.asList(appenderRefArray) : new ArrayList<AppenderRef>();
            }
        } else {
            levelAndRefs.level = level;
            levelAndRefs.refs = appenderRefArray != null ? Arrays.asList(appenderRefArray) : new ArrayList<AppenderRef>();
        }
        return levelAndRefs;
    }

    static {
        String string = PropertiesUtil.getProperties().getStringProperty("Log4jLogEventFactory");
        if (string != null) {
            try {
                Class<?> clazz = Loader.loadClass(string);
                if (clazz != null && LogEventFactory.class.isAssignableFrom(clazz)) {
                    LOG_EVENT_FACTORY = (LogEventFactory)clazz.newInstance();
                }
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                LOGGER.error("Unable to create LogEventFactory {}", (Object)string, (Object)exception2);
            }
        }
        if (LOG_EVENT_FACTORY == null) {
            LOG_EVENT_FACTORY = Constants.ENABLE_THREADLOCALS ? new ReusableLogEventFactory() : new DefaultLogEventFactory();
        }
    }

    protected static enum LoggerConfigPredicate {
        ALL{

            @Override
            boolean allow(LoggerConfig loggerConfig) {
                return true;
            }
        }
        ,
        ASYNCHRONOUS_ONLY{

            @Override
            boolean allow(LoggerConfig loggerConfig) {
                return loggerConfig instanceof AsyncLoggerConfig;
            }
        }
        ,
        SYNCHRONOUS_ONLY{

            @Override
            boolean allow(LoggerConfig loggerConfig) {
                return !ASYNCHRONOUS_ONLY.allow(loggerConfig);
            }
        };


        abstract boolean allow(LoggerConfig var1);
    }

    protected static class LevelAndRefs {
        public Level level;
        public List<AppenderRef> refs;

        protected LevelAndRefs() {
        }
    }

    @Plugin(name="root", category="Core", printObject=true)
    public static class RootLogger
    extends LoggerConfig {
        @PluginBuilderFactory
        public static <B extends Builder<B>> B newRootBuilder() {
            return new Builder().asBuilder();
        }

        @Deprecated
        public static LoggerConfig createLogger(@PluginAttribute(value="additivity") String string, @PluginAttribute(value="level") Level level, @PluginAttribute(value="includeLocation") String string2, @PluginElement(value="AppenderRef") AppenderRef[] appenderRefArray, @PluginElement(value="Properties") Property[] propertyArray, @PluginConfiguration Configuration configuration, @PluginElement(value="Filter") Filter filter) {
            List<AppenderRef> list = Arrays.asList(appenderRefArray);
            Level level2 = level == null ? Level.ERROR : level;
            boolean bl2 = Booleans.parseBoolean(string, true);
            return new LoggerConfig("", list, filter, level2, bl2, propertyArray, configuration, RootLogger.includeLocation(string2, configuration));
        }

        public static class Builder<B extends Builder<B>>
        implements com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Builder<LoggerConfig> {
            @PluginBuilderAttribute
            private boolean additivity;
            @PluginBuilderAttribute
            private Level level;
            @PluginBuilderAttribute
            private String levelAndRefs;
            @PluginBuilderAttribute
            private String includeLocation;
            @PluginElement(value="AppenderRef")
            private AppenderRef[] refs;
            @PluginElement(value="Properties")
            private Property[] properties;
            @PluginConfiguration
            private Configuration config;
            @PluginElement(value="Filter")
            private Filter filter;

            public boolean isAdditivity() {
                return this.additivity;
            }

            public B withAdditivity(boolean bl2) {
                this.additivity = bl2;
                return this.asBuilder();
            }

            public Level getLevel() {
                return this.level;
            }

            public B withLevel(Level level) {
                this.level = level;
                return this.asBuilder();
            }

            public String getLevelAndRefs() {
                return this.levelAndRefs;
            }

            public B withLevelAndRefs(String string) {
                this.levelAndRefs = string;
                return this.asBuilder();
            }

            public String getIncludeLocation() {
                return this.includeLocation;
            }

            public B withIncludeLocation(String string) {
                this.includeLocation = string;
                return this.asBuilder();
            }

            public AppenderRef[] getRefs() {
                return this.refs;
            }

            public B withRefs(AppenderRef[] appenderRefArray) {
                this.refs = appenderRefArray;
                return this.asBuilder();
            }

            public Property[] getProperties() {
                return this.properties;
            }

            public B withProperties(Property[] propertyArray) {
                this.properties = propertyArray;
                return this.asBuilder();
            }

            public Configuration getConfig() {
                return this.config;
            }

            public B withConfig(Configuration configuration) {
                this.config = configuration;
                return this.asBuilder();
            }

            public Filter getFilter() {
                return this.filter;
            }

            public B withtFilter(Filter filter) {
                this.filter = filter;
                return this.asBuilder();
            }

            @Override
            public LoggerConfig build() {
                LevelAndRefs levelAndRefs = LoggerConfig.getLevelAndRefs(this.level, this.refs, this.levelAndRefs, this.config);
                return new LoggerConfig("", levelAndRefs.refs, this.filter, levelAndRefs.level, this.additivity, this.properties, this.config, LoggerConfig.includeLocation(this.includeLocation, this.config));
            }

            public B asBuilder() {
                return (B)this;
            }
        }
    }

    public static class Builder<B extends Builder<B>>
    implements com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Builder<LoggerConfig> {
        @PluginBuilderAttribute
        private Boolean additivity;
        @PluginBuilderAttribute
        private Level level;
        @PluginBuilderAttribute
        private String levelAndRefs;
        @PluginBuilderAttribute(value="name")
        @Required(message="Loggers cannot be configured without a name")
        private String loggerName;
        @PluginBuilderAttribute
        private String includeLocation;
        @PluginElement(value="AppenderRef")
        private AppenderRef[] refs;
        @PluginElement(value="Properties")
        private Property[] properties;
        @PluginConfiguration
        private Configuration config;
        @PluginElement(value="Filter")
        private Filter filter;

        public boolean isAdditivity() {
            return this.additivity == null || this.additivity != false;
        }

        public B withAdditivity(boolean bl2) {
            this.additivity = bl2;
            return this.asBuilder();
        }

        public Level getLevel() {
            return this.level;
        }

        public B withLevel(Level level) {
            this.level = level;
            return this.asBuilder();
        }

        public String getLevelAndRefs() {
            return this.levelAndRefs;
        }

        public B withLevelAndRefs(String string) {
            this.levelAndRefs = string;
            return this.asBuilder();
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public B withLoggerName(String string) {
            this.loggerName = string;
            return this.asBuilder();
        }

        public String getIncludeLocation() {
            return this.includeLocation;
        }

        public B withIncludeLocation(String string) {
            this.includeLocation = string;
            return this.asBuilder();
        }

        public AppenderRef[] getRefs() {
            return this.refs;
        }

        public B withRefs(AppenderRef[] appenderRefArray) {
            this.refs = appenderRefArray;
            return this.asBuilder();
        }

        public Property[] getProperties() {
            return this.properties;
        }

        public B withProperties(Property[] propertyArray) {
            this.properties = propertyArray;
            return this.asBuilder();
        }

        public Configuration getConfig() {
            return this.config;
        }

        public B withConfig(Configuration configuration) {
            this.config = configuration;
            return this.asBuilder();
        }

        public Filter getFilter() {
            return this.filter;
        }

        public B withtFilter(Filter filter) {
            this.filter = filter;
            return this.asBuilder();
        }

        @Override
        public LoggerConfig build() {
            String string = this.loggerName.equals(LoggerConfig.ROOT) ? "" : this.loggerName;
            LevelAndRefs levelAndRefs = LoggerConfig.getLevelAndRefs(this.level, this.refs, this.levelAndRefs, this.config);
            boolean bl2 = LoggerConfig.includeLocation(this.includeLocation, this.config);
            return new LoggerConfig(string, levelAndRefs.refs, this.filter, levelAndRefs.level, this.isAdditivity(), this.properties, this.config, bl2);
        }

        public B asBuilder() {
            return (B)this;
        }
    }
}

