/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.ConverterKeys;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.HtmlTextRenderer;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.JAnsiTextRenderer;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.LogEventPatternConverter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.TextRenderer;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.Message;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.MultiformatMessage;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.MultiFormatStringBuilderFormattable;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PerformanceSensitive;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.StringBuilderFormattable;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Strings;
import java.util.ArrayList;
import java.util.Locale;

@Plugin(name="MessagePatternConverter", category="Converter")
@ConverterKeys(value={"m", "msg", "message"})
@PerformanceSensitive(value={"allocation"})
public class MessagePatternConverter
extends LogEventPatternConverter {
    private static final String LOOKUPS = "lookups";
    private static final String NOLOOKUPS = "nolookups";

    private MessagePatternConverter() {
        super("Message", "message");
    }

    private static TextRenderer loadMessageRenderer(String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                switch (string.toUpperCase(Locale.ROOT)) {
                    case "ANSI": {
                        if (Loader.isJansiAvailable()) {
                            return new JAnsiTextRenderer(stringArray, JAnsiTextRenderer.DefaultMessageStyleMap);
                        }
                        StatusLogger.getLogger().warn("You requested ANSI message rendering but JANSI is not on the classpath.");
                        return null;
                    }
                    case "HTML": {
                        return new HtmlTextRenderer(stringArray);
                    }
                }
            }
        }
        return null;
    }

    public static MessagePatternConverter newInstance(Configuration configuration, String[] stringArray) {
        MessagePatternConverter messagePatternConverter;
        String[] stringArray2 = MessagePatternConverter.withoutLookupOptions(stringArray);
        TextRenderer textRenderer = MessagePatternConverter.loadMessageRenderer(stringArray2);
        MessagePatternConverter messagePatternConverter2 = messagePatternConverter = stringArray2 == null || stringArray2.length == 0 ? SimpleMessagePatternConverter.INSTANCE : new FormattedMessagePatternConverter(stringArray2);
        if (textRenderer != null) {
            messagePatternConverter = new RenderingPatternConverter(messagePatternConverter, textRenderer);
        }
        return messagePatternConverter;
    }

    private static String[] withoutLookupOptions(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            if (LOOKUPS.equalsIgnoreCase(string) || NOLOOKUPS.equalsIgnoreCase(string)) {
                LOGGER.info("The {} option will be ignored. Message Lookups are no longer supported.", (Object)string);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList.toArray(Strings.EMPTY_ARRAY);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        throw new UnsupportedOperationException();
    }

    private static final class RenderingPatternConverter
    extends MessagePatternConverter {
        private final MessagePatternConverter delegate;
        private final TextRenderer textRenderer;

        RenderingPatternConverter(MessagePatternConverter messagePatternConverter, TextRenderer textRenderer) {
            this.delegate = messagePatternConverter;
            this.textRenderer = textRenderer;
        }

        @Override
        public void format(LogEvent logEvent, StringBuilder stringBuilder) {
            StringBuilder stringBuilder2 = new StringBuilder(80);
            this.delegate.format(logEvent, stringBuilder2);
            this.textRenderer.render(stringBuilder2, stringBuilder);
        }
    }

    private static final class FormattedMessagePatternConverter
    extends MessagePatternConverter {
        private final String[] formats;

        FormattedMessagePatternConverter(String[] stringArray) {
            this.formats = stringArray;
        }

        @Override
        public void format(LogEvent logEvent, StringBuilder stringBuilder) {
            Message message = logEvent.getMessage();
            if (message instanceof StringBuilderFormattable) {
                if (message instanceof MultiFormatStringBuilderFormattable) {
                    ((MultiFormatStringBuilderFormattable)message).formatTo(this.formats, stringBuilder);
                } else {
                    ((StringBuilderFormattable)((Object)message)).formatTo(stringBuilder);
                }
            } else if (message != null) {
                stringBuilder.append(message instanceof MultiformatMessage ? ((MultiformatMessage)message).getFormattedMessage(this.formats) : message.getFormattedMessage());
            }
        }
    }

    private static final class SimpleMessagePatternConverter
    extends MessagePatternConverter {
        private static final MessagePatternConverter INSTANCE = new SimpleMessagePatternConverter();

        private SimpleMessagePatternConverter() {
        }

        @Override
        public void format(LogEvent logEvent, StringBuilder stringBuilder) {
            Message message = logEvent.getMessage();
            if (message instanceof StringBuilderFormattable) {
                ((StringBuilderFormattable)((Object)message)).formatTo(stringBuilder);
            } else if (message != null) {
                stringBuilder.append(message.getFormattedMessage());
            }
        }
    }
}

