/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Integers;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PerformanceSensitive;
import java.util.ArrayList;
import java.util.List;

@PerformanceSensitive(value={"allocation"})
public abstract class NameAbbreviator {
    private static final NameAbbreviator DEFAULT = new NOPAbbreviator();

    public static NameAbbreviator getAbbreviator(String string) {
        if (string.length() > 0) {
            int n2;
            String string2;
            boolean bl2;
            String string3 = string.trim();
            if (string3.isEmpty()) {
                return DEFAULT;
            }
            if (string3.length() > 1 && string3.charAt(0) == '-') {
                bl2 = true;
                string2 = string3.substring(1);
            } else {
                bl2 = false;
                string2 = string3;
            }
            for (n2 = 0; n2 < string2.length() && string2.charAt(n2) >= '0' && string2.charAt(n2) <= '9'; ++n2) {
            }
            if (n2 == string2.length()) {
                return new MaxElementAbbreviator(Integers.parseInt(string2), bl2 ? MaxElementAbbreviator.Strategy.DROP : MaxElementAbbreviator.Strategy.RETAIN);
            }
            ArrayList<PatternAbbreviatorFragment> arrayList = new ArrayList<PatternAbbreviatorFragment>(5);
            for (int i2 = 0; i2 < string3.length() && i2 >= 0; ++i2) {
                int n3;
                int n4 = i2;
                if (string3.charAt(i2) == '*') {
                    n3 = Integer.MAX_VALUE;
                    ++n4;
                } else if (string3.charAt(i2) >= '0' && string3.charAt(i2) <= '9') {
                    n3 = string3.charAt(i2) - 48;
                    ++n4;
                } else {
                    n3 = 0;
                }
                char c2 = '\u0000';
                if (n4 < string3.length() && (c2 = string3.charAt(n4)) == '.') {
                    c2 = '\u0000';
                }
                arrayList.add(new PatternAbbreviatorFragment(n3, c2));
                i2 = string3.indexOf(46, i2);
                if (i2 == -1) break;
            }
            return new PatternAbbreviator(arrayList);
        }
        return DEFAULT;
    }

    public static NameAbbreviator getDefaultAbbreviator() {
        return DEFAULT;
    }

    public abstract void abbreviate(String var1, StringBuilder var2);

    private static final class PatternAbbreviator
    extends NameAbbreviator {
        private final PatternAbbreviatorFragment[] fragments;

        PatternAbbreviator(List<PatternAbbreviatorFragment> list) {
            if (list.isEmpty()) {
                throw new IllegalArgumentException("fragments must have at least one element");
            }
            this.fragments = list.toArray(PatternAbbreviatorFragment.EMPTY_ARRAY);
        }

        @Override
        public void abbreviate(String string, StringBuilder stringBuilder) {
            int n2 = 0;
            int n3 = 0;
            int n4 = string.length();
            while (n2 >= 0 && n2 < n4) {
                n2 = this.fragment(n3++).abbreviate(string, n2, stringBuilder);
            }
        }

        PatternAbbreviatorFragment fragment(int n2) {
            return this.fragments[Math.min(n2, this.fragments.length - 1)];
        }
    }

    private static final class PatternAbbreviatorFragment {
        static final PatternAbbreviatorFragment[] EMPTY_ARRAY = new PatternAbbreviatorFragment[0];
        private final int charCount;
        private final char ellipsis;

        PatternAbbreviatorFragment(int n2, char c2) {
            this.charCount = n2;
            this.ellipsis = c2;
        }

        int abbreviate(String string, int n2, StringBuilder stringBuilder) {
            int n3 = string.indexOf(46, n2);
            if (n3 < 0) {
                stringBuilder.append(string, n2, string.length());
                return n3;
            }
            if (n3 - n2 > this.charCount) {
                stringBuilder.append(string, n2, n2 + this.charCount);
                if (this.ellipsis != '\u0000') {
                    stringBuilder.append(this.ellipsis);
                }
                stringBuilder.append('.');
            } else {
                stringBuilder.append(string, n2, n3 + 1);
            }
            return n3 + 1;
        }
    }

    private static class MaxElementAbbreviator
    extends NameAbbreviator {
        private final int count;
        private final Strategy strategy;

        public MaxElementAbbreviator(int n2, Strategy strategy) {
            this.count = Math.max(n2, strategy.minCount);
            this.strategy = strategy;
        }

        @Override
        public void abbreviate(String string, StringBuilder stringBuilder) {
            this.strategy.abbreviate(this.count, string, stringBuilder);
        }

        private static enum Strategy {
            DROP(0){

                @Override
                void abbreviate(int n2, String string, StringBuilder stringBuilder) {
                    int n3 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        int n4 = string.indexOf(46, n3);
                        if (n4 == -1) {
                            stringBuilder.append(string);
                            return;
                        }
                        n3 = n4 + 1;
                    }
                    stringBuilder.append(string, n3, string.length());
                }
            }
            ,
            RETAIN(1){

                @Override
                void abbreviate(int n2, String string, StringBuilder stringBuilder) {
                    int n3 = string.length() - 1;
                    for (int i2 = n2; i2 > 0; --i2) {
                        if ((n3 = string.lastIndexOf(46, n3 - 1)) != -1) continue;
                        stringBuilder.append(string);
                        return;
                    }
                    stringBuilder.append(string, n3 + 1, string.length());
                }
            };

            final int minCount;

            private Strategy(int n3) {
                this.minCount = n3;
            }

            abstract void abbreviate(int var1, String var2, StringBuilder var3);
        }
    }

    private static class NOPAbbreviator
    extends NameAbbreviator {
        @Override
        public void abbreviate(String string, StringBuilder stringBuilder) {
            stringBuilder.append(string);
        }
    }
}

