/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.LocationAware;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.FormattingInfo;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.LogEventPatternConverter;

public class PatternFormatter {
    public static final PatternFormatter[] EMPTY_ARRAY = new PatternFormatter[0];
    private final LogEventPatternConverter converter;
    private final FormattingInfo field;
    private final boolean skipFormattingInfo;

    public PatternFormatter(LogEventPatternConverter logEventPatternConverter, FormattingInfo formattingInfo) {
        this.converter = logEventPatternConverter;
        this.field = formattingInfo;
        this.skipFormattingInfo = formattingInfo == FormattingInfo.getDefault();
    }

    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        if (this.skipFormattingInfo) {
            this.converter.format(logEvent, stringBuilder);
        } else {
            this.formatWithInfo(logEvent, stringBuilder);
        }
    }

    private void formatWithInfo(LogEvent logEvent, StringBuilder stringBuilder) {
        int n2 = stringBuilder.length();
        this.converter.format(logEvent, stringBuilder);
        this.field.format(n2, stringBuilder);
    }

    public LogEventPatternConverter getConverter() {
        return this.converter;
    }

    public FormattingInfo getFormattingInfo() {
        return this.field;
    }

    public boolean handlesThrowable() {
        return this.converter.handlesThrowable();
    }

    public boolean requiresLocation() {
        return this.converter instanceof LocationAware && ((LocationAware)((Object)this.converter)).requiresLocation();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("[converter=");
        stringBuilder.append(this.converter);
        stringBuilder.append(", field=");
        stringBuilder.append(this.field);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

