/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.AuthorizationProvider;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.PasswordDecryptor;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Base64Util;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.LoaderUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertiesUtil;
import java.net.URLConnection;

public class BasicAuthorizationProvider
implements AuthorizationProvider {
    private static final String[] PREFIXES = new String[]{"com.contrastsecurity.thirdparty.log4j2.config.", "com.contrastsecurity.thirdparty.log4j2.Configuration.", "logging.auth."};
    private static final String AUTH_USER_NAME = "username";
    private static final String AUTH_PASSWORD = "password";
    private static final String AUTH_PASSWORD_DECRYPTOR = "passwordDecryptor";
    public static final String CONFIG_USER_NAME = "com.contrastsecurity.thirdparty.log4j2.configurationUserName";
    public static final String CONFIG_PASSWORD = "com.contrastsecurity.thirdparty.log4j2.configurationPassword";
    public static final String PASSWORD_DECRYPTOR = "com.contrastsecurity.thirdparty.log4j2.passwordDecryptor";
    private static Logger LOGGER = StatusLogger.getLogger();
    private String authString = null;

    public BasicAuthorizationProvider(PropertiesUtil propertiesUtil) {
        String string = propertiesUtil.getStringProperty(PREFIXES, AUTH_USER_NAME, () -> propertiesUtil.getStringProperty(CONFIG_USER_NAME));
        String string2 = propertiesUtil.getStringProperty(PREFIXES, AUTH_PASSWORD, () -> propertiesUtil.getStringProperty(CONFIG_PASSWORD));
        String string3 = propertiesUtil.getStringProperty(PREFIXES, AUTH_PASSWORD_DECRYPTOR, () -> propertiesUtil.getStringProperty(PASSWORD_DECRYPTOR));
        if (string3 != null) {
            try {
                Object t2 = LoaderUtil.newInstanceOf(string3);
                if (t2 instanceof PasswordDecryptor) {
                    string2 = ((PasswordDecryptor)t2).decryptPassword(string2);
                }
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                LOGGER.warn("Unable to decrypt password.", (Throwable)exception2);
            }
        }
        if (string != null && string2 != null) {
            this.authString = "Basic " + Base64Util.encode(string + ":" + string2);
        }
    }

    @Override
    public void addAuthorization(URLConnection uRLConnection) {
        if (this.authString != null) {
            uRLConnection.setRequestProperty("Authorization", this.authString);
        }
    }
}

