/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Objects;
import java.util.Set;

public final class FileUtils {
    private static final String PROTOCOL_FILE = "file";
    private static final String JBOSS_FILE = "vfsfile";
    private static final Logger LOGGER = StatusLogger.getLogger();

    private FileUtils() {
    }

    public static File fileFromUri(URI uRI) {
        if (uRI == null) {
            return null;
        }
        if (uRI.isAbsolute()) {
            if (JBOSS_FILE.equals(uRI.getScheme())) {
                try {
                    uRI = new URI(PROTOCOL_FILE, uRI.getSchemeSpecificPart(), uRI.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            try {
                if (PROTOCOL_FILE.equals(uRI.getScheme())) {
                    return new File(uRI);
                }
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                LOGGER.warn("Invalid URI {}", (Object)uRI);
            }
        } else {
            File file = new File(uRI.toString());
            try {
                if (file.exists()) {
                    return file;
                }
                String string = uRI.getPath();
                return new File(string);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception3 = exception;
                LOGGER.warn("Invalid URI {}", (Object)uRI);
            }
        }
        return null;
    }

    public static boolean isFile(URL uRL) {
        return uRL != null && (uRL.getProtocol().equals(PROTOCOL_FILE) || uRL.getProtocol().equals(JBOSS_FILE));
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        if (string.lastIndexOf(".") != -1 && string.lastIndexOf(".") != 0) {
            return string.substring(string.lastIndexOf(".") + 1);
        }
        return null;
    }

    public static void mkdir(File file, boolean bl2) throws IOException {
        if (!file.exists() && !bl2) {
            throw new IOException("The directory " + file.getAbsolutePath() + " does not exist.");
        }
        try {
            Files.createDirectories(file.toPath(), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            if (!file.isDirectory()) {
                throw new IOException("File " + file + " exists and is not a directory. Unable to create directory.");
            }
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            throw new IOException("Could not create directory " + file.getAbsolutePath());
        }
    }

    public static void makeParentDirs(File file) throws IOException {
        File file2 = Objects.requireNonNull(file, PROTOCOL_FILE).getCanonicalFile().getParentFile();
        if (file2 != null) {
            FileUtils.mkdir(file2, true);
        }
    }

    public static void defineFilePosixAttributeView(Path path, Set<PosixFilePermission> set, String string, String string2) throws IOException {
        PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (posixFileAttributeView != null) {
            UserPrincipal userPrincipal;
            UserPrincipalLookupService userPrincipalLookupService = FileSystems.getDefault().getUserPrincipalLookupService();
            if (string != null && (userPrincipal = userPrincipalLookupService.lookupPrincipalByName(string)) != null) {
                posixFileAttributeView.setOwner(userPrincipal);
            }
            if (string2 != null && (userPrincipal = userPrincipalLookupService.lookupPrincipalByGroupName(string2)) != null) {
                posixFileAttributeView.setGroup((GroupPrincipal)userPrincipal);
            }
            if (set != null) {
                posixFileAttributeView.setPermissions(set);
            }
        }
    }

    public static boolean isFilePosixAttributeViewSupported() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }
}

