/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.util;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.spi.LoggerContextFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.spi.Provider;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.ProviderUtil;
import com.contrastsecurity.thirdparty.org.osgi.framework.AdaptPermission;
import com.contrastsecurity.thirdparty.org.osgi.framework.AdminPermission;
import com.contrastsecurity.thirdparty.org.osgi.framework.Bundle;
import com.contrastsecurity.thirdparty.org.osgi.framework.BundleActivator;
import com.contrastsecurity.thirdparty.org.osgi.framework.BundleContext;
import com.contrastsecurity.thirdparty.org.osgi.framework.BundleEvent;
import com.contrastsecurity.thirdparty.org.osgi.framework.BundleListener;
import com.contrastsecurity.thirdparty.org.osgi.framework.InvalidSyntaxException;
import com.contrastsecurity.thirdparty.org.osgi.framework.ServiceReference;
import com.contrastsecurity.thirdparty.org.osgi.framework.SynchronousBundleListener;
import com.contrastsecurity.thirdparty.org.osgi.framework.wiring.BundleWiring;
import java.net.URL;
import java.security.Permission;
import java.util.Collection;
import java.util.List;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();
    private static final Logger LOGGER = StatusLogger.getLogger();
    private boolean lockingProviderUtil;

    private static void checkPermission(Permission permission) {
        if (SECURITY_MANAGER != null) {
            SECURITY_MANAGER.checkPermission(permission);
        }
    }

    private void loadProvider(Bundle bundle) {
        if (bundle.getState() == 1) {
            return;
        }
        try {
            Activator.checkPermission((Permission)new AdminPermission(bundle, "resource"));
            Activator.checkPermission((Permission)new AdaptPermission(BundleWiring.class.getName(), bundle, "adapt"));
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                LOGGER.debug("Bundle {} has no context (state={}), skipping loading provider", (Object)bundle.getSymbolicName(), (Object)this.toStateString(bundle.getState()));
            } else {
                this.loadProvider(bundleContext, (BundleWiring)bundle.adapt(BundleWiring.class));
            }
        }
        catch (SecurityException securityException) {
            Throwables.throwIfCritical(securityException);
            SecurityException securityException2 = securityException;
            LOGGER.debug("Cannot access bundle [{}] contents. Ignoring.", (Object)bundle.getSymbolicName(), (Object)securityException2);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.warn("Problem checking bundle {} for Log4j 2 provider.", (Object)bundle.getSymbolicName(), (Object)exception2);
        }
    }

    private String toStateString(int n2) {
        switch (n2) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return Integer.toString(n2);
    }

    private void loadProvider(BundleContext bundleContext, BundleWiring bundleWiring) {
        Collection collection;
        String string = "(APIVersion>=2.6.0)";
        try {
            collection = bundleContext.getServiceReferences(Provider.class, "(APIVersion>=2.6.0)");
            Object object = null;
            for (ServiceReference serviceReference : collection) {
                Provider provider = (Provider)bundleContext.getService(serviceReference);
                if (object != null && provider.getPriority() <= ((Provider)object).getPriority()) continue;
                object = provider;
            }
            if (object != null) {
                ProviderUtil.addProvider(object);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            LOGGER.error("Invalid service filter: (APIVersion>=2.6.0)", (Throwable)invalidSyntaxException);
        }
        collection = bundleWiring.findEntries("META-INF", "com/contrastsecurity/thirdparty/log4j-provider.properties", 0);
        for (Object object : collection) {
            ProviderUtil.loadProvider((URL)object, bundleWiring.getClassLoader());
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        ProviderUtil.STARTUP_LOCK.lock();
        this.lockingProviderUtil = true;
        BundleWiring bundleWiring = (BundleWiring)bundleContext.getBundle().adapt(BundleWiring.class);
        List list = bundleWiring.getRequiredWires(LoggerContextFactory.class.getName());
        Bundle[] bundleArray = list.iterator();
        while (bundleArray.hasNext()) {
            Bundle[] bundleArray2 = (Bundle[])bundleArray.next();
            this.loadProvider(bundleContext, bundleArray2.getProviderWiring());
        }
        bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : bundleArray = bundleContext.getBundles()) {
            this.loadProvider(bundle);
        }
        this.unlockIfReady();
    }

    private void unlockIfReady() {
        if (this.lockingProviderUtil && !ProviderUtil.PROVIDERS.isEmpty()) {
            ProviderUtil.STARTUP_LOCK.unlock();
            this.lockingProviderUtil = false;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        bundleContext.removeBundleListener((BundleListener)this);
        this.unlockIfReady();
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        switch (bundleEvent.getType()) {
            case 2: {
                this.loadProvider(bundleEvent.getBundle());
                this.unlockIfReady();
                break;
            }
        }
    }
}

