/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.util;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.LoaderUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.OsgiServiceLocator;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class ServiceLoaderUtil {
    private ServiceLoaderUtil() {
    }

    public static <T> Stream<T> loadServices(Class<T> clazz, MethodHandles.Lookup lookup) {
        return ServiceLoaderUtil.loadServices(clazz, lookup, false);
    }

    public static <T> Stream<T> loadServices(Class<T> clazz, MethodHandles.Lookup lookup, boolean bl2) {
        return ServiceLoaderUtil.loadServices(clazz, lookup, bl2, true);
    }

    static <T> Stream<T> loadServices(Class<T> clazz, MethodHandles.Lookup lookup, boolean bl2, boolean bl3) {
        Object object;
        ClassLoader classLoader = lookup.lookupClass().getClassLoader();
        Stream<Object> stream = ServiceLoaderUtil.loadClassloaderServices(clazz, lookup, classLoader, bl3);
        if (bl2 && (object = LoaderUtil.getThreadContextClassLoader()) != classLoader) {
            stream = Stream.concat(stream, ServiceLoaderUtil.loadClassloaderServices(clazz, lookup, (ClassLoader)object, bl3));
        }
        if (OsgiServiceLocator.isAvailable()) {
            stream = Stream.concat(stream, OsgiServiceLocator.loadServices(clazz, lookup, bl3));
        }
        object = new HashSet();
        return stream.filter(arg_0 -> ServiceLoaderUtil.lambda$loadServices$0((Set)object, arg_0));
    }

    static <T> Stream<T> loadClassloaderServices(Class<T> clazz, MethodHandles.Lookup lookup, ClassLoader classLoader, boolean bl2) {
        return StreamSupport.stream(new ServiceLoaderSpliterator<T>(clazz, lookup, classLoader, bl2), false);
    }

    static <T> Iterable<T> callServiceLoader(MethodHandles.Lookup lookup, Class<T> clazz, ClassLoader classLoader, boolean bl2) {
        try {
            ServiceLoader serviceLoader;
            MethodHandle methodHandle = lookup.findStatic(ServiceLoader.class, "load", MethodType.methodType(ServiceLoader.class, Class.class, ClassLoader.class));
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "run", MethodType.methodType(PrivilegedAction.class, Class.class, ClassLoader.class), MethodType.methodType(Object.class), methodHandle, MethodType.methodType(ServiceLoader.class));
            PrivilegedAction privilegedAction = callSite.getTarget().bindTo(clazz).bindTo(classLoader).invoke();
            if (System.getSecurityManager() == null) {
                serviceLoader = (ServiceLoader)privilegedAction.run();
            } else {
                MethodHandle methodHandle2 = lookup.findStatic(AccessController.class, "doPrivileged", MethodType.methodType(Object.class, PrivilegedAction.class));
                serviceLoader = methodHandle2.invoke(privilegedAction);
            }
            return serviceLoader;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            if (bl2) {
                StatusLogger.getLogger().error("Unable to load services for service {}", (Object)clazz, (Object)throwable2);
            }
            return Collections.emptyList();
        }
    }

    private static /* synthetic */ boolean lambda$loadServices$0(Set set, Object object) {
        return set.add(object.getClass());
    }

    private static class ServiceLoaderSpliterator<S>
    implements Spliterator<S> {
        private final Iterator<S> serviceIterator;
        private final Logger logger;
        private final String serviceName;

        public ServiceLoaderSpliterator(Class<S> clazz, MethodHandles.Lookup lookup, ClassLoader classLoader, boolean bl2) {
            this.serviceIterator = ServiceLoaderUtil.callServiceLoader(lookup, clazz, classLoader, bl2).iterator();
            this.logger = bl2 ? StatusLogger.getLogger() : null;
            this.serviceName = clazz.toString();
        }

        @Override
        public boolean tryAdvance(Consumer<? super S> consumer) {
            while (this.serviceIterator.hasNext()) {
                try {
                    consumer.accept(this.serviceIterator.next());
                    return true;
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    if (this.logger == null) continue;
                    this.logger.warn("Unable to load service class for service {}", (Object)this.serviceName, (Object)serviceConfigurationError);
                }
            }
            return false;
        }

        @Override
        public Spliterator<S> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1280;
        }
    }
}

