/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.queues;

import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueueUtil;
import com.contrastsecurity.thirdparty.ojt.queues.MpscArrayQueueL3Pad;
import com.contrastsecurity.thirdparty.ojt.util.UnsafeRefArrayAccess;

public class MpscArrayQueue<E>
extends MpscArrayQueueL3Pad<E> {
    public MpscArrayQueue(int n2) {
        super(n2);
    }

    public boolean offerIfBelowThreshold(E e2, int n2) {
        long l2;
        long l3;
        if (null == e2) {
            throw new NullPointerException();
        }
        long l4 = this.mask;
        long l5 = l4 + 1L;
        long l6 = this.lvProducerLimit();
        do {
            long l7;
            if ((l7 = l5 - (l2 = l6 - (l3 = this.lvProducerIndex()))) < (long)n2) continue;
            long l8 = this.lvConsumerIndex();
            l7 = l3 - l8;
            if (l7 >= (long)n2) {
                return false;
            }
            l6 = l8 + l5;
            this.soProducerLimit(l6);
        } while (!this.casProducerIndex(l3, l3 + 1L));
        l2 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l3, l4);
        UnsafeRefArrayAccess.soRefElement(this.buffer, l2, e2);
        return true;
    }

    @Override
    public boolean offer(E e2) {
        long l2;
        long l3;
        if (null == e2) {
            throw new NullPointerException();
        }
        long l4 = this.mask;
        long l5 = this.lvProducerLimit();
        do {
            if ((l3 = this.lvProducerIndex()) < l5) continue;
            l2 = this.lvConsumerIndex();
            l5 = l2 + l4 + 1L;
            if (l3 >= l5) {
                return false;
            }
            this.soProducerLimit(l5);
        } while (!this.casProducerIndex(l3, l3 + 1L));
        l2 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l3, l4);
        UnsafeRefArrayAccess.soRefElement(this.buffer, l2, e2);
        return true;
    }

    public final int failFastOffer(E e2) {
        long l2;
        long l3;
        if (null == e2) {
            throw new NullPointerException();
        }
        long l4 = this.mask;
        long l5 = l4 + 1L;
        long l6 = this.lvProducerIndex();
        if (l6 >= (l3 = this.lvProducerLimit())) {
            l2 = this.lvConsumerIndex();
            l3 = l2 + l5;
            if (l6 >= l3) {
                return 1;
            }
            this.soProducerLimit(l3);
        }
        if (!this.casProducerIndex(l6, l6 + 1L)) {
            return -1;
        }
        l2 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l6, l4);
        UnsafeRefArrayAccess.soRefElement(this.buffer, l2, e2);
        return 0;
    }

    @Override
    public E poll() {
        Object[] objectArray = this.buffer;
        long l2 = this.lpConsumerIndex();
        long l3 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, this.mask);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l3);
        if (null == object) {
            if (l2 != this.lvProducerIndex()) {
                while ((object = UnsafeRefArrayAccess.lvRefElement(objectArray, l3)) == null) {
                }
            } else {
                return null;
            }
        }
        UnsafeRefArrayAccess.spRefElement(objectArray, l3, null);
        this.soConsumerIndex(l2 + 1L);
        return (E)object;
    }

    @Override
    public E peek() {
        Object[] objectArray = this.buffer;
        long l2 = this.lpConsumerIndex();
        long l3 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, this.mask);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l3);
        if (null == object) {
            if (l2 != this.lvProducerIndex()) {
                while ((object = UnsafeRefArrayAccess.lvRefElement(objectArray, l3)) == null) {
                }
            } else {
                return null;
            }
        }
        return (E)object;
    }

    @Override
    public boolean relaxedOffer(E e2) {
        return this.offer(e2);
    }

    @Override
    public E relaxedPoll() {
        Object[] objectArray = this.buffer;
        long l2 = this.lpConsumerIndex();
        long l3 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, this.mask);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l3);
        if (null == object) {
            return null;
        }
        UnsafeRefArrayAccess.spRefElement(objectArray, l3, null);
        this.soConsumerIndex(l2 + 1L);
        return (E)object;
    }

    @Override
    public E relaxedPeek() {
        Object[] objectArray = this.buffer;
        long l2 = this.mask;
        long l3 = this.lpConsumerIndex();
        return (E)UnsafeRefArrayAccess.lvRefElement(objectArray, UnsafeRefArrayAccess.calcCircularRefElementOffset(l3, l2));
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n2) {
        if (null == consumer) {
            throw new IllegalArgumentException("c is null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("limit is negative: " + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        Object[] objectArray = this.buffer;
        long l2 = this.mask;
        long l3 = this.lpConsumerIndex();
        for (int i2 = 0; i2 < n2; ++i2) {
            long l4 = l3 + (long)i2;
            long l5 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l4, l2);
            Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l5);
            if (null == object) {
                return i2;
            }
            UnsafeRefArrayAccess.spRefElement(objectArray, l5, null);
            this.soConsumerIndex(l4 + 1L);
            consumer.accept(object);
        }
        return n2;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n2) {
        long l2;
        long l3;
        int n3;
        long l4;
        if (null == supplier) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("limit is negative:" + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        long l5 = this.mask;
        long l6 = l5 + 1L;
        long l7 = this.lvProducerLimit();
        do {
            if ((l3 = l7 - (l4 = this.lvProducerIndex())) > 0L) continue;
            l2 = this.lvConsumerIndex();
            l7 = l2 + l6;
            l3 = l7 - l4;
            if (l3 <= 0L) {
                return 0;
            }
            this.soProducerLimit(l7);
        } while (!this.casProducerIndex(l4, l4 + (long)(n3 = Math.min((int)l3, n2))));
        Object[] objectArray = this.buffer;
        for (int i2 = 0; i2 < n3; ++i2) {
            l2 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l4 + (long)i2, l5);
            UnsafeRefArrayAccess.soRefElement(objectArray, l2, supplier.get());
        }
        return n3;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return this.drain(consumer, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        return MessagePassingQueueUtil.fillBounded(this, supplier);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, consumer, waitStrategy, exitCondition);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.fill(this, supplier, waitStrategy, exitCondition);
    }
}

