/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.queues;

import com.contrastsecurity.thirdparty.ojt.queues.IndexedQueueSizeUtil;
import com.contrastsecurity.thirdparty.ojt.queues.LinkedArrayQueueUtil;
import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueueUtil;
import com.contrastsecurity.thirdparty.ojt.queues.MpscBlockingConsumerArrayQueueConsumerFields;
import com.contrastsecurity.thirdparty.ojt.queues.QueueProgressIndicators;
import com.contrastsecurity.thirdparty.ojt.util.Pow2;
import com.contrastsecurity.thirdparty.ojt.util.RangeUtil;
import com.contrastsecurity.thirdparty.ojt.util.UnsafeRefArrayAccess;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public class MpscBlockingConsumerArrayQueue<E>
extends MpscBlockingConsumerArrayQueueConsumerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators,
BlockingQueue<E> {
    byte b000;
    byte b001;
    byte b002;
    byte b003;
    byte b004;
    byte b005;
    byte b006;
    byte b007;
    byte b010;
    byte b011;
    byte b012;
    byte b013;
    byte b014;
    byte b015;
    byte b016;
    byte b017;
    byte b020;
    byte b021;
    byte b022;
    byte b023;
    byte b024;
    byte b025;
    byte b026;
    byte b027;
    byte b030;
    byte b031;
    byte b032;
    byte b033;
    byte b034;
    byte b035;
    byte b036;
    byte b037;
    byte b040;
    byte b041;
    byte b042;
    byte b043;
    byte b044;
    byte b045;
    byte b046;
    byte b047;
    byte b050;
    byte b051;
    byte b052;
    byte b053;
    byte b054;
    byte b055;
    byte b056;
    byte b057;
    byte b060;
    byte b061;
    byte b062;
    byte b063;
    byte b064;
    byte b065;
    byte b066;
    byte b067;
    byte b070;
    byte b071;
    byte b072;
    byte b073;
    byte b074;
    byte b075;
    byte b076;
    byte b077;
    byte b100;
    byte b101;
    byte b102;
    byte b103;
    byte b104;
    byte b105;
    byte b106;
    byte b107;
    byte b110;
    byte b111;
    byte b112;
    byte b113;
    byte b114;
    byte b115;
    byte b116;
    byte b117;
    byte b120;
    byte b121;
    byte b122;
    byte b123;
    byte b124;
    byte b125;
    byte b126;
    byte b127;
    byte b130;
    byte b131;
    byte b132;
    byte b133;
    byte b134;
    byte b135;
    byte b136;
    byte b137;
    byte b140;
    byte b141;
    byte b142;
    byte b143;
    byte b144;
    byte b145;
    byte b146;
    byte b147;
    byte b150;
    byte b151;
    byte b152;
    byte b153;
    byte b154;
    byte b155;
    byte b156;
    byte b157;
    byte b160;
    byte b161;
    byte b162;
    byte b163;
    byte b164;
    byte b165;
    byte b166;
    byte b167;
    byte b170;
    byte b171;
    byte b172;
    byte b173;
    byte b174;
    byte b175;
    byte b176;
    byte b177;

    public MpscBlockingConsumerArrayQueue(int n2) {
        super(Pow2.roundToPowerOfTwo(n2) - 1 << 1, UnsafeRefArrayAccess.allocateRefArray(Pow2.roundToPowerOfTwo(n2)));
        RangeUtil.checkGreaterThanOrEqual(n2, 1, "capacity");
        this.soProducerLimit(Pow2.roundToPowerOfTwo(n2) - 1 << 1);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        return IndexedQueueSizeUtil.size(this, 2);
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerIndex() / 2L == this.lvProducerIndex() / 2L;
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    public boolean offerIfBelowThreshold(E e2, int n2) {
        long l2;
        long l3;
        if (null == e2) {
            throw new NullPointerException();
        }
        long l4 = this.producerMask;
        long l5 = l4 + 2L;
        n2 <<= 1;
        Object[] objectArray = this.producerBuffer;
        while (true) {
            if (((l3 = this.lvProducerIndex()) & 1L) == 1L) {
                if (!this.offerAndWakeup(objectArray, l4, l3, e2)) continue;
                return true;
            }
            l2 = this.lvProducerLimit();
            long l6 = l2 - l3;
            long l7 = l5 - l6;
            if (!(l7 < (long)n2 && l2 > l3 || this.recalculateProducerLimit(l3, l2, this.lvConsumerIndex(), l5, n2))) {
                return false;
            }
            if (this.casProducerIndex(l3, l3 + 2L)) break;
        }
        l2 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, l4);
        UnsafeRefArrayAccess.soRefElement(objectArray, l2, e2);
        return true;
    }

    @Override
    public boolean offer(E e2) {
        long l2;
        long l3;
        if (null == e2) {
            throw new NullPointerException();
        }
        long l4 = this.producerMask;
        Object[] objectArray = this.producerBuffer;
        while (true) {
            if (((l3 = this.lvProducerIndex()) & 1L) == 1L) {
                if (!this.offerAndWakeup(objectArray, l4, l3, e2)) continue;
                return true;
            }
            l2 = this.lvProducerLimit();
            if (l2 <= l3 && !this.recalculateProducerLimit(l4, l3, l2)) {
                return false;
            }
            if (this.casProducerIndex(l3, l3 + 2L)) break;
        }
        l2 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, l4);
        UnsafeRefArrayAccess.soRefElement(objectArray, l2, e2);
        return true;
    }

    @Override
    public void put(E e2) throws InterruptedException {
        if (!this.offer(e2)) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean offer(E e2, long l2, TimeUnit timeUnit) throws InterruptedException {
        if (this.offer(e2)) {
            return true;
        }
        throw new UnsupportedOperationException();
    }

    private boolean offerAndWakeup(E[] EArray, long l2, long l3, E e2) {
        long l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2);
        Thread thread = this.lvBlocked();
        if (thread == null) {
            return false;
        }
        if (!this.casProducerIndex(l3, l3 + 1L)) {
            return false;
        }
        UnsafeRefArrayAccess.soRefElement(EArray, l4, e2);
        LockSupport.unpark(thread);
        return true;
    }

    private boolean recalculateProducerLimit(long l2, long l3, long l4) {
        return this.recalculateProducerLimit(l3, l4, this.lvConsumerIndex(), l2 + 2L, l2 + 2L);
    }

    private boolean recalculateProducerLimit(long l2, long l3, long l4, long l5, long l6) {
        long l7;
        if (l4 + l5 > l2) {
            this.casProducerLimit(l3, l4 + l5);
        }
        return (l7 = l2 - l4) < l6 && l7 < l5;
    }

    @Override
    public E take() throws InterruptedException {
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.consumerMask;
        long l3 = this.lpConsumerIndex();
        long l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l4);
        if (object == null) {
            return (E)this.parkUntilNext(objectArray, l3, l4, Long.MAX_VALUE);
        }
        UnsafeRefArrayAccess.soRefElement(objectArray, l4, null);
        this.soConsumerIndex(l3 + 2L);
        return (E)object;
    }

    @Override
    public E poll(long l2, TimeUnit timeUnit) throws InterruptedException {
        Object[] objectArray = this.consumerBuffer;
        long l3 = this.consumerMask;
        long l4 = this.lpConsumerIndex();
        long l5 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l4, l3);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l5);
        if (object == null) {
            long l6 = timeUnit.toNanos(l2);
            if (l6 <= 0L) {
                return null;
            }
            return (E)this.parkUntilNext(objectArray, l4, l5, l6);
        }
        UnsafeRefArrayAccess.soRefElement(objectArray, l5, null);
        this.soConsumerIndex(l4 + 2L);
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E parkUntilNext(E[] EArray, long l2, long l3, long l4) throws InterruptedException {
        block7: {
            long l5 = this.lvProducerIndex();
            if (l2 == l5 && this.casProducerIndex(l5, l5 + 1L)) {
                this.soBlocked(Thread.currentThread());
                long l6 = l4 == Long.MAX_VALUE ? 0L : System.nanoTime() + l4;
                try {
                    do {
                        LockSupport.parkNanos(this, l4);
                        if (Thread.interrupted()) {
                            this.casProducerIndex(l5 + 1L, l5);
                            throw new InterruptedException();
                        }
                        if ((this.lvProducerIndex() & 1L) != 0L) continue;
                        break block7;
                    } while ((l4 = l4 == Long.MAX_VALUE ? Long.MAX_VALUE : l6 - System.nanoTime()) > 0L);
                    if (this.casProducerIndex(l5 + 1L, l5)) {
                        E e2 = null;
                        return e2;
                    }
                }
                finally {
                    this.soBlocked(null);
                }
            }
        }
        E e3 = MpscBlockingConsumerArrayQueue.spinWaitForElement(EArray, l3);
        UnsafeRefArrayAccess.soRefElement(EArray, l3, null);
        this.soConsumerIndex(l2 + 2L);
        return e3;
    }

    @Override
    public int remainingCapacity() {
        return this.capacity() - this.size();
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll() {
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.consumerMask;
        long l3 = this.lpConsumerIndex();
        long l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l4);
        if (object == null) {
            if (l3 != this.lvProducerIndex()) {
                object = MpscBlockingConsumerArrayQueue.spinWaitForElement(objectArray, l4);
            } else {
                return null;
            }
        }
        UnsafeRefArrayAccess.soRefElement(objectArray, l4, null);
        this.soConsumerIndex(l3 + 2L);
        return (E)object;
    }

    private static <E> E spinWaitForElement(E[] EArray, long l2) {
        E e2;
        while ((e2 = UnsafeRefArrayAccess.lvRefElement(EArray, l2)) == null) {
        }
        return e2;
    }

    @Override
    public E peek() {
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.consumerMask;
        long l3 = this.lpConsumerIndex();
        long l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l4);
        if (object == null && l3 != this.lvProducerIndex()) {
            object = MpscBlockingConsumerArrayQueue.spinWaitForElement(objectArray, l4);
        }
        return (E)object;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public int capacity() {
        return (int)(this.consumerMask + 2L >> 1);
    }

    @Override
    public boolean relaxedOffer(E e2) {
        return this.offer(e2);
    }

    @Override
    public E relaxedPoll() {
        long l2;
        Object[] objectArray = this.consumerBuffer;
        long l3 = this.lpConsumerIndex();
        long l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3, l2 = this.consumerMask);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l4);
        if (object == null) {
            return null;
        }
        UnsafeRefArrayAccess.soRefElement(objectArray, l4, null);
        this.soConsumerIndex(l3 + 2L);
        return (E)object;
    }

    @Override
    public E relaxedPeek() {
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        long l3 = this.consumerMask;
        long l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, l3);
        return (E)UnsafeRefArrayAccess.lvRefElement(objectArray, l4);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n2) {
        long l2;
        if (null == supplier) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("limit is negative:" + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        long l3 = this.producerMask;
        Thread thread = null;
        long l4 = 0L;
        long l5 = 2L * (long)n2;
        while (true) {
            l2 = this.lvProducerIndex();
            long l6 = this.lvProducerLimit();
            if ((l2 & 1L) == 1L) {
                thread = this.lvBlocked();
                if (thread == null) continue;
                if (!this.casProducerIndex(l2, l2 + 1L)) {
                    thread = null;
                    continue;
                }
                l4 = l2 + 1L;
                --l2;
                break;
            }
            l4 = Math.min(l6, l2 + l5);
            if (l2 >= l6) {
                if (!this.recalculateProducerLimit(l3, l2, l6)) {
                    return 0;
                }
                l4 = Math.min(this.lvProducerLimit(), l2 + l5);
            }
            if (this.casProducerIndex(l2, l4)) break;
        }
        int n3 = (int)((l4 - l2) / 2L);
        Object[] objectArray = this.producerBuffer;
        for (int i2 = 0; i2 < n3; ++i2) {
            long l7 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2 + 2L * (long)i2, l3);
            UnsafeRefArrayAccess.soRefElement(objectArray, l7, supplier.get());
        }
        if (thread != null && this.lvBlocked() == thread) {
            LockSupport.unpark(thread);
        }
        return n3;
    }

    public int drain(MessagePassingQueue.Consumer<E> consumer, int n2, long l2, TimeUnit timeUnit) throws InterruptedException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.drain(consumer, n2);
        if (n3 != 0) {
            return n3;
        }
        E e2 = this.poll(l2, timeUnit);
        if (e2 == null) {
            return 0;
        }
        consumer.accept(e2);
        return 1 + this.drain(consumer, n2 - 1);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        return MessagePassingQueueUtil.fillBounded(this, supplier);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.fill(this, supplier, waitStrategy, exitCondition);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return this.drain(consumer, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n2) {
        return MessagePassingQueueUtil.drain(this, consumer, n2);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, consumer, waitStrategy, exitCondition);
    }
}

