/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omp.core;

import com.contrastsecurity.thirdparty.omp.core.MessageFormatException;
import com.contrastsecurity.thirdparty.omp.core.MessagePack;
import com.contrastsecurity.thirdparty.omp.core.annotations.VisibleForTesting;
import com.contrastsecurity.thirdparty.omp.value.ValueType;

public enum MessageFormat {
    POSFIXINT(ValueType.INTEGER),
    FIXMAP(ValueType.MAP),
    FIXARRAY(ValueType.ARRAY),
    FIXSTR(ValueType.STRING),
    NIL(ValueType.NIL),
    NEVER_USED(null),
    BOOLEAN(ValueType.BOOLEAN),
    BIN8(ValueType.BINARY),
    BIN16(ValueType.BINARY),
    BIN32(ValueType.BINARY),
    EXT8(ValueType.EXTENSION),
    EXT16(ValueType.EXTENSION),
    EXT32(ValueType.EXTENSION),
    FLOAT32(ValueType.FLOAT),
    FLOAT64(ValueType.FLOAT),
    UINT8(ValueType.INTEGER),
    UINT16(ValueType.INTEGER),
    UINT32(ValueType.INTEGER),
    UINT64(ValueType.INTEGER),
    INT8(ValueType.INTEGER),
    INT16(ValueType.INTEGER),
    INT32(ValueType.INTEGER),
    INT64(ValueType.INTEGER),
    FIXEXT1(ValueType.EXTENSION),
    FIXEXT2(ValueType.EXTENSION),
    FIXEXT4(ValueType.EXTENSION),
    FIXEXT8(ValueType.EXTENSION),
    FIXEXT16(ValueType.EXTENSION),
    STR8(ValueType.STRING),
    STR16(ValueType.STRING),
    STR32(ValueType.STRING),
    ARRAY16(ValueType.ARRAY),
    ARRAY32(ValueType.ARRAY),
    MAP16(ValueType.MAP),
    MAP32(ValueType.MAP),
    NEGFIXINT(ValueType.INTEGER);

    private static final MessageFormat[] formatTable;
    private final ValueType valueType;

    private MessageFormat(ValueType valueType) {
        this.valueType = valueType;
    }

    public ValueType getValueType() throws MessageFormatException {
        if (this == NEVER_USED) {
            throw new MessageFormatException("Cannot convert NEVER_USED to ValueType");
        }
        return this.valueType;
    }

    public static MessageFormat valueOf(byte by2) {
        return formatTable[by2 & 0xFF];
    }

    @VisibleForTesting
    static MessageFormat toMessageFormat(byte by2) {
        if (MessagePack.Code.isPosFixInt(by2)) {
            return POSFIXINT;
        }
        if (MessagePack.Code.isNegFixInt(by2)) {
            return NEGFIXINT;
        }
        if (MessagePack.Code.isFixStr(by2)) {
            return FIXSTR;
        }
        if (MessagePack.Code.isFixedArray(by2)) {
            return FIXARRAY;
        }
        if (MessagePack.Code.isFixedMap(by2)) {
            return FIXMAP;
        }
        switch (by2) {
            case -64: {
                return NIL;
            }
            case -62: 
            case -61: {
                return BOOLEAN;
            }
            case -60: {
                return BIN8;
            }
            case -59: {
                return BIN16;
            }
            case -58: {
                return BIN32;
            }
            case -57: {
                return EXT8;
            }
            case -56: {
                return EXT16;
            }
            case -55: {
                return EXT32;
            }
            case -54: {
                return FLOAT32;
            }
            case -53: {
                return FLOAT64;
            }
            case -52: {
                return UINT8;
            }
            case -51: {
                return UINT16;
            }
            case -50: {
                return UINT32;
            }
            case -49: {
                return UINT64;
            }
            case -48: {
                return INT8;
            }
            case -47: {
                return INT16;
            }
            case -46: {
                return INT32;
            }
            case -45: {
                return INT64;
            }
            case -44: {
                return FIXEXT1;
            }
            case -43: {
                return FIXEXT2;
            }
            case -42: {
                return FIXEXT4;
            }
            case -41: {
                return FIXEXT8;
            }
            case -40: {
                return FIXEXT16;
            }
            case -39: {
                return STR8;
            }
            case -38: {
                return STR16;
            }
            case -37: {
                return STR32;
            }
            case -36: {
                return ARRAY16;
            }
            case -35: {
                return ARRAY32;
            }
            case -34: {
                return MAP16;
            }
            case -33: {
                return MAP32;
            }
        }
        return NEVER_USED;
    }

    static {
        formatTable = new MessageFormat[256];
        for (int i2 = 0; i2 <= 255; ++i2) {
            MessageFormat messageFormat;
            MessageFormat.formatTable[i2] = messageFormat = MessageFormat.toMessageFormat((byte)i2);
        }
    }
}

