/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.debug;

import com.contrastsecurity.thirdparty.omv2.ast.ASTNode;
import com.contrastsecurity.thirdparty.omv2.ast.BinaryOperation;
import com.contrastsecurity.thirdparty.omv2.ast.NestedStatement;
import com.contrastsecurity.thirdparty.omv2.ast.Substatement;
import com.contrastsecurity.thirdparty.omv2.compiler.CompiledExpression;
import com.contrastsecurity.thirdparty.omv2.compiler.ExecutableAccessor;
import com.contrastsecurity.thirdparty.omv2.compiler.ExecutableLiteral;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolver;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.omv2.util.ASTLinkedList;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugTools {
    public static String decompile(Serializable serializable) {
        if (serializable instanceof CompiledExpression) {
            return DebugTools.decompile((CompiledExpression)serializable);
        }
        if (serializable instanceof ExecutableAccessor) {
            return "CANNOT DECOMPILE OPTIMIZED STATEMENT (Run with -Dmvel.optimizer=false)";
        }
        if (serializable instanceof ExecutableLiteral) {
            return "LITERAL: " + ((ExecutableLiteral)serializable).getValue(null, null);
        }
        return "NOT A KNOWN PAYLOAD: " + serializable.getClass().getName();
    }

    public static String decompile(CompiledExpression compiledExpression) {
        return DebugTools.decompile(compiledExpression, false, new DecompileContext());
    }

    private static String decompile(CompiledExpression compiledExpression, boolean bl2, DecompileContext decompileContext) {
        ASTLinkedList aSTLinkedList = new ASTLinkedList(compiledExpression.getFirstNode());
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl2) {
            stringBuffer.append("Expression Decompile\n-------------\n");
        }
        while (aSTLinkedList.hasMoreNodes()) {
            stringBuffer.append("(").append(decompileContext.node++).append(") ");
            ASTNode aSTNode = aSTLinkedList.nextNode();
            if (aSTNode instanceof NestedStatement && ((NestedStatement)((Object)aSTNode)).getNestedStatement() instanceof CompiledExpression) {
                stringBuffer.append("NEST [" + aSTNode.getClass().getSimpleName() + "]: { " + aSTNode.getName() + " }\n");
                stringBuffer.append(DebugTools.decompile((CompiledExpression)((NestedStatement)((Object)aSTNode)).getNestedStatement(), true, decompileContext));
            }
            if (aSTNode instanceof Substatement && ((Substatement)aSTNode).getStatement() instanceof CompiledExpression) {
                stringBuffer.append("NEST [" + aSTNode.getClass().getSimpleName() + "]: { " + aSTNode.getName() + " }\n");
                stringBuffer.append(DebugTools.decompile((CompiledExpression)((Substatement)aSTNode).getStatement(), true, decompileContext));
            } else if (aSTNode.isDebuggingSymbol()) {
                stringBuffer.append("DEBUG_SYMBOL :: " + aSTNode.toString());
            } else if (aSTNode.isLiteral()) {
                stringBuffer.append("LITERAL :: ").append(aSTNode.getLiteralValue()).append("'");
            } else if (aSTNode.isOperator()) {
                stringBuffer.append("OPERATOR [").append(DebugTools.getOperatorName(aSTNode.getOperator())).append("]: ").append(aSTNode.getName());
                if (aSTNode.isOperator(37)) {
                    stringBuffer.append("\n");
                }
            } else if (aSTNode.isIdentifier()) {
                stringBuffer.append("REFERENCE :: ").append(aSTNode.getClass().getSimpleName()).append(":").append(aSTNode.getName());
            } else if (aSTNode instanceof BinaryOperation) {
                BinaryOperation binaryOperation = (BinaryOperation)aSTNode;
                stringBuffer.append("OPERATION [" + DebugTools.getOperatorName(binaryOperation.getOperation()) + "] {").append(binaryOperation.getLeft().getName()).append("} {").append(binaryOperation.getRight().getName()).append("}");
            } else {
                stringBuffer.append("NODE [" + aSTNode.getClass().getSimpleName() + "] :: " + aSTNode.getName());
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("==END==");
        return stringBuffer.toString();
    }

    public static String getOperatorSymbol(int n2) {
        switch (n2) {
            case 0: {
                return "+";
            }
            case 1: {
                return "-";
            }
            case 31: {
                return "=";
            }
            case 52: {
                return "=+";
            }
            case 54: {
                return "=+";
            }
            case 53: {
                return "=";
            }
            case 6: {
                return "&";
            }
            case 7: {
                return "|";
            }
            case 10: {
                return "<<";
            }
            case 9: {
                return ">>";
            }
            case 12: {
                return "<<<";
            }
            case 11: {
                return ">>>";
            }
            case 8: {
                return "^";
            }
            case 26: {
                return "contains";
            }
            case 36: {
                return "convertable_to";
            }
            case 51: {
                return "--";
            }
            case 33: {
                return "++";
            }
            case 3: {
                return "/";
            }
            case 45: {
                return "do";
            }
            case 40: {
                return "else";
            }
            case 37: {
                return ";";
            }
            case 18: {
                return "==";
            }
            case 43: {
                return "for";
            }
            case 38: {
                return "foreach";
            }
            case 100: {
                return "function";
            }
            case 17: {
                return ">=";
            }
            case 15: {
                return ">";
            }
            case 39: {
                return "if";
            }
            case 50: {
                return "++";
            }
            case 32: {
                return "++";
            }
            case 25: {
                return "instanceof";
            }
            case 16: {
                return "<=";
            }
            case 14: {
                return "<";
            }
            case 4: {
                return "%";
            }
            case 2: {
                return "*";
            }
            case 19: {
                return "!=";
            }
            case 34: {
                return "new";
            }
            case 21: {
                return "&&";
            }
            case 22: {
                return "||";
            }
            case 5: {
                return "**";
            }
            case 35: {
                return "PROJECT";
            }
            case 24: {
                return "REGEX";
            }
            case 99: {
                return "RETURN";
            }
            case 28: {
                return "SIMILARITY";
            }
            case 27: {
                return "SOUNDEX";
            }
            case 20: {
                return "+";
            }
            case 44: {
                return "SWITCH";
            }
            case 29: {
                return "TERNARY_IF";
            }
            case 30: {
                return "TERNARY_ELSE";
            }
            case 41: {
                return "while";
            }
            case 23: {
                return "or";
            }
            case 101: {
                return "stacklang";
            }
        }
        return "UNKNOWN_OPERATOR";
    }

    public static String getOperatorName(int n2) {
        switch (n2) {
            case 0: {
                return "ADD";
            }
            case 1: {
                return "SUBTRACT";
            }
            case 31: {
                return "ASSIGN";
            }
            case 52: {
                return "ASSIGN_ADD";
            }
            case 54: {
                return "ASSIGN_STR_APPEND";
            }
            case 53: {
                return "ASSIGN_SUB";
            }
            case 6: {
                return "BIT_AND";
            }
            case 7: {
                return "BIT_OR";
            }
            case 10: {
                return "BIT_SHIFT_LEFT";
            }
            case 9: {
                return "BIT_SHIFT_RIGHT";
            }
            case 12: {
                return "BIT_UNSIGNED_SHIFT_LEFT";
            }
            case 11: {
                return "BIT_UNSIGNED_SHIFT_RIGHT";
            }
            case 8: {
                return "BIT_XOR";
            }
            case 26: {
                return "CONTAINS";
            }
            case 36: {
                return "CONVERTABLE_TO";
            }
            case 51: {
                return "DECREMENT";
            }
            case 33: {
                return "DECREMENT_ASSIGN";
            }
            case 3: {
                return "DIVIDE";
            }
            case 45: {
                return "DO";
            }
            case 40: {
                return "ELSE";
            }
            case 37: {
                return "END_OF_STATEMENT";
            }
            case 18: {
                return "EQUAL";
            }
            case 43: {
                return "FOR";
            }
            case 38: {
                return "FOREACH";
            }
            case 100: {
                return "FUNCTION";
            }
            case 17: {
                return "GREATER_THAN_OR_EQUAL";
            }
            case 15: {
                return "GREATHER_THAN";
            }
            case 39: {
                return "IF";
            }
            case 50: {
                return "INCREMENT";
            }
            case 32: {
                return "INCREMENT_ASSIGN";
            }
            case 25: {
                return "INSTANCEOF";
            }
            case 16: {
                return "LESS_THAN_OR_EQUAL";
            }
            case 14: {
                return "LESS_THAN";
            }
            case 4: {
                return "MODULUS";
            }
            case 2: {
                return "MULTIPLY";
            }
            case 19: {
                return "NOT_EQUAL";
            }
            case 34: {
                return "NEW_OBJECT";
            }
            case 21: {
                return "AND";
            }
            case 22: {
                return "OR";
            }
            case 5: {
                return "POWER_OF";
            }
            case 35: {
                return "PROJECT";
            }
            case 24: {
                return "REGEX";
            }
            case 99: {
                return "RETURN";
            }
            case 28: {
                return "SIMILARITY";
            }
            case 27: {
                return "SOUNDEX";
            }
            case 20: {
                return "STR_APPEND";
            }
            case 44: {
                return "SWITCH";
            }
            case 29: {
                return "TERNARY_IF";
            }
            case 30: {
                return "TERNARY_ELSE";
            }
            case 41: {
                return "WHILE";
            }
            case 23: {
                return "CHAINED_OR";
            }
            case 101: {
                return "STACKLANG";
            }
        }
        return "UNKNOWN_OPERATOR";
    }

    public static Class determineType(String string, CompiledExpression compiledExpression) {
        ASTLinkedList aSTLinkedList = new ASTLinkedList(compiledExpression.getFirstNode());
        while (aSTLinkedList.hasMoreNodes()) {
            ASTNode aSTNode = aSTLinkedList.nextNode();
            if (!string.equals(aSTNode.getName()) || !aSTNode.isAssignment()) continue;
            return aSTNode.getEgressType();
        }
        return null;
    }

    public static Map<String, VariableResolver> getAllVariableResolvers(VariableResolverFactory variableResolverFactory) {
        HashMap<String, VariableResolver> hashMap = new HashMap<String, VariableResolver>();
        VariableResolverFactory variableResolverFactory2 = variableResolverFactory;
        do {
            for (String string : variableResolverFactory2.getKnownVariables()) {
                hashMap.put(string, variableResolverFactory2.getVariableResolver(string));
            }
        } while ((variableResolverFactory2 = variableResolverFactory2.getNextFactory()) != null);
        return hashMap;
    }

    private static final class DecompileContext {
        public int node = 0;

        private DecompileContext() {
        }
    }
}

