/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.integration.impl;

import com.contrastsecurity.thirdparty.omv2.UnresolveablePropertyException;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolver;
import com.contrastsecurity.thirdparty.omv2.integration.impl.BaseVariableResolverFactory;
import com.contrastsecurity.thirdparty.omv2.integration.impl.SimpleSTValueResolver;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingMapVariableResolverFactory
extends BaseVariableResolverFactory {
    protected Map<String, Object> variables;

    public CachingMapVariableResolverFactory(Map map) {
        this.variables = map;
    }

    @Override
    public VariableResolver createVariable(String string, Object object) {
        try {
            VariableResolver variableResolver = this.getVariableResolver(string);
            variableResolver.setValue(object);
            return variableResolver;
        }
        catch (UnresolveablePropertyException unresolveablePropertyException) {
            SimpleSTValueResolver simpleSTValueResolver = new SimpleSTValueResolver(object, null, true);
            this.addResolver(string, simpleSTValueResolver);
            return simpleSTValueResolver;
        }
    }

    @Override
    public VariableResolver createVariable(String string, Object object, Class<?> clazz) {
        VariableResolver variableResolver;
        try {
            variableResolver = this.getVariableResolver(string);
        }
        catch (UnresolveablePropertyException unresolveablePropertyException) {
            variableResolver = null;
        }
        if (variableResolver != null && variableResolver.getType() != null) {
            throw new RuntimeException("variable already defined within scope: " + variableResolver.getType() + " " + string);
        }
        variableResolver = new SimpleSTValueResolver(object, clazz, true);
        this.addResolver(string, variableResolver);
        return variableResolver;
    }

    @Override
    public VariableResolver getVariableResolver(String string) {
        VariableResolver variableResolver = (VariableResolver)this.variableResolvers.get(string);
        if (variableResolver != null) {
            return variableResolver;
        }
        if (this.variables.containsKey(string)) {
            variableResolver = new SimpleSTValueResolver(this.variables.get(string), null);
            this.variableResolvers.put(string, variableResolver);
            return variableResolver;
        }
        if (this.nextFactory != null) {
            return this.nextFactory.getVariableResolver(string);
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + string + "'");
    }

    @Override
    public boolean isResolveable(String string) {
        return this.variableResolvers.containsKey(string) || this.variables != null && this.variables.containsKey(string) || this.nextFactory != null && this.nextFactory.isResolveable(string);
    }

    protected VariableResolver addResolver(String string, VariableResolver variableResolver) {
        this.variableResolvers.put(string, variableResolver);
        return variableResolver;
    }

    public void externalize() {
        for (Map.Entry entry : this.variableResolvers.entrySet()) {
            if (((VariableResolver)entry.getValue()).getFlags() != -1) continue;
            this.variables.put((String)entry.getKey(), ((VariableResolver)entry.getValue()).getValue());
        }
    }

    @Override
    public boolean isTarget(String string) {
        return this.variableResolvers.containsKey(string);
    }

    @Override
    public Set<String> getKnownVariables() {
        if (this.nextFactory == null) {
            if (this.variables != null) {
                return new HashSet<String>(this.variables.keySet());
            }
            return new HashSet<String>(0);
        }
        if (this.variables != null) {
            return new HashSet<String>(this.variables.keySet());
        }
        return new HashSet<String>(0);
    }

    public void clear() {
        this.variableResolvers.clear();
        this.variables.clear();
    }
}

