/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.optimizers;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.omv2.optimizers.AccessorOptimizer;
import com.contrastsecurity.thirdparty.omv2.optimizers.dynamic.DynamicOptimizer;
import com.contrastsecurity.thirdparty.omv2.optimizers.impl.asm.ASMAccessorOptimizer;
import com.contrastsecurity.thirdparty.omv2.optimizers.impl.refl.ReflectiveAccessorOptimizer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizerFactory {
    public static String DYNAMIC = "dynamic";
    public static String SAFE_REFLECTIVE = "reflective";
    private static String defaultOptimizer;
    private static final Map<String, AccessorOptimizer> accessorCompilers;
    private static ThreadLocal<Class<? extends AccessorOptimizer>> threadOptimizer;

    public static AccessorOptimizer getDefaultAccessorCompiler() {
        try {
            return (AccessorOptimizer)accessorCompilers.get(defaultOptimizer).getClass().newInstance();
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            throw new RuntimeException("unable to instantiate accessor compiler", exception2);
        }
    }

    public static AccessorOptimizer getAccessorCompiler(String string) {
        try {
            return (AccessorOptimizer)accessorCompilers.get(string).getClass().newInstance();
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            throw new RuntimeException("unable to instantiate accessor compiler", exception2);
        }
    }

    public static AccessorOptimizer getThreadAccessorOptimizer() {
        if (threadOptimizer.get() == null) {
            threadOptimizer.set(OptimizerFactory.getDefaultAccessorCompiler().getClass());
        }
        try {
            return threadOptimizer.get().newInstance();
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            throw new RuntimeException("unable to instantiate accessor compiler", exception2);
        }
    }

    public static void setThreadAccessorOptimizer(Class<? extends AccessorOptimizer> clazz) {
        if (clazz == null) {
            throw new RuntimeException("null optimizer");
        }
        threadOptimizer.set(clazz);
    }

    public static void setDefaultOptimizer(String string) {
        try {
            defaultOptimizer = string;
            AccessorOptimizer accessorOptimizer = accessorCompilers.get(defaultOptimizer);
            accessorOptimizer.init();
            threadOptimizer.set(null);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            throw new RuntimeException("unable to instantiate accessor compiler", exception2);
        }
    }

    public static void clearThreadAccessorOptimizer() {
        threadOptimizer.set(null);
        threadOptimizer.remove();
    }

    public static boolean isThreadAccessorOptimizerInitialized() {
        return threadOptimizer.get() != null;
    }

    static {
        accessorCompilers = new HashMap<String, AccessorOptimizer>();
        threadOptimizer = new ThreadLocal();
        accessorCompilers.put(SAFE_REFLECTIVE, new ReflectiveAccessorOptimizer());
        accessorCompilers.put(DYNAMIC, new DynamicOptimizer());
        try {
            if (OptimizerFactory.class.getClassLoader() != null) {
                OptimizerFactory.class.getClassLoader().loadClass("com.contrastsecurity.thirdparty.omv2.asm.ClassWriter");
            } else {
                ClassLoader.getSystemClassLoader().loadClass("com.contrastsecurity.thirdparty.omv2.asm.ClassWriter");
            }
            accessorCompilers.put("ASM", new ASMAccessorOptimizer());
        }
        catch (ClassNotFoundException classNotFoundException) {
            defaultOptimizer = SAFE_REFLECTIVE;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            throwable2.printStackTrace();
            System.err.println("[MVEL] Notice: Possible incorrect version of ASM present (3.0 required).  Disabling JIT compiler.  Reflective Optimizer will be used.");
            defaultOptimizer = SAFE_REFLECTIVE;
        }
        if (Boolean.getBoolean("mvel2.disable.jit")) {
            OptimizerFactory.setDefaultOptimizer(SAFE_REFLECTIVE);
        } else {
            OptimizerFactory.setDefaultOptimizer(DYNAMIC);
        }
    }
}

