/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.sh;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.omv2.MVEL;
import com.contrastsecurity.thirdparty.omv2.MVELInterpretedRuntime;
import com.contrastsecurity.thirdparty.omv2.ParserContext;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.omv2.integration.impl.MapVariableResolverFactory;
import com.contrastsecurity.thirdparty.omv2.sh.Command;
import com.contrastsecurity.thirdparty.omv2.sh.CommandException;
import com.contrastsecurity.thirdparty.omv2.sh.command.basic.BasicCommandSet;
import com.contrastsecurity.thirdparty.omv2.sh.command.file.FileCommandSet;
import com.contrastsecurity.thirdparty.omv2.templates.TemplateRuntime;
import com.contrastsecurity.thirdparty.omv2.util.PropertyTools;
import com.contrastsecurity.thirdparty.omv2.util.StringAppender;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellSession {
    public static final String PROMPT_VAR = "$PROMPT";
    private static final String[] EMPTY = new String[0];
    private final Map<String, Command> commands;
    private Map<String, Object> variables;
    private Map<String, String> env;
    private Object ctxObject;
    ParserContext pCtx;
    VariableResolverFactory lvrf;
    private int depth;
    private int cdepth;
    private boolean multi;
    private int multiIndentSize;
    private PrintStream out;
    private String prompt;
    private String commandBuffer;
    StringAppender inBuffer;
    final BufferedReader readBuffer;

    public ShellSession() {
        block3: {
            this.commands = new HashMap<String, Command>();
            this.pCtx = new ParserContext();
            this.multi = false;
            this.multiIndentSize = 0;
            this.out = System.out;
            this.inBuffer = new StringAppender();
            this.readBuffer = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Starting session...");
            this.variables = new HashMap<String, Object>();
            this.env = new HashMap<String, String>();
            this.commands.putAll(new BasicCommandSet().load());
            this.commands.putAll(new FileCommandSet().load());
            this.env.put(PROMPT_VAR, "[@{ new java.text.SimpleDateFormat('hh:mmaa').format(new java.util.Date(System.currentTimeMillis()))}] mvel2$ ");
            this.env.put("$OS_NAME", System.getProperty("os.name"));
            this.env.put("$OS_VERSION", System.getProperty("os.version"));
            this.env.put("$JAVA_VERSION", PropertyTools.getJavaVersion());
            this.env.put("$CWD", new File(".").getAbsolutePath());
            this.env.put("$COMMAND_PASSTRU", "false");
            this.env.put("$PRINTOUTPUT", "true");
            this.env.put("$ECHO", "false");
            this.env.put("$SHOW_TRACES", "true");
            this.env.put("$USE_OPTIMIZER_ALWAYS", "false");
            this.env.put("$PATH", "");
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(".mvelsh.properties");
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    this.env.put(string, resourceBundle.getString(string));
                }
            }
            catch (MissingResourceException missingResourceException) {
                System.out.println("No config file found.  Loading default config.");
                if (PropertyTools.contains(System.getProperty("os.name").toLowerCase(), "windows")) break block3;
                this.env.put("$PATH", "/bin:/usr/bin:/sbin:/usr/sbin");
            }
        }
        this.lvrf = new MapVariableResolverFactory(this.variables, new MapVariableResolverFactory(this.env));
    }

    public ShellSession(String string) {
        this();
        this.exec(string);
    }

    private void _exec() {
        String[] stringArray;
        final PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        InputStream inputStream = System.in;
        if ("true".equals(this.env.get("$ECHO"))) {
            this.out.println(">" + this.commandBuffer);
            this.out.flush();
        }
        if ((stringArray = this.inBuffer.append(this.commandBuffer).toString().split("\\s")).length != 0 && this.commands.containsKey(stringArray[0])) {
            String[] stringArray2;
            this.commandBuffer = null;
            if (stringArray.length > 1) {
                stringArray2 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            } else {
                stringArray2 = EMPTY;
            }
            try {
                this.commands.get(stringArray[0]).execute(this, stringArray2);
            }
            catch (CommandException commandException) {
                this.out.append("Error: ").append(commandException.getMessage()).append("\n");
            }
        } else {
            Object object;
            this.commandBuffer = null;
            try {
                if (this.shouldDefer(this.inBuffer)) {
                    this.multi = true;
                    return;
                }
                this.multi = false;
                if (Boolean.parseBoolean(this.env.get("$USE_OPTIMIZER_ALWAYS"))) {
                    object = MVEL.executeExpression((Object)MVEL.compileExpression(this.inBuffer.toString()), this.ctxObject, this.lvrf);
                } else {
                    MVELInterpretedRuntime mVELInterpretedRuntime = new MVELInterpretedRuntime(this.inBuffer.toString(), this.ctxObject, this.lvrf, this.pCtx);
                    object = mVELInterpretedRuntime.parse();
                }
            }
            catch (Exception exception) {
                String[] stringArray3;
                Object object2;
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                if ("true".equals(this.env.get("$COMMAND_PASSTHRU"))) {
                    object2 = stringArray[0];
                    if (((String)object2).startsWith("./")) {
                        object2 = new File(this.env.get("$CWD")).getAbsolutePath() + ((String)object2).substring(((String)object2).indexOf(47));
                        stringArray3 = new String[]{object2};
                    } else {
                        stringArray3 = this.env.get("$PATH").split("(:|;)");
                    }
                    boolean bl2 = false;
                    for (String string : stringArray3) {
                        Object object3;
                        File file = new File(string + "/" + (String)object2);
                        if (!file.exists() || !file.isFile()) continue;
                        bl2 = true;
                        String[] stringArray4 = new String[stringArray.length];
                        stringArray4[0] = file.getAbsolutePath();
                        System.arraycopy(stringArray, 1, stringArray4, 1, stringArray.length - 1);
                        try {
                            object3 = Runtime.getRuntime().exec(stringArray4);
                            final OutputStream outputStream = ((Process)object3).getOutputStream();
                            final InputStream inputStream2 = ((Process)object3).getInputStream();
                            InputStream inputStream3 = ((Process)object3).getErrorStream();
                            final RunState runState = new RunState(this);
                            Thread thread = new Thread(new Runnable(){

                                public void run() {
                                    byte[] byArray = new byte[25];
                                    try {
                                        while (true) {
                                            int n2;
                                            if ((n2 = inputStream2.read(byArray)) > 0) {
                                                for (int i2 = 0; i2 < n2; ++i2) {
                                                    printStream.print((char)byArray[i2]);
                                                }
                                                printStream.flush();
                                                continue;
                                            }
                                            if (!runState.isRunning()) break;
                                        }
                                    }
                                    catch (Exception exception) {
                                        Throwables.throwIfCritical(exception);
                                        Exception exception2 = exception;
                                    }
                                    printStream.flush();
                                    if (!ShellSession.this.multi) {
                                        ShellSession.this.multiIndentSize = (ShellSession.this.prompt = String.valueOf(TemplateRuntime.eval((String)ShellSession.this.env.get(ShellSession.PROMPT_VAR), ShellSession.this.variables))).length();
                                        ShellSession.this.out.append(ShellSession.this.prompt);
                                    } else {
                                        ShellSession.this.out.append(">").append(ShellSession.this.indent(ShellSession.this.multiIndentSize - 1 + ShellSession.this.depth * 4));
                                    }
                                }
                            });
                            Thread thread2 = new Thread(new Runnable((Process)object3, printStream){
                                final /* synthetic */ Process val$p;
                                final /* synthetic */ PrintStream val$sysPrintStream;
                                {
                                    this.val$p = process;
                                    this.val$sysPrintStream = printStream;
                                }

                                public void run() {
                                    Thread thread = new Thread(new Runnable(){

                                        public void run() {
                                            try {
                                                block2: while (runState.isRunning()) {
                                                    String string;
                                                    while ((string = ShellSession.this.readBuffer.readLine()) != null) {
                                                        if (runState.isRunning()) {
                                                            for (char c2 : string.toCharArray()) {
                                                                outputStream.write((byte)c2);
                                                            }
                                                            continue;
                                                        }
                                                        runState.getSession().setCommandBuffer(string);
                                                        continue block2;
                                                    }
                                                }
                                                outputStream.write(10);
                                                outputStream.flush();
                                            }
                                            catch (Exception exception) {
                                                Throwables.throwIfCritical(exception);
                                                Exception exception2 = exception;
                                            }
                                        }
                                    });
                                    thread.setPriority(1);
                                    thread.start();
                                    try {
                                        this.val$p.waitFor();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    this.val$sysPrintStream.flush();
                                    runState.setRunning(false);
                                    try {
                                        thread.join();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                            });
                            thread.setPriority(1);
                            thread.start();
                            thread2.setPriority(1);
                            thread2.start();
                            thread2.join();
                            try {
                                thread.notify();
                            }
                            catch (Exception exception3) {
                                Throwables.throwIfCritical(exception3);
                                Exception exception4 = exception3;
                            }
                        }
                        catch (Exception exception5) {
                            Throwables.throwIfCritical(exception5);
                            object3 = exception5;
                        }
                    }
                    if (bl2) {
                        this.inBuffer.reset();
                        return;
                    }
                }
                stringArray3 = new ByteArrayOutputStream();
                object2 = new PrintStream((OutputStream)stringArray3);
                exception2.printStackTrace((PrintStream)object2);
                ((PrintStream)object2).flush();
                this.env.put("$LAST_STACK_TRACE", new String(stringArray3.toByteArray()));
                if (Boolean.parseBoolean(this.env.get("$SHOW_TRACE"))) {
                    this.out.println(this.env.get("$LAST_STACK_TRACE"));
                } else {
                    this.out.println(exception2.toString());
                }
                this.inBuffer.reset();
                return;
            }
            if (object != null && "true".equals(this.env.get("$PRINTOUTPUT"))) {
                if (object.getClass().isArray()) {
                    this.out.println(Arrays.toString((Object[])object));
                } else {
                    this.out.println(String.valueOf(object));
                }
            }
        }
        this.inBuffer.reset();
    }

    public void run() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (true) {
                this.printPrompt();
                if (this.commandBuffer == null) {
                    this.commandBuffer = bufferedReader.readLine();
                }
                this._exec();
            }
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            exception2.printStackTrace();
            System.out.println("unexpected exception. exiting.");
            return;
        }
    }

    public void printPrompt() {
        if (!this.multi) {
            this.prompt = String.valueOf(TemplateRuntime.eval(this.env.get(PROMPT_VAR), this.variables));
            this.multiIndentSize = this.prompt.length();
            this.out.append(this.prompt);
        } else {
            this.out.append(">").append(this.indent(this.multiIndentSize - 1 + this.depth * 4));
        }
    }

    public boolean shouldDefer(StringAppender stringAppender) {
        char[] cArray = new char[stringAppender.length()];
        stringAppender.getChars(0, stringAppender.length(), cArray, 0);
        this.cdepth = 0;
        this.depth = 0;
        block6: for (int i2 = 0; i2 < cArray.length; ++i2) {
            switch (cArray[i2]) {
                case '/': {
                    if (i2 + 1 >= cArray.length || cArray[i2 + 1] != '*') continue block6;
                    ++this.cdepth;
                    continue block6;
                }
                case '*': {
                    if (i2 + 1 >= cArray.length || cArray[i2 + 1] != '/') continue block6;
                    --this.cdepth;
                    continue block6;
                }
                case '{': {
                    ++this.depth;
                    continue block6;
                }
                case '}': {
                    --this.depth;
                }
            }
        }
        return this.depth + this.cdepth > 0;
    }

    public String indent(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public Map<String, Command> getCommands() {
        return this.commands;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Object getCtxObject() {
        return this.ctxObject;
    }

    public void setCtxObject(Object object) {
        this.ctxObject = object;
    }

    public String getCommandBuffer() {
        return this.commandBuffer;
    }

    public void setCommandBuffer(String string) {
        this.commandBuffer = string;
    }

    public void exec(String string) {
        for (String string2 : string.split("\n")) {
            this.inBuffer.append(string2);
            this._exec();
        }
    }

    public static final class RunState {
        private boolean running = true;
        private ShellSession session;

        public RunState(ShellSession shellSession) {
            this.session = shellSession;
        }

        public ShellSession getSession() {
            return this.session;
        }

        public void setSession(ShellSession shellSession) {
            this.session = shellSession;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean bl2) {
            this.running = bl2;
        }
    }
}

