/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.commons.a;

import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.commons.a.c;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class a
extends OutputStream {
    public static final int DEFAULT_BLOCK_SIZE = 256;
    private final Deque<byte[]> buffers = new ArrayDeque<byte[]>();
    private final int initialBlockSize;
    private int nextBlockSize;
    private int alreadyBufferedSize;
    private int index;
    private boolean closed;

    public a() {
        this(256);
    }

    public a(int n2) {
        Preconditions.check(n2 > 0, "Initial block size must be greater than 0");
        this.initialBlockSize = n2;
        this.nextBlockSize = n2;
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.buffers.peekLast() == null || this.buffers.getLast().length == this.index) {
            this.addBuffer(1);
        }
        this.buffers.getLast()[this.index++] = (byte)n2;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n2 + n3 > byArray.length || n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.buffers.peekLast() == null || this.buffers.getLast().length == this.index) {
            this.addBuffer(n3);
        }
        if (this.index + n3 > this.buffers.getLast().length) {
            int n4;
            int n5 = n2;
            do {
                if (this.index == this.buffers.getLast().length) {
                    this.addBuffer(n3);
                }
                if (n3 < (n4 = this.buffers.getLast().length - this.index)) {
                    n4 = n3;
                }
                System.arraycopy(byArray, n5, this.buffers.getLast(), this.index, n4);
                n5 += n4;
                this.index += n4;
            } while ((n3 -= n4) > 0);
        } else {
            System.arraycopy(byArray, n2, this.buffers.getLast(), this.index, n3);
            this.index += n3;
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public String toString() {
        return this.toString(Charset.defaultCharset());
    }

    public String toString(Charset charset) {
        return new String(this.toByteArrayUnsafe(), charset);
    }

    public int size() {
        return this.alreadyBufferedSize + this.index;
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    public byte[] toByteArrayUnsafe() {
        int n2 = this.size();
        if (n2 == 0) {
            return Empty.BYTE_ARRAY;
        }
        this.resizeToSingleArray();
        return this.buffers.getFirst();
    }

    public byte[] toByteArray() {
        byte[] byArray = this.toByteArrayUnsafe();
        return (byte[])byArray.clone();
    }

    public void reset() {
        this.buffers.clear();
        this.nextBlockSize = this.initialBlockSize;
        this.closed = false;
        this.index = 0;
        this.alreadyBufferedSize = 0;
    }

    public InputStream getInputStream() {
        return new a(this);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        Iterator<byte[]> iterator = this.buffers.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = iterator.next();
            if (iterator.hasNext()) {
                outputStream.write(byArray, 0, byArray.length);
                continue;
            }
            outputStream.write(byArray, 0, this.index);
        }
    }

    public void resize(int n2) {
        Preconditions.check(n2 >= this.size(), "New capacity must not be smaller than current size");
        if (this.buffers.peekFirst() == null) {
            this.nextBlockSize = n2 - this.size();
        } else if (this.size() != n2 || this.buffers.getFirst().length != n2) {
            int n3 = this.size();
            byte[] byArray = new byte[n2];
            int n4 = 0;
            Iterator<byte[]> iterator = this.buffers.iterator();
            while (iterator.hasNext()) {
                byte[] byArray2 = iterator.next();
                if (iterator.hasNext()) {
                    System.arraycopy(byArray2, 0, byArray, n4, byArray2.length);
                    n4 += byArray2.length;
                    continue;
                }
                System.arraycopy(byArray2, 0, byArray, n4, this.index);
            }
            this.buffers.clear();
            this.buffers.add(byArray);
            this.index = n3;
            this.alreadyBufferedSize = 0;
        }
    }

    private void resizeToSingleArray() {
        int n2 = this.index;
        int n3 = this.size();
        if (this.buffers.peekFirst() != null && this.buffers.getFirst().length != n3) {
            byte[] byArray = new byte[n3];
            int n4 = n3;
            int n5 = 0;
            Iterator<byte[]> iterator = this.buffers.iterator();
            while (iterator.hasNext()) {
                byte[] byArray2 = iterator.next();
                if (iterator.hasNext()) {
                    if (n4 < byArray2.length) {
                        throw new ArrayIndexOutOfBoundsException("Mismatch, data.len: " + byArray.length + ", pos: " + n5 + ", toCopy:" + byArray2.length);
                    }
                    System.arraycopy(byArray2, 0, byArray, n5, byArray2.length);
                    n5 += byArray2.length;
                    n4 -= byArray2.length;
                    continue;
                }
                if (n4 < n2) {
                    throw new ArrayIndexOutOfBoundsException("Mismatch, data.len: " + byArray.length + ", pos: " + n5 + ", toCopy:" + n2);
                }
                System.arraycopy(byArray2, 0, byArray, n5, n2);
                n4 -= n2;
            }
            this.buffers.clear();
            this.buffers.add(byArray);
            this.index = n3;
            this.alreadyBufferedSize = 0;
        }
    }

    private void addBuffer(int n2) {
        if (this.buffers.peekLast() != null) {
            this.alreadyBufferedSize += this.index;
            this.index = 0;
        }
        if (this.nextBlockSize < n2) {
            this.nextBlockSize = a.nextPowerOf2(n2);
        }
        this.buffers.add(new byte[this.nextBlockSize]);
        this.nextBlockSize *= 2;
    }

    private static int nextPowerOf2(int n2) {
        --n2;
        n2 = n2 >> 1 | n2;
        n2 = n2 >> 2 | n2;
        n2 = n2 >> 4 | n2;
        n2 = n2 >> 8 | n2;
        n2 = n2 >> 16 | n2;
        return ++n2;
    }

    private static final class a
    extends c {
        private final a a;
        private Iterator<byte[]> b;
        private byte[] c;
        private int d;
        private int e;
        private int f;

        public a(a a2) {
            this.a = a2;
            this.b();
        }

        @Override
        public int read() {
            if (this.c == null) {
                return -1;
            }
            if (this.e < this.d) {
                ++this.f;
                return this.c[this.e++] & 0xFF;
            }
            if (this.b.hasNext()) {
                this.c = this.b.next();
                this.a();
                this.e = 0;
            } else {
                this.c = null;
            }
            return this.read();
        }

        @Override
        public int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) {
            if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return 0;
            }
            if (this.c == null) {
                return -1;
            }
            if (this.e < this.d) {
                int n4 = Math.min(n3, this.d - this.e);
                System.arraycopy(this.c, this.e, byArray, n2, n4);
                this.f += n4;
                this.e += n4;
                int n5 = this.read(byArray, n2 + n4, n3 - n4);
                return n4 + Math.max(n5, 0);
            }
            if (this.b.hasNext()) {
                this.c = this.b.next();
                this.a();
                this.e = 0;
            } else {
                this.c = null;
            }
            return this.read(byArray, n2, n3);
        }

        @Override
        public long skip(long l2) throws IOException {
            if (l2 > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("n exceeds maximum (2147483647): " + l2);
            }
            if (l2 == 0L) {
                return 0L;
            }
            if (l2 < 0L) {
                throw new IllegalArgumentException("n must be 0 or greater: " + l2);
            }
            int n2 = (int)l2;
            if (this.c == null) {
                return 0L;
            }
            if (this.e < this.d) {
                int n3 = Math.min(n2, this.d - this.e);
                this.f += n3;
                this.e += n3;
                return (long)n3 + this.skip(n2 - n3);
            }
            if (this.b.hasNext()) {
                this.c = this.b.next();
                this.a();
                this.e = 0;
            } else {
                this.c = null;
            }
            return this.skip(n2);
        }

        @Override
        public int available() {
            return this.a.size() - this.f;
        }

        @Override
        public void a(MessageDigest messageDigest) {
            this.a(messageDigest, this.available());
        }

        @Override
        public void a(MessageDigest messageDigest, int n2) {
            if (this.c == null) {
                return;
            }
            if (n2 == 0) {
                return;
            }
            if (n2 < 0) {
                throw new IllegalArgumentException("len must be 0 or greater: " + n2);
            }
            if (this.e < this.d) {
                int n3 = Math.min(n2, this.d - this.e);
                messageDigest.update(this.c, this.e, n3);
                this.e += n3;
                this.a(messageDigest, n2 - n3);
            } else {
                if (this.b.hasNext()) {
                    this.c = this.b.next();
                    this.a();
                    this.e = 0;
                } else {
                    this.c = null;
                }
                this.a(messageDigest, n2);
            }
        }

        private void a() {
            this.d = this.c == this.a.buffers.getLast() ? this.a.index : (this.c != null ? this.c.length : 0);
        }

        @Override
        public void reset() {
            this.b();
            this.f = 0;
            this.e = 0;
        }

        private void b() {
            this.b = this.a.buffers.iterator();
            if (this.b.hasNext()) {
                this.c = this.b.next();
                this.d = this.c == this.a.buffers.getLast() ? this.a.index : (this.c != null ? this.c.length : 0);
            }
        }
    }
}

