/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.config;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.BooleanOrDefault;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.SimpleSleeper;
import com.contrastsecurity.agent.config.c.a;
import com.contrastsecurity.agent.config.c.b;
import com.contrastsecurity.agent.config.c.c;
import com.contrastsecurity.agent.config.d;
import com.contrastsecurity.agent.config.enums.SaveReportMode;
import com.contrastsecurity.agent.config.enums.TraceMapStrategy;
import com.contrastsecurity.agent.config.exception.ContrastConfigurationException;
import com.contrastsecurity.agent.config.h;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.DiagnosticsDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.DiagnosticsLoggerDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsAssessDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsDTM;
import com.contrastsecurity.agent.logging.LoggingConstants;
import com.contrastsecurity.agent.messages.app.settings.ApplicationAssessSettingsDTM;
import com.contrastsecurity.agent.messages.app.settings.ApplicationSettingsDTM;
import com.contrastsecurity.agent.messages.app.settings.protect.CommonConfigProtectionMode;
import com.contrastsecurity.agent.messages.app.settings.protect.ProtectionModeDTM;
import com.contrastsecurity.agent.messages.server.features.protect.LogLevel;
import com.contrastsecurity.agent.messages.server.features.protect.SyslogSeverity;
import com.contrastsecurity.agent.plugins.protect.ProtectRuleId;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

@DontObfuscate
public enum ConfigProperty {
    ZOMBIE_CHECK_PERIOD_MS(com.contrastsecurity.agent.config.b.a(Integer.class).a(10000).c().b("On IBM systems, Contrast periodically checks to see if it is preventing a graceful JVM shutdown. This is the period (in milliseconds) between these checks. A negative value disables the checks").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.zombie_check_period_ms")).f()),
    TELEMETRY_SEMANTIC_SQL_START_DATE(com.contrastsecurity.agent.config.b.a(String.class).a("2020-04-01").c().b("Date and time (format yyyy-MM-dd 00:00:00z) at which to start the Protect SQLi semantic analysis experiment").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.stx.sqli_semantic.start_date")).f()),
    TELEMETRY_SEMANTIC_SQL_EXPIRATION_DATE(com.contrastsecurity.agent.config.b.a(String.class).a("2020-05-01").c().b("Date and time (format yyyy-MM-dd 00:00:00z) after which to the Protect SQLi semantic analysis experiment expires").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.stx.sqli_semantic.expired_date")).f()),
    TELEMETRY_SEMANTIC_SQL_REPORT_INTERVAL(com.contrastsecurity.agent.config.b.a(Long.class).a(300000L).c().b("Interval in millis for reporting Protect SQLi semantic analysis telemetry data").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.stx.sqli_semantic.report_interval_ms")).f()),
    TELEMETRY_SEMANTIC_SQL_SAMPLE_SPACING(com.contrastsecurity.agent.config.b.a(Integer.class).a(300000).c().b("frequency (expres in number of queries) with which to report SQL queries for the Protect SQLi semantic analysis experiment").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.stx.sqli_semantic.sample_spacing")).f()),
    AGENT_METADATA(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.agent.metadata").a().b("Metadata from the agent to Contrast UI defined. The format should be HTTP Request header compatible where key=value pairs are separated by semicolons. Spaces between key and value and between entries is not significant. (e.g. key=value; key=value)").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("application.metadata", true)).f()),
    SESSION_ID(com.contrastsecurity.agent.config.b.a(String.class).a().b("Provide the ID of a session which already exists in the Contrast UI. Vulnerabilities discovered by the agent are associated with this session. If an invalid ID is supplied, the agent will be disabled. This option and `application.session_metadata` are mutually exclusive; if both are set, the agent will be disabled.").a(Category.GENERAL_PROPERTIES).e().a(com.contrastsecurity.agent.config.a.a("application.session_id", true)).f()),
    SESSION_METADATA(com.contrastsecurity.agent.config.b.a(String.class).a().b("Provide metadata which is used to create a new session ID in the Contrast UI. Vulnerabilities discovered by the agent are associated with this new session. This value should be formatted as key=value pairs (conforming to RFC 2253). Available key names for this configuration are branchName, buildNumber, commitHash, committer, gitTag, repository, testRun, and version. This option and `application.session_id` are mutually exclusive; if both are set the agent will be disabled.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("application.session_metadata", true)).f()),
    PROBABILISTIC_STARTUP(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.startup.probabilistic")).a(-1).c().b("the percentage chance that the agent should startup (values are 1-99 inclusive)").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.probabilistic_startup")).f()),
    INVENTORY_LIBRARIES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.inventory.libraries")).a(true).b("controls whether libraries are analyzed").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("inventory.analyze_libraries")).f()),
    LIBRARY_USAGE_REPORTING(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.libraries.reporting")).a(true).b("controls whether library usage is reported").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.library_usage.reporting.enable")).f()),
    EFFECTIVE_CONFIG_REPORTING(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).b("controls whether effective config is reported").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.effective_config.reporting.enable")).f()),
    COLLAPSING_QUEUE_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(5000).c().b("Set the maximum size (in number of items) of the buffer used to collapse pending reports.").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.reporting.collapsing_queue_size")).f()),
    DEBUG_DUPLICATE_CHANGES(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).a(Category.INTERNAL_USAGE).c().b("NOTE: This setting intentionally causes IllegalStateExceptions when more than once type of change is applied simultaneously on the same method: (e.g. Two propagators).").a(com.contrastsecurity.agent.config.a.a("agent.java.debug_duplicate_policy_changes")).f()),
    PRINT_ALL_THROWABLES(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).a(Category.INTERNAL_USAGE).c().b("NOTE: this setting can cause extreme performance degradation. Use with caution. Set to true to print a dump of every stacktrace to stdout. Prints a dump for each Throwable created on the JVM after the agent is initialized. This configuration is helpful for diagnosing issues where the agent instrumentation breaks fundamental JVM features, but the error is swallowed.").a(com.contrastsecurity.agent.config.a.a("agent.java.print_all_throwables")).f()),
    PRINT_THREAD_DUMP_ON_SHUTDOWN(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).a(Category.INTERNAL_USAGE).c().b("Set to true to print a dump of stacktraces for all threads to stdout when the JVM is shut down. This configuration is helpful for diagnosing deadlocks.").a(com.contrastsecurity.agent.config.a.a("agent.java.print_thread_dump_on_shutdown")).f()),
    COLLAPSING_WINDOW(com.contrastsecurity.agent.config.b.a(Long.class).a(15000L).c().b("Set the time (in milliseconds) to wait before collapsing pending reports. Longer wait times may reduce the network traffic at the expense of consuming more memory.").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.reporting.collapsing_window_ms")).f()),
    AGENT_LOCATION(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.agent.location").a().c().b("set by the launcher agent to tell agents where the location of the agent jar").a(Category.INTERNAL_USAGE).d("TODO: looks launcher related. Remove.").f()),
    USE_HTTP_COMPRESSION(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.agent.http.compression")).a(true).c().b("set for debugging purposes, tells the Agent not to compress HTTP Request payloads; default true").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_http_compression")).f()),
    IGNORE_CERTIFICATE_ERRORS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.agent.http.ignorecerterrors")).a(false).b("whether certificate errors are ignored when talking to TeamServer").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("api.certificate.ignore_cert_errors", Lists.of("contrast.ignore_cert_errors", "api.ignore_cert_errors"))).f()),
    DEFAULT_ISOLATED_SOCKET_FACTORY(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Configure the agent to use the default isolated socket strategy to avoid conflicts with container socket strategies. This option uses the default keystore and truststore").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.default_isolated_socket_factory")).f()),
    ISOLATED_SOCKET_FACTORY(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Configure the agent to use an isolated socket strategy to avoid conflicts with container socket strategies. This option attempts to access the configured keystore and truststore and falls back to the default if that fails").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.isolated_socket_factory")).f()),
    EXPLICIT_SNI_SOCKET_FACTORY(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("set SNI information on TLS extension manually to avoid JDK bugs where the information is not sent in niche cases").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("api.explicit_sni_socket_factory")).f()),
    MQ_TELEMETRY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.mq")).a(false).c().b("true, if the agent should send telemetry MQ messages -- false otherwise").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.mq_reporter.enable")).f()),
    MQ_HOST_NAME(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.mq.host.name").a("localhost").c().b("if contrast.mq is true, this allows us to specify the MQ host name").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.mq_reporter.hostname")).f()),
    MQ_PORT(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.mq.host.port")).a(5672).c().b("if contrast.mq is true, this allows us to specify the MQ port").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.mq_reporter.port")).f()),
    MQ_USERNAME(com.contrastsecurity.agent.config.b.a(String.class).a().c().b("Optional property, if contrast.mq is true, this allows us to specify the username for the MQ connection").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.mq_reporter.username")).f()),
    MQ_PASSWORD(com.contrastsecurity.agent.config.b.a(String.class).a().c().b("Optional property, if contrast.mq is true, this allows us to specify the password for the MQ connection").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.mq_reporter.password")).f()),
    MQ_QUEUE_NAME(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.mq.queue.name").a("contrastEvents").c().b("if contrast.mq is true, this allows us to specify the MQ queue name").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.mq_reporter.queue_name")).f()),
    LOG_CONTEXT_SWITCH(com.contrastsecurity.agent.config.b.a(String.class).a("NONE").c().b("set for debugging purposes, tells the Agent how much detail to log when context switching. Valid values are NONE (the default), IDENTITY, and FULL. If debug logs are not enabled, this property has no effect. See JAVA-3308 for more details.").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.log_context_switch")).f()),
    CLOUD_RESOURCE_DETECTOR_TIMEOUT_MS(com.contrastsecurity.agent.config.b.a(Integer.class).a(10000).c().b("The timeout which will be used for the requests from the cloud resource detector").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.cloud_resource_detector.request_timeout")).f()),
    CLOUD_RESOURCE_DETECTOR_BACKOFF_FACTOR_MS(com.contrastsecurity.agent.config.b.a(Long.class).a(1000L).c().b("The factor which will be multiplied by the exponential backoff factor to obtain the total backoff milliseconds when retrying cloud resource detection requests.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.cloud_resource_detector.backoff_factor_ms")).f()),
    CLOUD_RESOURCE_DETECTOR_MAX_TOTAL_BACKOFF_MS(com.contrastsecurity.agent.config.b.a(Long.class).a(60000L).c().b("The maximum total backoff in milliseconds that should be used when retrying cloud resource detection requests. Once this maximum is exceeded, no more retries will be attempted for the specific failed request.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.cloud_resource_detector.max_retries")).f()),
    DIAGNOSTICS_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("Enables the agent diagnostics. Disable to prevent any agent diagnostics from running.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.diagnostics.enable")).f()),
    DIAGNOSTICS_LOGGER_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Enables the agent diagnostics logger which will stream logs to a remote collector.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.diagnostics.logger.enable")).a(serverSettingsDTM -> {
        DiagnosticsLoggerDTM diagnosticsLoggerDTM = ConfigProperty.getDiagnosticsLogger(serverSettingsDTM);
        if (diagnosticsLoggerDTM == null) {
            return null;
        }
        return diagnosticsLoggerDTM.isEnabled();
    }).f()),
    DIAGNOSTICS_LOGGER_LEVEL(com.contrastsecurity.agent.config.b.a(String.class).a(LoggingConstants.DEFAULT_DIAGNOSTICS_LOGGER_LEVEL.toString()).c().b("The log level for the diagnostics logger.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.diagnostics.logger.level")).a(serverSettingsDTM -> {
        DiagnosticsLoggerDTM diagnosticsLoggerDTM = ConfigProperty.getDiagnosticsLogger(serverSettingsDTM);
        if (diagnosticsLoggerDTM == null) {
            return null;
        }
        LogLevel logLevel = diagnosticsLoggerDTM.getLevel();
        if (logLevel == null) {
            return null;
        }
        return logLevel.name();
    }).f()),
    DIAGNOSTICS_LOGGER_EXPIRATION_TIME_MS(com.contrastsecurity.agent.config.b.a(Long.class).a(-1L).b("The expiration time for diagnostics (in milliseconds since the Unix Epoch, 1970-01-01). Defaults to 1 hour from when diagnostics start. Maximum is 24 hours from when diagnostics start.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.diagnostics.logger.expires_ms")).a(serverSettingsDTM -> {
        DiagnosticsLoggerDTM diagnosticsLoggerDTM = ConfigProperty.getDiagnosticsLogger(serverSettingsDTM);
        if (diagnosticsLoggerDTM == null) {
            return null;
        }
        return diagnosticsLoggerDTM.getExpiresMs();
    }).f()),
    DIAGNOSTICS_LOGGER_UUID(com.contrastsecurity.agent.config.b.a(String.class).a().b("The unique identifier for the current diagnostics logger collection. Defaults to a new UUID if none is provided.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.diagnostics.logger.uuid")).a(serverSettingsDTM -> {
        DiagnosticsLoggerDTM diagnosticsLoggerDTM = ConfigProperty.getDiagnosticsLogger(serverSettingsDTM);
        if (diagnosticsLoggerDTM == null) {
            return null;
        }
        return diagnosticsLoggerDTM.getUuid();
    }).f()),
    DIAGNOSTICS_LOGGER_BACKOFF_FACTOR_MS(com.contrastsecurity.agent.config.b.a(Long.class).a(1000L).c().b("The factor which will be multiplied by the exponential backoff factor to obtain the total backoff milliseconds when retrying Diagnostics requests.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.diagnostics.logger.backoff_factor_ms")).f()),
    DIAGNOSTICS_LOGGER_MAX_TOTAL_BACKOFF_MS(com.contrastsecurity.agent.config.b.a(Long.class).a(60000L).c().b("The maximum total backoff in milliseconds that should be used when retrying Diagnostics logger requests. Once this maximum is exceeded, no more retries will be attempted for the specific failed request.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.diagnostics.logger.max_backoff_ms")).f()),
    DIAGNOSTICS_LOGGER_BATCHING_TIMEOUT_MS(com.contrastsecurity.agent.config.b.a(Long.class).a(5000L).c().b("The time the Diagnostics logger will wait before forcing a (non-full) batch of logs to be sent to the collector.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.diagnostics.logger.batching_timeout_ms")).f()),
    DIAGNOSTICS_LOGGER_MAX_BATCH_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(32).c().b("Specify the number of messages that will be batched and sent to the Diagnostics logger.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.diagnostics.logger.batch_size")).f()),
    DIAGNOSTICS_LOGGER_BUFFER_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(-1).c().b("Specify the Diagnostics logger buffer size cap. Must be a power of 2. The default is 128. The default if the agent is in DEBUG mode or higher is 16384. Log messages are dropped if the buffer exceeds the size.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.diagnostics.logger.buffer_size")).f()),
    LOGGER_CLOCK_CLASS(com.contrastsecurity.agent.config.b.a(String.class).a().c().b("The class to be used for the logger's clock. Only used for testing.").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.logger.clock_class")).f()),
    OTEL_SLEEPER_CLASS(com.contrastsecurity.agent.config.b.a(String.class).a().c().b("The class to be used as the Otel reporting thread sleeper. Only used for testing. Defaults to " + SimpleSleeper.class.getTypeName()).a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.otel.sleeper_class")).f()),
    OTEL_JITTER_CLASS(com.contrastsecurity.agent.config.b.a(String.class).a().c().b("The class to be used as the Otel reporting thread jitter provider. Only used for testing. Defaults to com.contrastsecurity.agent.util.Jitter#RANDOM").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.otel.jitter_class")).f()),
    PROFILE_PURGEABLES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.profile.purgeables")).a(false).c().b("set for debugging purposes, tells the Agent to print to stdout purgeable metrics").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.report_purgeables")).f()),
    PROFILE_CONTEXT_METRICS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.profile.contextmetrics")).a(false).c().b("set for debugging purposes, tells the Agent to print to stdout metrics about per-request data collection").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.report_context_metrics")).f()),
    PROFILE_STARTUP(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.profile.startup")).a(false).c().b("set for debugging purposes, tells the Agent to print to stdout startup metrics").a(Category.INTERNAL_USAGE).d("The YAML property cannot be used since this property is obtained before the Config object is created. This property can only be set as a system property: -Dcontrast.profile.startup").f()),
    PURGING_DELAY(com.contrastsecurity.agent.config.b.a(Integer.class).a(30000).c().b("The delay between purging of the agent's internal data structures. Defaults to 30_000ms (30 seconds in milliseconds).").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.purging_delay_ms")).f()),
    CONCURRENCY_MAP_SYNCHRONISED(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Enable or disable synchronization of segments in the concurrency map").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_concurrency_map_sync")).f()),
    CONTEXT_MAP_PURGE_TIMEOUT(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.context.purge.timeout")).a(30000).c().b("number of milliseconds to allow strongly reachable threads to pass thread context. Defaults to 30000(30 seconds in milliseconds).").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.context_thread_timeout_ms")).f()),
    CONTEXT_MAP_PURGE_ENTRY_MINIMUM(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.context.purge.minimum")).a(350).c().b("number of threads to concurrently manage in our context manager before we proactively purge strongly reachable threads").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.context_minimum_threads")).f()),
    WEB_SESSION_TIMEOUT(com.contrastsecurity.agent.config.b.a(Integer.class).a(30).b("Overrides the maximum \"safe\" session timeout value to check against the <session-timeout> detected in the application web.xml file, ServletContext.setSessionTimeout(int), or Spring Boot application.properties. The default value is 30 (minutes).").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("agent.java.web_session_timeout")).f()),
    JACKSON_INTERN_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jackson.interning")).a(true).b("Controls whether String interning is disabled in Jackson. The default value is true.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jackson_intern")).f()),
    SUPPORTER_AKKA(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.akka")).a(true).c().b("boolean to enable/disable Akka support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_akka_support")).f()),
    SUPPORTER_ANTLR(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.antlr")).a(true).c().b("boolean to enable/disable instrumentation of standard Antlr classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_antlr_support")).f()),
    SUPPORTER_APACHE_FILE_UPLOAD(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache.file.uploader")).a(true).c().b("boolean enable/disable support of Apache Commons FileUpload library").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_apache_fileupload_support")).f()),
    SUPPORTER_APACHE_ACTIVEMQ(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache.activemq")).a(true).c().b("boolean enable/disable support of Apache ActiveMQ library").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_activemq_support")).f()),
    SUPPORTER_APACHE_CLIENT(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache.client")).a(true).c().b("boolean enable/disable support of Apache HTTP Client").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_apache_client_support")).f()),
    SUPPORT_APACHE_REQUEST(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache.request")).a(true).c().b("boolean enable/disable support of Apache Request Library").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_apache_request_support")).f()),
    SUPPORTER_APP_DYNAMICS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.appdynamics")).a(false).c().b("boolean enable/disable support of special sensors to avoid conflicts with AppDynamics").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_app_dynamics_support")).f()),
    SUPPORTER_APACHE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache")).a(true).c().b("boolean to enable/disable support/instrumentation of Apache HTTP libraries").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_apache_http_support")).f()),
    SUPPORTER_AWS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.aws")).a(true).c().b("boolean to enable/disable support/instrumentation of AWS HTTP client").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_aws_client_support")).f()),
    SUPPORTER_AWS_DYNAMODB(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.aws_dynamodb")).a(true).c().b("boolean to enable/disable support/instrumentation of AWS Dynamo client").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_aws_dynamo_support")).f()),
    SUPPORTER_CARBON(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.carbon")).a(true).c().b("boolean to enable/disable support for Carbon").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_carbon_support")).f()),
    SUPPORTER_STRUTS1(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.struts1")).a(true).c().b("boolean to enable/disable support for Struts1 applications").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_struts1_support")).f()),
    SUPPORTER_STRUTS2(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.struts2")).a(true).c().b("boolean to enable/disable support for Struts2 applications").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_struts2_support")).f()),
    SUPPORTER_CLASSLOADING(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.classloading")).a(true).c().b("boolean to enable/disable instrumentation of ClassLoaders").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_classloading_support")).f()),
    SUPPORTER_COVERITY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.coverity")).a(true).c().b("boolean to enable/disable instrumentation of Coverity").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_coverity_support")).f()),
    SUPPORTER_CODE_EXCLUSIONS(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable instrumentation of code exclusion classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_code_exclusion_support")).f()),
    SUPPORTER_CONCURRENCY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.concurrency")).a(true).c().b("boolean to enable/disable instrumentation of Java Concurrency classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_concurrency_support")).f()),
    SUPPORTER_FRAMEWORK_DEBUGGER(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.framework.debugging")).a(true).c().b("boolean to enable/disable support for framework debugging").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_framework_debugging_support")).f()),
    SUPPORTER_DROPWIZARD(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.dropwizard")).a(true).c().b("boolean to enable/disable support for DropWizard applications").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_dropwizard_support")).f()),
    SUPPORTER_DYNATRACE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable support for Dynatrace").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_dynatrace_support")).f()),
    DYNATRACE_MAX_DEPTH(com.contrastsecurity.agent.config.b.a(Integer.class).a(6).c().b("The max depth to search a stack trace for Dynatrace classes.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.dynatrace_max_depth")).f()),
    SUPPORTER_DWR(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.dwr")).a(true).c().b("boolean to enable/disable Direct Web Remoting support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_dwr_support")).f()),
    SUPPORTER_ESAPI(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.esapi")).a(true).c().b("boolean to enable/disable instrumentation of ESAPI classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_esapi_support")).f()),
    SUPPORTER_FREEMARKER(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.freemarker")).a(true).c().b("boolean to enable/disable FreeMarker support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_freemarker_support")).f()),
    SUPPORTER_GRIZZLY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.grizzly")).a(true).c().b("boolean to enable/disable Grizzly support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_grizzly_support")).f()),
    SUPPORTER_GLOWROOT(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable Glowroot support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_glowroot_support")).f()),
    SUPPORTER_GRAILS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.grails")).a(true).c().b("boolean to enable/disable Grails support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_grails_support")).f()),
    SUPPORTER_GRAPHQL(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable GraphQL support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_graphql_support")).f()),
    SUPPORTER_GROOVY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.groovy")).a(true).c().b("boolean to enable/disable Groovy support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_groovy_support")).f()),
    SUPPORTER_GRPC(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable gRPC support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_grpc_support")).f()),
    SUPPORTER_HIBERNATE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.hibernate")).a(true).c().b("boolean to enable/disable Hibernate support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_hibernate_support")).f()),
    SUPPORTER_HTTP4K(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.http4k")).a(true).c().b("boolean to enable/disable Http4k support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_http4k_support")).f()),
    SUPPORTER_JBOSS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jboss")).a(true).c().b("boolean to enable/disable JBoss support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jboss_support")).f()),
    SUPPORTER_J2EE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.j2ee")).a(true).c().b("boolean to enable/disable instrumentation of standard J2EE/Jakarta servlet classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_j2ee_support")).f()),
    SUPPORTER_JASPER(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jasper")).a(true).c().b("boolean to enable/disable instrumentation of standard Apache's Jasper classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jasper_support")).f()),
    SUPPORTER_JETTY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jetty")).a(true).c().b("boolean to enable/disable instrumentation of standard Jetty classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jetty_support")).f()),
    SUPPORTER_JMS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jms")).a(true).c().b("boolean to enable/disable instrumentation of standard JMS classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jms_support")).f()),
    SUPPORTER_JSP(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jsp")).a(true).c().b("boolean to enable/disable instrumentation of compiled JSP classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jsp_support")).f()),
    SUPPORTER_KAFKA(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.kafka")).a(true).c().b("boolean to enable/disable instrumentation of standard Kafka classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_kafka_support")).f()),
    SUPPORTER_LAMBDA(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.lambda")).a(true).c().b("boolean to enable/disable instrumentation of Java lambdas").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_lambda_support")).f()),
    SUPPORTER_LDAP(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.ldap")).a(true).c().b("boolean to enable/disable instrumentation of standard LDAP classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_ldap_support")).f()),
    SUPPORTER_LOG4J(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.log4j")).a(true).c().b("boolean to enable/disable instrumentation of standard Log4j classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_log4j_support")).f()),
    SUPPORTER_MODULE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable java.lang.Module and --illegal-access=deny support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_module_support")).f()),
    SUPPORTER_MONGO(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.mongo")).a(true).c().b("boolean to enable/disable instrumentation of standard Mongo classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_mongo_support")).f()),
    SUPPORTER_JACKSON(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jackson")).a(true).c().b("boolean to enable/disable Jackson support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jackson_support")).f()),
    SUPPORTER_JAXB(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jaxb")).a(true).c().b("boolean to enable/disable JAXB support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jaxb_support")).f()),
    SUPPORTER_JAVAX(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.javax")).a(true).c().b("boolean to enable/disable JavaX support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_javax_support")).f()),
    SUPPORTER_JAVAX_WS_RS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.javax.ws.rs")).a(true).c().b("boolean to enable/disable JaxRS support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_javax_ws_rs_support")).f()),
    SUPPORTER_JERSEY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jersey")).a(true).c().b("boolean to enable/disable Jersey support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jersey_support")).f()),
    SUPPORTER_JSF(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jsf")).a(true).c().b("boolean to enable/disable JSF support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jsf_support")).f()),
    SUPPORTER_JSF_ADF(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jsf.adf")).a(true).c().b("boolean to enable/disable JSF ADF support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jsf_adf_support")).f()),
    SUPPORTER_JSF_TRINIDAD(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jsf.trinidad")).a(true).c().b("boolean to enable/disable JSF Apache Trinidad support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jsf_trinidad_support")).f()),
    SUPPORTER_KRYO(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.kryo")).a(true).c().b("boolean to enable/disable Kryo support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_kyro_support")).f()),
    SUPPORTER_LIFERAY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.liferay")).a(true).c().b("boolean to enable/disable Liferay support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_liferay_support")).f()),
    SUPPORTER_MINIDEV_JSON(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.minidevjson")).a(true).b("boolean to enable/disable net.minidev.json support").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_minidev_json_support")).f()),
    SUPPORTER_MATCHER(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable support for java.util.regex.Matcher").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_matcher_support")).f()),
    SUPPORTER_MULESOFT(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.mulesoft")).a(false).c().b("boolean to enable/disable MuleSoft support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_mulesoft_support")).f()),
    SUPPORTER_MUSTACHE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.mustache")).a(true).c().b("boolean to enable/disable Mustache support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_mustache_support")).f()),
    SUPPORTER_NETTY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.netty")).a(true).c().b("boolean to enable/disable Netty support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_netty_support")).f()),
    SUPPORTER_OPEN_TELEMETRY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.opentelemtetry")).a(true).c().b("boolean to enable/disable OpenTelemetry support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_opentelemetry_support")).f()),
    SUPPORTER_OSGI(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.osgi")).a(true).c().b("boolean to enable/disable OSGi support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_osgi_support")).f()),
    SUPPORTER_OUTSYSTEMS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.outsystems")).a(true).c().b("boolean to enable/disable OutSystems support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_out_systems_support")).f()),
    SUPPORTER_PATTERNS(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable support for Patterns (Java/Perl5)").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_pattern_support")).f()),
    SUPPORTER_PLAY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.play")).a(true).c().b("boolean to enable/disable Play support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_play_support")).f()),
    SUPPORTER_QUARKUS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.quarkus")).a(true).c().b("boolean to enable/disable Quarkus related support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_quarkus_support")).f()),
    SUPPORTER_R2DBC(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable R2DBC support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_r2dbc_support")).f()),
    SUPPORTER_RABBITMQ(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.rabbitmq")).a(true).c().b("boolean to enable/disable Rabbit MQ support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_rabbit_mq_support")).f()),
    SUPPORTER_RESIN(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.resin")).a(true).c().b("boolean to enable/disable Resin support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_resin_support")).f()),
    SUPPORTER_RESTEASY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.resteasy")).a(true).c().b("boolean to enable/disable RESTEasy support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_resteasy_support")).f()),
    SUPPORTER_SCALA(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.scala")).a(true).c().b("boolean to enable/disable Scala support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_scala_support")).f()),
    SUPPORTER_SECONDORDER_CANARIES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.secondorder.canary")).a(true).c().b("boolean to enable/disable second-order canary support.  see the option assess.second_order_canary for more configuration details.").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_secondorder_canary_support")).f()),
    SUPPORTER_SEAM(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.seam")).a(true).c().b("boolean to enable/disable SEAM support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_seam_support")).f()),
    SUPPORTER_SECURITY_MANAGER(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.security_manager")).a(true).c().b("boolean to enable/disable Security Manager support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_security_manager_support")).f()),
    SUPPORTER_SMAP(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.smap")).a(true).c().b("boolean to enable/disable SMAP support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_smap_support")).f()),
    SUPPORTER_SQL(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.sql")).a(true).c().b("boolean to enable/disable java.sql support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_java_sql_support")).f()),
    SUPPORTER_SPRINGBOOT(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.spring_boot")).a(true).c().b("boolean to enable/disable Spring Boot support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_spring_boot_support")).f()),
    SUPPORTER_SPRING(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.spring")).a(true).c().b("boolean to enable/disable Spring support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_spring_support")).f()),
    SUPPORTER_SPRING_WEB_SERVICES(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable Spring Web Services support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_spring_web_services_support")).f()),
    SUPPORTER_STRUTS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.struts")).a(true).c().b("boolean to enable/disable Struts support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_struts_support")).f()),
    SUPPORTER_TECHNOLOGY_DETECTION(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.technology.detection")).a(true).c().b("boolean to enable/disable Technology Detection support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_technology_detection_support")).f()),
    SUPPORTER_TOMCAT(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.tomcat")).a(true).c().b("boolean to enable/disable Tomcat support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_tomcat_support")).f()),
    SUPPORTER_UNDERTOW(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.undertow")).a(true).c().b("boolean to enable/disable support for Undertow applications").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_undertow_support")).f()),
    SUPPORTER_URL(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.url")).a(true).c().b("boolean to enable/disable java.net.URL support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_java_url_support")).f()),
    SUPPORTER_VERTX(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.vertx")).a(true).c().b("boolean to enable/disable Vert.x support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_vertx_support")).f()),
    SUPPORTER_WEBLOGIC(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.weblogic")).a(true).c().b("boolean to enable/disable Weblogic support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_weblogic_support")).f()),
    SUPPORTER_W3C(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.w3c")).a(true).c().b("boolean to enable/disable W3C API support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_w3c_support")).f()),
    SUPPORTER_JAVA_NIO(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable java.nio support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_nio_support")).f()),
    SUPPORTER_JAVA_RMI(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("boolean to enable/disable java.rmi support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_rmi_support")).f()),
    SUPPORTER_JAVA_STRING(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.string")).a(true).c().b("boolean to enable/disable java.lang.String support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_java_string_support")).f()),
    SUPPORTER_WEBSPHERE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.websphere")).a(true).c().b("boolean to enable/disable WebSphere support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_websphere_support")).f()),
    SUPPORTER_CXF(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.cxf")).a(true).c().b("boolean to enable/disable Apache CXF support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_cxf_support")).f()),
    SUPPORTER_POI(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.poi")).a(true).c().b("boolean to enable/disable Apache POI support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_poi_support")).f()),
    SUPPORTER_XENON(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.xenon")).a(true).c().b("boolean to enable/disable VMware Xenon support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_xenon_support")).f()),
    SUPPORTER_XSTREAM(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.xstream")).a(true).c().b("boolean to enable/disable XStream support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_xstream_support")).f()),
    CACHE_HIERARCHY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.cache.hierarchy")).a(true).b("boolean to enable/disable hierarchy cache").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.cache.hierarchy_enable")).f()),
    FORCE_CACHE_HIERARCHY(com.contrastsecurity.agent.config.b.a(Boolean.class).c().a(false).b("boolean to enable/disable hierarchy cache regardless of container detection results").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.assess.cache.hierarchy_force")).f()),
    HIERARCHY_REBUILD(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.hierarchy.rebuild")).a(false).b("boolean to trigger rebuilding/resetting the hierarchy cache").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.cache.hierarchy_rebuild")).f()),
    HIERARCHY_UPDATE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.hierarchy.update")).a(false).b("boolean to trigger updating the hierarchy cache").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.cache.hierarchy_update")).f()),
    ANALYSIS_CACHE_MAX_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.analysiscache.size")).a(500000).c().b("maximum weighted size of the protect analysis cache. cache is weighted on total number of chars in each input value. This limits the usage of memory for the analysis cache. The default value of 500,000 limits usage to approximately 977 KB with 16bit char code units. This will vary depending on the JVM.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("protect.cache.analysis_cache_size_max")).f()),
    ANALYSIS_CACHE_STRING_LIMIT(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.analysiscache.stringlimit")).a(100000).c().b("maximum length in chars of a user input value that will be stored in the analysis cache. Larger values than this will not be cached.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("protect.cache.analysis_cache_string_limit")).f()),
    ANALYSIS_CACHE_EXPIRY(com.contrastsecurity.agent.config.b.a(Long.class).a((Long)((Object)"contrast.analysiscache.expiry.ms")).a(300000L).c().b("expiration time of elements within the analysis cache in milliseconds").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("protect.cache.analysis_cache_expiry_ms")).f()),
    NESTED_LIBS_DEPTH(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.nested.libs.depth")).a(3).b("max archive unpacking depth when analyzing libraries").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("inventory.library_depth")).f()),
    CLASSPATH_LIBS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.classpath.libs")).a(false).b("Boolean to enable/disable analysis of libraries listed in java.class.path property. Determines whether Contrast will track usage of libraries listed in the environment's *java.class.path* property. This should only be on in J2SE/desktop situations.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_classpath_libs")).f()),
    EVALUATE_PROTECT_TIMING_THRESHOLD(com.contrastsecurity.agent.config.b.a(Long.class).a(60000L).c().b("Timing threshold to log potentially slow evaluations for Protect in milliseconds.  A value of 0 is disabled.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.protect_evaluate_timing_threshold")).f()),
    EXTERNAL_LIB_DIR(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.external.lib.dir").a().b("List of directories where external libraries are stored; used during library analysis, delimited by ';' on Windows and ':' on Unix").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("inventory.library_dirs")).f()),
    APPLICATION_NAME(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.override.appname").a().b("sets the application name; this name will be reported to TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("application.name", true)).f()),
    APPLICATION_VERSION(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.override.appversion").a().b("sets the application version; this version will be reported to TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("application.version", true)).e().f()),
    ASSESS_CONTEXT_MAP_CONCURRENCY_LEVEL(com.contrastsecurity.agent.config.b.a(Integer.class).c().a(128).b("estimated number of concurrent threads that will create Assessment contexts.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.assess_context.concurrency_level")).f()),
    HEAP_PROFILER_INTERVAL_MS(com.contrastsecurity.agent.config.b.a(Long.class).c().a(900000L).b("interval which we should attempt heap profiling.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.heap_profiler.interval_ms")).f()),
    CPU_PROFILE_INTERVAL_MS(com.contrastsecurity.agent.config.b.a(Long.class).c().a(180000L).b("interval which we should attempt CPU sampling.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.cpu_sampling.interval_ms")).f()),
    CONCURRENT_REQUESTS(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.concurrent.requests")).a(20).b("average number of concurrent users logged into the application at any one time").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.concurrent_requests")).f()),
    HTTP_BUFFER_POOL_MAX_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(500).c().b("The max number of object allowed in the memory buffer pool").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.http_memory_pool.max_size")).f()),
    HTTP_BUFFER_POOL_TTL(com.contrastsecurity.agent.config.b.a(Integer.class).a(15).c().b("The TTL in minutes of a memory buffer object in the pool").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.http_memory_pool.ttl.mins")).f()),
    STANDALONE_APPNAME(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.standalone.appname").a().b("Indicates the application is a standalone app with the provided name").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.standalone_app_name")).f()),
    TEAMSERVER_CHANNEL_PAUSE_PERIOD(com.contrastsecurity.agent.config.b.a(Long.class).a((Long)((Object)"contrast.teamserver.channel.pause.period")).a(900000L).b("The amount of time to pause agent to TeamServer communication when a bad response code is received. 900000 (15 minutes in milliseconds).").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.polling.contrast_ui_channel_pause_period_ms")).f()),
    TEAMSERVER_URL(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.teamserver.url").b("Set the URL for the Contrast UI").a("https://app.contrastsecurity.com/Contrast").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("api.url", Lists.of("contrast.url"))).f()),
    TEAMSERVER_STARTUP_RETRY_TIME_MS(com.contrastsecurity.agent.config.b.a(Long.class).a(-1L).b("Set the time period to retry the initial connection to Contrast UI, after this timeout period is exceeded the agent will take action depending upon the associated failure_strategy property. The agent will immediately start as normal if the request succeeds. The default value is -1 indicating that retry is disabled. The expiry period must be longer than the retry_delay_ms setting.").a(Category.GENERAL_PROPERTIES).c().a(com.contrastsecurity.agent.config.a.a("agent.startup.retry_expiry_ms")).f()),
    TEAMSERVER_STARTUP_RETRY_DELAY_TIME_MS(com.contrastsecurity.agent.config.b.a(Long.class).a(500L).b("Set the time period to wait between retrying connecting to Contrast UI on startup. If the agent needs to retry the request it will sleep for this period in ms. The minimum allowed value is 500ms.").a(Category.GENERAL_PROPERTIES).c().a(com.contrastsecurity.agent.config.a.a("agent.startup.retry_delay_ms")).f()),
    STARTUP_FAILURE_STRATEGY(com.contrastsecurity.agent.config.b.a(String.class).a("continue").b("Set the action to take if the agent fails to start up correctly. Valid options are `continue` (default), `abort`. The `continue` option indicates the application continues without the agent being enabled. The abort option will stop the application if Contrast cannot startup and MUST be used with care.").a(Category.GENERAL_PROPERTIES).c().a(com.contrastsecurity.agent.config.a.a("agent.startup.failure_strategy")).f()),
    APP_SETTINGS_POLL_INTERVAL_MS(com.contrastsecurity.agent.config.b.a(Long.class).a(30000L).c().b("Set the frequency with which the agent polls for application settings from the Contrast UI. Default is 30,000 milliseconds (30 seconds).").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.polling.app_settings_ms")).f()),
    SERVER_SETTINGS_POLL_INTERVAL_MS(com.contrastsecurity.agent.config.b.a(Long.class).a(30000L).c().b("Set the frequency with which the agent sends server settings polls to the Contrast UI. This value is bounded within the agents, with a minimum of 1_000 and a maximum of 300_000.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.polling.server_settings_ms")).f()),
    TIMEOUT_MS(com.contrastsecurity.agent.config.b.a(Integer.class).a(10000).b("This value can override the default timeout (in milliseconds) for communicating with TeamServer.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("api.timeout_ms", Lists.of("contrast.timeout_ms"))).f()),
    PROXY_ENABLED(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.proxy.enable").a().b("If present, determines whether the Agent should communicate with TeamServer over a proxy. Otherwise, enabled status is determined by the presence of a valid proxy host and port").a(Category.PROXY_SETTINGS).a(com.contrastsecurity.agent.config.a.a("api.proxy.enable", Lists.of("contrast.proxy.enable"))).f()),
    PROXY_URL(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.proxy.url").a().b("Proxy url, e.g. https://host:port. This value should be set in place of scheme, host, and port settings. If both this and one of the others are set, a ContrastConfigurationException will be thrown").a(Category.PROXY_SETTINGS).a(com.contrastsecurity.agent.config.a.a("api.proxy.url", Lists.of("contrast.proxy.url"))).f()),
    PROXY_PROTOCOL(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.proxy.protocol").a().b("Proxy protocol, e.g. http, https").a(Category.PROXY_SETTINGS).a(com.contrastsecurity.agent.config.a.a("api.proxy.scheme", Lists.of("contrast.proxy.scheme"))).f()),
    PROXY_AUTH(com.contrastsecurity.agent.config.b.a(String.class).a().b("Override authentication type for Proxy").a(Category.PROXY_SETTINGS).a(com.contrastsecurity.agent.config.a.a("api.proxy.auth_type", Lists.of("contrast.proxy.auth_type"))).f()),
    PROXY_HOST(com.contrastsecurity.agent.config.b.a(String.class).a().b("Override Host for Proxy").a(Category.PROXY_SETTINGS).a(com.contrastsecurity.agent.config.a.a("api.proxy.host", Lists.of("contrast.proxy.host"))).f()),
    PROXY_PORT(com.contrastsecurity.agent.config.b.a(Integer.class).a(0).b("Override Port for Proxy. Defaults to 0, an invalid port number.").a(Category.PROXY_SETTINGS).a(com.contrastsecurity.agent.config.a.a("api.proxy.port", Lists.of("contrast.proxy.port"))).f()),
    PROXY_USER(com.contrastsecurity.agent.config.b.a(String.class).a().b("Override User for Proxy").a(Category.PROXY_SETTINGS).a(com.contrastsecurity.agent.config.a.a("api.proxy.user", Lists.of("contrast.proxy.user"))).f()),
    PROXY_PASSWORD(com.contrastsecurity.agent.config.b.a(String.class).a().b("Override Password for Proxy").a(Category.PROXY_SETTINGS).d().a(com.contrastsecurity.agent.config.a.a("api.proxy.pass", Lists.of("contrast.proxy.pass"))).f()),
    ACTIVITY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.activity")).a(true).b("boolean to enable/disable the Contrast activity thread").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_activity_thread")).f()),
    APP_ACTIVITY_PERIOD_MS(com.contrastsecurity.agent.config.b.a(Long.class).a((Long)((Object)"contrast.app.activity.period")).a(30000L).b("Contrast app activity thread polling period in milliseconds. 30000 (30  seconds, in milliseconds)").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.polling.app_activity_ms")).f()),
    STALE_APP_ACTIVITY_UPDATE_MS(com.contrastsecurity.agent.config.b.a(Long.class).a((Long)((Object)"contrast.stale.app.activity.update.ms")).a(TimeUnit.MINUTES.toMillis(5L)).b("The maximum amount of time to wait before requesting new \"application settings\" from TeamServer. Typically, the agent receives new settings each time it sends activity, but if there is no activity the agent will wait this long before requesting new settings. Defaults to " + TimeUnit.MINUTES.toMillis(5L) + " (5 minutes, in milliseconds)").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.polling.app_activity_stale_ms")).f()),
    APPUPDATE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.appupdate")).a(true).b("boolean to enable/disable threads that sends updates about applications to Team Server").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("application.enable_app_updates")).f()),
    APP_UPDATE_PERIOD(com.contrastsecurity.agent.config.b.a(Long.class).a((Long)((Object)"contrast.app.update.period")).a(5000L).b("Contrast app update thread polling period in milliseconds").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.polling.app_update_ms")).f()),
    APP_UPDATE_STALE_THRESHOLD(com.contrastsecurity.agent.config.b.a(Long.class).a((Long)((Object)"contrast.app.update.threshold")).a(1800000L).c().b("Even when no appupdate is warranted on client side, ask TeamServer via preflight if needed on this frequency. 30 mins, in milliseconds.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.polling.app_update_stale_threshold_ms")).f()),
    APP_FEATURES(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.app.features").a().b("JSON from disk to use for app").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("application.app_features_file")).f()),
    DENYLIST_PATH(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.blacklist").a().b("The path to the file that lists classes currently on the denylist.  Classes listed here will be ignored by the agent.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.blacklist")).f()),
    PACKAGE_DENYLIST_PATH(com.contrastsecurity.agent.config.b.a(String.class).a().c().b("The path to the file that lists packages currently on the denylist.  Classes with packages matching the prefixes listed will be ignore by the agent.  Packages should match the format \"com/example/\", without quotes.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.package_denylist")).f()),
    CLONEINPUT(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.cloneinput")).a(true).b("boolean to enable/disable cloning of tracked objects").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_input_cloning")).f()),
    DEEP_CLONEINPUT(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.deepclone")).a(true).b("boolean to enable/disable cloning of leaf nodes in object graphs of deserialized objects").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_deep_cloning")).f()),
    DEEP_TAINTKEYS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.deep.mapkeys")).a(false).b("boolean to enable/disable tainting of keys in maps of deserialized objects").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.taint_map_key")).f()),
    DESERIALIZER_MAX_DEPTH(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.deserializer.maxdepth")).a(10).c().b("The max depth to traverse and analyze deserialized objects in Protect. Set to 0 to disable deserialized object analysis.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.protect_deserialization_analysis_traversal_depth")).f()),
    SERVER_TYPE(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.container").a().b("manually override the web app server type").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("server.type")).f()),
    WORKING_DIR(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.dir").a().b("This value can override the default location of the Contrast working directory. Defaults to ${HOME}/.contrast of the user account the application runs under.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.contrast_working_dir")).f()),
    SERVER_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a().b("comma separated list of tags to be sent with each server update and create").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("server.tags")).f()),
    APPLICATION_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a().b("comma separated list of tags to be sent with each application message").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("application.tags", true)).f()),
    INVENTORY_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a().b("comma separated list of tags to be sent with each inventory message").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("inventory.tags", true)).f()),
    ASSESS_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a().b("comma separated list of tags to be sent with each assess message").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("assess.tags", true)).f()),
    HTTP_ANALYSIS_PARAMETERS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.http.analysis.parameters")).a(true).b("boolean to enable/disable analysis of HTTP parameters").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_http_parameter_analysis")).f()),
    DBINSPECTION(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.dbinspection")).a(true).b("boolean to enable/disable DB inspection when analyzing application architecture").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("inventory.inspect_database")).f()),
    INVENTORY_MONITOR_LDAP(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.monitorldap")).a(true).b("boolean to enable/disable LDAP call counting and analysis").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("inventory.inspect_ldap")).f()),
    INVENTORY_MONITOR_WEB_CALL(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.monitorwebcalls")).a(true).b("boolean to enable/disable web call counting and analysis, web calls being the HTTP requests made to this application").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("inventory.inspect_web_calls")).f()),
    ENABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.enabled")).a(true).b("Determines whether Contrast will monitor the JVM. You can use this feature to quickly turn Contrast on or off without removing the *-javaagent* flag.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("enable", Lists.of("contrast.enable"))).f()),
    LAST_CONFIG_PATH(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.last_config_path").a().b("The file to which the last configuration from TeamServer should be loaded or reloaded.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("api.last_config_path", Lists.of("contrast.last_config_path"))).f()),
    FEATUREJSON(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.featureJSON").a().c().b("location of features JSON").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.features_file_override")).f()),
    IDENTITYTAGS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.identitytags")).a(true).b("boolean to enable/disable identity tags").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.enable_identity_tagging")).f()),
    JFR(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("boolean to enable/disable JFR event emitting").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jfr_events")).f()),
    JMX(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.jmx")).a(false).c().b("boolean to enable/disable jmx support").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_jmx_support")).f()),
    J2EE_CLASSCACHE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.j2ee.classcache")).a(true).b("boolean to enable/disable caching of instrumented classes").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_j2ee_class_cache")).f()),
    J2EE_CONTEXT_DISCOVERY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.j2ee.context.discovery")).a(true).c().b("boolean to enable/disable J2EE context discovery").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.j2ee_context_discovery")).f()),
    MODE(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.mode").b().a().c().b("Valid values: assess/defend/inventory/observe/all. assess: data flow analysis, defend: defend features, inventory: library catalog and analysis, observe: security observability, all: all features; Note when this property is enabled, the Agent will ignore all customizations from TeamServer.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.mode")).f()),
    ASSESS_ENABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.assess.enabled")).a(false).b("If present, used to determine if the Assess feature should be enabled. If not present, decision delegated to Contrast UI").a(Category.GENERAL_PROPERTIES).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null) {
            return serverSettingsDTM.getAssess().getEnable();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("assess.enable")).f()),
    INVENTORY_ENABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.inventory.enabled")).a(true).b("Used to determine if the Inventory feature should be enabled. Inventory encompasses several facets of application analysis including library detection and usage, HTTP call counting and database usage analysis").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("inventory.enable")).f()),
    NOTEAMSERVER_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.noteamserver.enable")).a(false).c().b("boolean to enable/disable Contrast to start up without access to TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_disconnected_startup")).f()),
    SERVER_PATH(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.path").a().b("Contrast \"working directory\" override. Defaults to CWD.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("server.path")).f()),
    AGENT_UUID(com.contrastsecurity.agent.config.b.a(String.class).a(UUID.randomUUID().toString()).c().b("The unique identifier for the current agent. Defaults to a new UUID if none is provided.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.uuid")).f()),
    AGENT_VERSION_OVERRIDE(com.contrastsecurity.agent.config.b.a(String.class).a().c().b("Overrides reported agent version, used for internal testing only and should not be used in production").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.version")).f()),
    STACKTRACE_CAPTURE(com.contrastsecurity.agent.config.b.a(String.class).a(ServerSettingsAssessDTM.ReportStacktracesEnum.ALL.toString()).b("This property can be set to ALL, SOME, SINK, or NONE and controls the amount of stack traces captured by the agent to be sent in vulnerability events.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.stacktraces")).c().a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getReportStacktraces() != null) {
            return serverSettingsDTM.getAssess().getReportStacktraces().toString();
        }
        return null;
    }).f()),
    EVENT_DETAIL(com.contrastsecurity.agent.config.b.a(String.class).a(ServerSettingsAssessDTM.EventDetailEnum.FULL.toString()).b("Control the values captured by Assess vulnerability events. `FULL` captures most values by calling ToString on objects, which can provide more info but causes increased memory usage. `MINIMAL` has better performance as it only captures String type objects as strings and uses type name for other object type values. `SINK` captures values as `FULL` but only at the sink, for other events it functions as `OFF`. `OFF` captures type name and id only for all objects.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.event_detail")).f()),
    ROOTAPP(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.rootapp").a().b("This value can override (or provide one if none exist) a display name for the app running at the root context. This may be needed for Contrast to collect analytics on the application.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.root_app_name")).f()),
    ASSESS_SAMPLING_ENABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.sampling.enabled")).a(false).b("Enable sampling mode").a(Category.PERFORMANCE).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getSampling() != null) {
            return serverSettingsDTM.getAssess().getSampling().isEnabled();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("assess.sampling.enable")).f()),
    ASSESS_SAMPLING_BASELINE(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.sampling.baseline")).a(5).b("indicates how many requests to analyze in each window before sampling begins").a(Category.PERFORMANCE).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getSampling() != null) {
            Integer n2 = serverSettingsDTM.getAssess().getSampling().getBaseline();
            return ConfigProperty.isPositive(n2) ? n2 : null;
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("assess.sampling.baseline")).f()),
    ASSESS_SAMPLING_REQ_FREQUENCY(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.sampling.request_frequency")).a(10).b("indicates every nth request (after baseline) will be analyzed").a(Category.PERFORMANCE).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getSampling() != null) {
            Integer n2 = serverSettingsDTM.getAssess().getSampling().getRequestFrequency();
            return ConfigProperty.isPositive(n2) ? n2 : null;
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("assess.sampling.request_frequency")).f()),
    ASSESS_SAMPLING_WINDOW_MS(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.sampling.window_ms")).a(180000).b("indicates duration for which a sample set is valid, in ms").a(Category.PERFORMANCE).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getSampling() != null) {
            Integer n2 = serverSettingsDTM.getAssess().getSampling().getWindow();
            return ConfigProperty.isPositive(n2) ? Integer.valueOf(n2 * 1000) : null;
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("assess.sampling.window_ms")).f()),
    SAMPLING_PURGE_WINDOW_MS(com.contrastsecurity.agent.config.b.a(Long.class).a(10800000L).b("Duration, in ms, until sampling request history map is purged. Default set to 3 hours.").c().a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.sampling.purge.window_ms")).f()),
    FEATURE_REQUEST_SAMPLING_ENABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).b("Set to false to disable features that use feature request sampling.").a(Category.INTERNAL_USAGE).c().a(com.contrastsecurity.agent.config.a.a("agent.java.feature_request_sampling_enabled")).f()),
    FEATURE_REQUEST_SAMPLING_FREQUENCY(com.contrastsecurity.agent.config.b.a(Integer.class).a(10000).b("").a(Category.INTERNAL_USAGE).c().a(com.contrastsecurity.agent.config.a.a("agent.java.feature_request_sampling_frequency")).f()),
    SAVEBYTECODE(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.savebytecode").a().b("Output location of the saved *before/after bytecode* of classes where sensors have been added.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.save_bytecode")).f()),
    SAVERESULTS(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.saveresults").a("" + (Object)((Object)SaveReportMode.Never)).b("controls when Contrast findings are saved locally").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("assess.save_results")).f()),
    LOCAL_RESULTS_DIR(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.local.results.dir").a().b("controls where Contrast findings are saved locally").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("assess.local_results_dir")).f()),
    JARVERIFIER_OVERRIDE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.scoped.jarverifier")).a(false).b("controls whether the JarInputStream verifier is disabled during our scoped operations").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.override_scoped_jar_verifier")).f()),
    SCANRESPONSES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.scanresponses")).a(true).b("boolean to enable/disable scanning of HTTP responses -- override for assess and protect").a(Category.GENERAL_PROPERTIES).d("CONTRAST-30445").f()),
    SCAN_ASSESS_RESPONSES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.assess.scanresponses")).a(true).b("boolean to enable/disable scanning of HTTP responses -- assess only").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("assess.enable_scan_response")).f()),
    SERVER_NAME(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.server").a().b("Overrides name of the server displayed in the Contrast TeamServer. Includes any valid path characters, e.g. *myserver-1/myapp* or *john_dev*.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("server.name")).f()),
    SERVER_ACTIVITY_PERIOD(com.contrastsecurity.agent.config.b.a(Long.class).a((Long)((Object)"contrast.server.activity.period")).a(30000L).b("Polling period for TeamServer polling thread 30000 (30  seconds in milliseconds)").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.polling.server_activity_ms")).f()),
    STALE_SERVER_ACTIVITY_UPDATE_MS(com.contrastsecurity.agent.config.b.a(Long.class).a((Long)((Object)"contrast.stale.server.activity.update.ms")).a(300000L).b("The maximum amount of time to wait before requesting new \"server settings\" from TeamServer. Typically, the agent receives new settings each time it sends activity, but if there is no activity the agent will wait this long before requesting new settings. (5 minutes, in milliseconds)").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.polling.server_activity_stale_ms")).f()),
    STACKS_MAXDEPTH(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.stacks.maxdepth")).a(75).b("max stack depth to include in reported findings, minimum of 2").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.max_stack_depth")).f()),
    TELEMETRY_DIR(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.telemetry.dir").a().b("Location for Contrast telemetry output").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.telemetry_directory")).f()),
    USECONFIG(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.useconfig").a().b("use the contrast.config file packaged in another contrast.jar").a(Category.GENERAL_PROPERTIES).d("TODO: wait what? seriously?").f()),
    LOGGER_ENABLE_INTERNAL_LOGGER_DEBUGGING(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("When set to true, enables the logger's internal debug information to be printed to stderr (or stdout if we are already logging to stderr).").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.logger.enable_internal_logger_debugging")).f()),
    LOGGER_STDOUT(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.stdout")).a(false).b("When set to true, all logs will be written to stdout instead of the file system.  May be combined with the corresponding stderr configuration to write to both streams.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.logger.stdout")).f()),
    LOGGER_STDERR(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.stderr")).a(false).b("When set to true, all logs will be written to stderr instead of the file system. May be combined with the corresponding stdout configuration to write to both streams.").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.logger.stderr")).f()),
    SUPPRESS_STDOUT(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.stdout.quiet")).a(false).b("When set to true, all normal stdout messages will be suppressed -- has no effects on file or syslog logging").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("agent.java.logger.suppress_stdout")).f()),
    SECURITY_LOGGER_LEVEL(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.security.log.level").a(LoggingConstants.DEFAULT_LOGGER_LEVEL.toString()).b("Set the log level for security logging. Values include: trace, debug, info, warn, error, fatal, off. Setting this to off will disable security logging.").a(Category.LOGGING_PROTECT).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.level")).f()),
    LOGGER_LEVEL(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.level").a(LoggingConstants.DEFAULT_LOGGER_LEVEL.toString()).b("Log output level").a(Category.LOGGING_ASSESS).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getLogger() != null) {
            LogLevel logLevel = serverSettingsDTM.getLogger().getLevel();
            return logLevel == null ? null : logLevel.name();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("agent.logger.level")).f()),
    SECURITY_LOGGER_FILE(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.security.log.file").a("security.log").b("The file to which logging of security events will occur. By default, this file is located at ${HOME}/.contrast/security.log.").a(Category.LOGGING_PROTECT).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.path")).f()),
    LOGGER_LOCATION(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.log").a("contrast.log").b("Enable *diagnostic logging*. This hurts performance, but generates useful information for debugging Contrast. The value set here will be the location to which log output is saved. If no log file exists at this location, one will be created. For instance, */opt/Contrast/contrast.log* will create a log in the */opt/Contrast* directory and rotate it automatically as needed. By default, this file is located at ${HOME}/.contrast/contrast.log").a(Category.LOGGING_ASSESS).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getLogger() != null) {
            return serverSettingsDTM.getLogger().getPath();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("agent.logger.path")).f()),
    SECURITY_LOGGER_DAILY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.security.log.daily")).a(false).b("Change the Contrast security logger from a file sized based rolling scheme to a date based rolling scheme. At midnight server time, the previous day's log will be renamed to file_name.yyyy-MM-dd. Note, this scheme does not have a size limit, so manual log pruning will be required. This flag must be set to use the backups and size flags.").a(Category.LOGGING_PROTECT).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.roll_daily")).f()),
    LOGGER_DAILY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.log.daily")).a(false).b("Change the Contrast logger from a file sized based rolling scheme to a date based rolling scheme. At midnight server time, the previous day's log will be renamed to file_name.yyyy-MM-dd. Note, this scheme does not have a size limit, so manual log pruning will be required. This flag must be set to use the backups and size flags.").a(Category.LOGGING_ASSESS).a(com.contrastsecurity.agent.config.a.a("agent.logger.roll_daily")).f()),
    SECURITY_LOGGER_BACKUPS(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.security.log.backups")).a(10).b("Specify the number of \"backup\" logs that will be created before Contrast will clean up the oldest file. This value has a cap of 100, meaning no more than 100 log files can be stored on the file system at one time. A value of 0 here means that no backups will be created and the log will simply be truncated when it reaches its size cap. Note: This property must be used with contrast.security.log.daily=false, or we will continue to log daily and disregard this limit.").a(Category.LOGGING_PROTECT).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.backups")).f()),
    LOGGER_BACKUPS(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.log.backups")).a(10).b("Specify the number of \"backup\" logs that will be created before Contrast will clean up the oldest file. This value has a cap of 100, meaning no more than 100 log files can be stored on the file system at one time. A value of 0 here means that no backups will be created and the log will simply be truncated when it reaches its size cap. Note: This property must be used with contrast.log.daily=false, or we will continue to log daily and disregard this limit.").a(Category.LOGGING_ASSESS).a(com.contrastsecurity.agent.config.a.a("agent.logger.backups")).f()),
    SECURITY_LOGGER_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.security.log.size")).a(100).b("Specify the file size cap, in MB, of each log file. By default, this value is \"100\". Note: This property must be used with contrast.log.daily=false, or we will continue to log daily and disregard this limit.").a(Category.LOGGING_PROTECT).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.roll_size")).f()),
    SECURITY_LOGGER_BUFFER_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(-1).c().b("Specify the Security logger buffer size cap. Must be a power of 2. The default is 128. Log messages are dropped if the buffer exceeds the size.").a(Category.LOGGING_PROTECT).a(com.contrastsecurity.agent.config.a.a("agent.java.security_logger.buffer_size")).f()),
    LOGGER_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.log.size")).a(100).b("Specify the file size cap, in MB, of each log file. By default, this value is \"100\". Note: This property must be used with contrast.log.daily=false, or we will continue to log daily and disregard this limit.").a(Category.LOGGING_ASSESS).a(com.contrastsecurity.agent.config.a.a("agent.logger.roll_size")).f()),
    LOGGER_BUFFER_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(-1).c().b("Specify the Contrast logger buffer size cap. Must be a power of 2. The default is 128. The default if the agent is in DEBUG mode or higher is 16384. Log messages are dropped if the buffer exceeds the size.").a(Category.LOGGING_ASSESS).a(com.contrastsecurity.agent.config.a.a("agent.java.logger.buffer_size")).f()),
    LOGGER_SHUTDOWN_TIMEOUT(com.contrastsecurity.agent.config.b.a(Long.class).a(10000L).c().b("LoggerManager shutdown timeout in seconds.").a(Category.LOGGING_ASSESS).a(com.contrastsecurity.agent.config.a.a("agent.java.logger.shutdown_timeout_ms")).f()),
    CEF_SYSLOGGER_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).b("flag for controlling the use of Syslog").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().isSyslogEnabled();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.syslog.enable")).f()),
    CEF_SYSLOGGER_SERVER_INFO_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("flag to enable logging server and hostname as key value pairs in syslog.").a(Category.LOGGING_PROTECT).a(com.contrastsecurity.agent.config.a.a("agent.java.security_logger.syslog.enable_server_info")).f()),
    CEF_SYSLOGGER_BUFFER_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(-1).c().b("Specify the Syslog logger buffer size cap. Must be a power of 2. The default is 128. Log messages are dropped if the buffer exceeds the size.").a(Category.LOGGING_PROTECT).a(com.contrastsecurity.agent.config.a.a("agent.java.security_logger.syslog.buffer_size")).f()),
    CEF_SYSLOGGER_HOST_NEW(com.contrastsecurity.agent.config.b.a(String.class).a("").c().b("Set the address of the Syslog server to which the agent should send messages.  This can be a fully qualified domain name or ip address; e.g. syslog.hostname.com or 10.10.10.13").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogIpAddress();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.syslog.server_host", false)).f()),
    CEF_SYSLOGGER_HOST(com.contrastsecurity.agent.config.b.a(String.class).a("localhost").b("Set the address of the Syslog server to which the agent should send messages.  This can be a fully qualified domain name or ip address; e.g. syslog.hostname.com or 10.10.10.13").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogIpAddress();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.syslog.ip")).f()),
    CEF_SYSLOGGER_PROTOCOL(com.contrastsecurity.agent.config.b.a(String.class).a("").c().b("Specify the connection protocol used for the Syslog server connection.  Value options are 'UDP' (default), 'TCP', or 'TCP_TLS'.  Default if missing is UDP.").a(Category.LOGGING_PROTECT).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.syslog.protocol")).f()),
    CEF_SYSLOGGER_PORT(com.contrastsecurity.agent.config.b.a(Integer.class).a(514).b("The port of the Syslog server to which we should send messages").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogPortNumber();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.syslog.port")).f()),
    CEF_SYSLOGGER_FACILITY(com.contrastsecurity.agent.config.b.a(Integer.class).a(19).b("The facility code of the messages we are sending to Syslog").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogFacilityCode();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.syslog.facility")).f()),
    CEF_SYSLOGGER_HEARTBEAT(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).b("Set to `true` to enable the Syslog heartbeat.  The heartbeat will issue a Syslog message every after every interval passes.").a(Category.LOGGING_PROTECT).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.syslog.heartbeat.enable")).f()),
    CEF_SYSLOGGER_HEARTBEAT_INTERVAL(com.contrastsecurity.agent.config.b.a(Integer.class).a(60000).b("Set the interval of the Syslog server of which to send heartbeat messages to the Syslog server. (in milliseconds)").a(Category.LOGGING_PROTECT).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.syslog.heartbeat.interval_ms")).f()),
    CEF_SYSLOGGER_EXPLOITED_LEVEL(com.contrastsecurity.agent.config.b.a(String.class).a("ALERT").b("Set the log level of Exploited attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            SyslogSeverity syslogSeverity = serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogSeverityExploited();
            return syslogSeverity == null ? null : syslogSeverity.name();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.syslog.severity_exploited")).f()),
    CEF_SYSLOGGER_SUSPICIOUS_LEVEL(com.contrastsecurity.agent.config.b.a(String.class).a("WARNING").c().b("Set the log level of Suspicious attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.").a(Category.LOGGING_PROTECT).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.syslog.severity_suspicious")).f()),
    CEF_SYSLOGGER_BLOCKED_LEVEL(com.contrastsecurity.agent.config.b.a(String.class).a("NOTICE").b("Set the log level of Blocked attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            SyslogSeverity syslogSeverity = serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogSeverityBlocked();
            return syslogSeverity == null ? null : syslogSeverity.name();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.syslog.severity_blocked")).f()),
    CEF_SYSLOGGER_PROBED_LEVEL(com.contrastsecurity.agent.config.b.a(String.class).a("WARNING").b("Set the log level of Probed attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            SyslogSeverity syslogSeverity = serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogSeverityProbed();
            return syslogSeverity == null ? null : syslogSeverity.name();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("agent.security_logger.syslog.severity_probed")).f()),
    OBJECT_CACHE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("Determines if the agent will always store a reference to an object when possible. To utilize the legacy approach set this to false.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.object_cache")).f()),
    OBSERVE_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).b("Lightweight and low overhead observation mode for the agent.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("observe.enable")).f()),
    OBSERVE_DISTRIBUTED_TRACING(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("Determines if the agent should use Distributed Tracing, which attaches custom headers to outgoing HTTP requests for cross service tracing in Observe.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("observe.distributed_tracing.enable", Lists.of("observe.enable_distributed_tracing"))).f()),
    OBSERVE_METRICS_ENDPOINT(com.contrastsecurity.agent.config.b.a(String.class).a().b("The URL for exporting OpenTelemetry metrics collected by Observe").a(Category.GENERAL_PROPERTIES).c().a(com.contrastsecurity.agent.config.a.a("agent.java.observe_metrics_endpoint")).f()),
    OBSERVE_TRACING_ENDPOINT(com.contrastsecurity.agent.config.b.a(String.class).a().b("The URL for exporting OpenTelemetry traces collected by Observe").a(Category.GENERAL_PROPERTIES).c().a(com.contrastsecurity.agent.config.a.a("agent.java.observe_tracing_endpoint")).f()),
    OBSERVE_LOG_RECORD_ENDPOINT(com.contrastsecurity.agent.config.b.a(String.class).a().b("The URL for exporting OpenTelemetry LogRecords collected by Observe").a(Category.GENERAL_PROPERTIES).c().a(com.contrastsecurity.agent.config.a.a("agent.java.observe_logger_endpoint")).f()),
    OBSERVE_TRACING_SAMPLING_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).b("Controls whether to turn on sampling for Observe. Defaults to enabled.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("observe.sampling.enable")).f()),
    OBSERVE_TRACING_SAMPLING_INTERVAL(com.contrastsecurity.agent.config.b.a(Long.class).a(300000L).b("The sampling interval. Traces are sampled once per route in a given sampling interval").a(Category.GENERAL_PROPERTIES).c().a(com.contrastsecurity.agent.config.a.a("observe.sampling.trace_intervale_ms", Lists.of("agent.java.observe_tracing_sampling_interval_ms"))).f()),
    OBSERVE_SENSOR_DEDUPLICATION_MAX(com.contrastsecurity.agent.config.b.a(Integer.class).a(1).b("The number of times a sensor can trigger per request, when sensor deduplication is enabled. When sensor deduplication is disabled, this setting has no effect.").a(Category.GENERAL_PROPERTIES).c().a(com.contrastsecurity.agent.config.a.a("agent.java.observe_sensor_deduplication_max")).f()),
    OBSERVE_METRICS_EXPORT_INTERVAL(com.contrastsecurity.agent.config.b.a(Long.class).a(300000L).b("The interval in ms at which metrics are exported to the collector.").a(Category.GENERAL_PROPERTIES).c().a(com.contrastsecurity.agent.config.a.a("agent.java.observe_metrics_export_interval_ms")).f()),
    OBSERVE_CRYPTO_USAGE_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Controls whether to turn on Quantum Unsafe Cryptographic usage observations for Observe. Defaults to disabled.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("observe.crypto_usage.enable")).f()),
    PROTECT_SQL_CANARY(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.defend.sql.canary").a().c().b("In order to get diagnostics about how the SQL is being analyzed for protect purposes, you can log queries that contain the canary specified by this setting.").a(Category.LOGGING_PROTECT).a(com.contrastsecurity.agent.config.a.a("protect.sql_canary")).f()),
    PROTECT_BEAN_INTROSPECTION_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2010-1622.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.BEAN_INTROSPECTION)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2010-1622.mode")).f()),
    PROTECT_CLASS_LOADER_MANIPULATION_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CLASSLOADER_MANIPULATION)).a(com.contrastsecurity.agent.config.a.a("protect.rules.class-loader-manipulation.mode")).f()),
    PROTECT_CMDI_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cmd-injection.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CMD_INJECTION)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cmd-injection.mode")).f()),
    PROTECT_CMDI_BACKDOORS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.cmdinjection.backdoors")).a(true).b("Detect when the agent sees user parameters being executed as system commands. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.cmd-injection.detect_parameter_command_backdoors")).f()),
    PROTECT_CMDI_CHAINS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.cmdinjection.chaining")).a(true).b("Detect when a system command is issued which contains chained commands. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.cmd-injection.detect_chained_commands")).f()),
    PROTECT_CMDI_DANGEROUS_PATH_ARGS(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).b("Detect when a system command is issued which contains a dangerous path argument - e.g. /etc/passwd. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.cmd-injection.detect_dangerous_path_args")).f()),
    PROTECT_CMDI_PHASES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.cmdinjection.phases")).a(true).c().b("controls whether phased commands queries will be blocked").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.cmd-injection.detect_phased_commands")).f()),
    PROTECT_CVE_2011_2730_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2011-2730.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2011_2730)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2011-2730.mode")).f()),
    PROTECT_CVE_2011_2732_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2011-2732.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.SPRING_HEADER_INJECTION)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2011-2732.mode")).f()),
    PROTECT_CVE_2014_0112_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2014-0112.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2014_0112)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2014-0112.mode")).f()),
    PROTECT_CVE_2014_0114_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2014-0114.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2014_0114)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2014-0114.mode")).f()),
    PROTECT_CVE_2014_0116_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2014-0116.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2014_0116)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2014-0116.mode")).f()),
    PROTECT_CVE_2017_5638_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2017-5638.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2017_5638)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2017-5638.mode")).f()),
    PROTECT_CVE_2017_9791_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2017-9791.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2017_9791)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2017-9791.mode")).f()),
    PROTECT_CVE_2017_12616_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2017-12616.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2017_12616)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2017-12616.mode")).f()),
    PROTECT_CVE_2017_12617_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2017-12617.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2017_12617)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2017-12617.mode")).f()),
    PROTECT_CVE_2016_4438_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2016-4438.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.DEFAULT_ACTION_INVOCATION)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2016-4438.mode")).f()),
    PROTECT_CVE_2016_3081_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2016-3081.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.DEFAULT_ACTION_MAPPER)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2016-3081.mode")).f()),
    PROTECT_EL_INJECTION_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.expression-language-injection.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.EL_INJECTION)).a(com.contrastsecurity.agent.config.a.a("protect.rules.expression-language-injection.mode")).f()),
    PROTECT_METHOD_TAMPERING_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.method-tampering.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.HTTP_METHOD_TAMPERING)).a(com.contrastsecurity.agent.config.a.a("protect.rules.method-tampering.mode")).f()),
    PROTECT_METRIC_GATHERING_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.MONITOR).b("if present, controls the mode of the metric gathering synthetic rule; can be monitor or off (default: monitor). If at any point the telemetry system is disabled then the metric gathering rule will be as well, regardless of the value of this property.").a(Category.INTERNAL_USAGE).c().a(com.contrastsecurity.agent.config.a.a("protect.rules.metric-gathering.mode")).f()),
    PROTECT_OGNL_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.ognl-injection.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.OGNL_INJECTION)).a(com.contrastsecurity.agent.config.a.a("protect.rules.ognl-injection.mode")).f()),
    PROTECT_PATH_TRAVERSAL_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.path-traversal.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.PATH_TRAVERSAL)).a(com.contrastsecurity.agent.config.a.a("protect.rules.path-traversal.mode")).f()),
    PROTECT_PT_CUSTOM_CODE_ACCESS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.pathtraversal.detect_custom_code_accessing_system_files")).a(true).b("Detect when custom code attempts to access sensitive system files. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.path-traversal.detect_custom_code_accessing_system_files")).f()),
    PROTECT_PT_COMMON_EXPLOIT(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.pathtraversal.detect_common_file_exploits")).a(true).b("Detect when users attempt to bypass filters by using \"::$DATA\" channels or null bytes in file names. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.path-traversal.detect_common_file_exploits")).f()),
    PROTECT_PROCESS_HARDENING_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.PROCESS_HARDENING)).a(com.contrastsecurity.agent.config.a.a("protect.rules.process-hardening.mode")).f()),
    PROTECT_CODE_INJECTION_HARDENING_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.OFF).c().b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CODE_INJECTION_HARDENING)).a(com.contrastsecurity.agent.config.a.a("protect.rules.code-injection-hardening.mode")).f()),
    PROTECT_SIGNATURE_TAMPERING_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.SIGNATURE_TAMPERING)).a(com.contrastsecurity.agent.config.a.a("protect.rules.signature-tampering.mode")).f()),
    PROTECT_SQLI_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.sql-injection.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.SQL_INJECTION)).a(com.contrastsecurity.agent.config.a.a("protect.rules.sql-injection.mode")).f()),
    PROTECT_SQL_SEMANTIC_UNIONS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.suspiciousunions")).a(false).b("Tell the agent to detect when semantic analysis of the query reveals database queries are being made for system tables and sensitive information. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.sql-injection.detect_suspicious_unions")).f()),
    PROTECT_SQL_SEMANTIC_TAUTOLOGIES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.tautologies")).a(false).b("Tell the agent to detect when semantic analysis of the query reveals tautologies used in exfiltration attacks (e.g., \"or 1=1\" or \"or 2<>3\"). The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.sql-injection.detect_tautologies")).f()),
    PROTECT_SQL_SEMANTIC_CHAINING(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.chaining")).a(false).b("Tell the agent to detect when semantic analysis of the query reveals chained queries, which is uncommon in normal usage but common in exploit. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.sql-injection.detect_chained_queries")).f()),
    PROTECT_SQL_AGGRESSIVE_COMMENT(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.aggressive_comment")).a(false).b("controls whether aggressive comment filtering is used to block").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.sql-injection.aggressive_comment")).f()),
    PROTECT_SQL_SEMANTIC_DANGEROUS_FUNCTIONS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.dangerous_functions")).a(false).b("Tell the agent to detect when semantic analysis of the query reveals the invocation of dangerous functions typically used in weaponized exploits. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.sql-injection.detect_dangerous_functions")).f()),
    PROTECT_SQL_SEMANTIC_FINDING_CACHE_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.semantic_findings_cache_size")).a(300).b("Set the number of queries for which semantic analysis findings are cached. Set to 0 to disable caching").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("agent.java.semantic_findings_cache_size")).f()),
    PROTECT_CVE_2013_2251_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2013-2251.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.STRUTS2_CVE_2013_2251)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2013-2251.mode")).f()),
    PROTECT_CVE_2021_44228_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2021-44228.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2021_44228)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2021-44228.mode")).f()),
    PROTECT_CVE_2022_41852_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.OFF).b("Set the rule mode. Valid values are `monitor`, `block`, or `off`.\nUse `monitor` to report attacks but not block them, or `block` to block attacks, and `off` to disable the rule's analysis entirely.\nPlease refer to https://docs.contrastsecurity.com/en/set-protect-rules.html to learn more about the different rule modes.").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.CVE_2022_41852)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2022-41852.mode")).f()),
    PROTECT_DESERIALIZATION_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.untrusted-deserialization.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.UNTRUSTED_DESERIALIZATION)).a(com.contrastsecurity.agent.config.a.a("protect.rules.untrusted-deserialization.mode")).f()),
    PROTECT_XSLT_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.cve-2016-3082.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.XSLT_RESULT)).a(com.contrastsecurity.agent.config.a.a("protect.rules.cve-2016-3082.mode")).f()),
    PROTECT_XSS_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.reflected-xss.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.XSS)).a(com.contrastsecurity.agent.config.a.a("protect.rules.reflected-xss.mode")).f()),
    PROTECT_XXE_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.xxe.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.XXE)).a(com.contrastsecurity.agent.config.a.a("protect.rules.xxe.mode")).f()),
    PROTECT_UNSAFE_FILE_UPLOAD_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.unsafe-file-upload.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.UNSAFE_FILE_UPLOAD)).a(com.contrastsecurity.agent.config.a.a("protect.rules.unsafe-file-upload.mode")).f()),
    UNSAFE_FILE_UPLOAD_THRESHOLD_DISABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.unsafe-file-upload.threshold")).a(false).c().b("boolean to enable/disable the threshold after which an input is no longer checked against possible attack patterns").a(Category.PROTECT_MODE_CONFIG).d("We don't need to make this available to users").f()),
    PROTECT_ZFO_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.zip-file-overwrite.mode")).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.ZIP_FILE_OVERWRITE)).a(com.contrastsecurity.agent.config.a.a("protect.rules.zip-file-overwrite.mode")).f()),
    PROTECT_JNDI_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a(CommonConfigProtectionMode.OFF).b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new b(ProtectRuleId.JNDI_INJECTION)).a(com.contrastsecurity.agent.config.a.a("protect.rules.jndi-injection.mode")).f()),
    PROTECT_RULE_MODE_OVERRIDE(com.contrastsecurity.agent.config.b.a(ProtectionModeDTM.class).a((ProtectionModeDTM)((Object)"contrast.defend.rulemode")).a().c().b("Valid values: off, blocking, monitoring. An override setting for whether protection rules should all be in off, monitoring or blocking modes").a(Category.PROTECT_MODE_CONFIG).d("JAVA-212").f()),
    POLICY(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.policy").a().b("If you set this value to a file or URL, Contrast will use it in addition to the pre-packaged security policy. This means that rules from both the standard Contrast policy and your custom policy will be used, with conflicts being resolved in favor of the external policy, i.e. if two sources have the same ID, one in the internal policy and one in the external, the external source will be used.").a(Category.POLICY).a(com.contrastsecurity.agent.config.a.a("agent.java.external_policy_files")).f()),
    POLICY_OVERRIDES(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.policy.overrides").a().b("Same functionality as contrast.policy, but policies listed here have a higher priority, meaning that conflicts will be resolved in favor of the overrides policy, i.e. if two sources have the same ID, one in the policy and one in the override, the override source will be used. ").a(Category.POLICY).a(com.contrastsecurity.agent.config.a.a("agent.java.external_policy_overrides")).f()),
    POLICY_STANDALONE(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.policy.standalone").a().b("If you set this value to a file or URL, Contrast will use it instead of the pre-packaged security policy. For more information about rule customization, please contact your account manager.").a(Category.POLICY).a(com.contrastsecurity.agent.config.a.a("agent.java.standalone_policy")).f()),
    POLICY_CUSTOM_TRIGGERS(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.policy.custom.triggers").a().c().b("A list of rule and custom trigger for each rule, formatted rule-id:com.package.Class.methodname(argType,argType,argType,...) where the argType of interest is marked with a *").a(Category.POLICY).a(com.contrastsecurity.agent.config.a.a("agent.java.custom_triggers")).f()),
    ASSESS_DISABLED_RULES(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.disabledrules").a("").b("list of comma-separated disabled rule ids").a(Category.RULES_CONFIG).a(applicationSettingsDTM -> {
        if (applicationSettingsDTM == null) {
            return null;
        }
        ApplicationAssessSettingsDTM applicationAssessSettingsDTM = applicationSettingsDTM.getAssessment();
        if (applicationAssessSettingsDTM == null) {
            return null;
        }
        Set<String> set = applicationAssessSettingsDTM.getDisabledRules();
        if (set == null || set.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(set.size() * 16);
        for (String string : set) {
            stringBuilder.append(string);
            stringBuilder.append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }).a(com.contrastsecurity.agent.config.a.a("assess.rules.disabled_rules")).f()),
    DISABLEDSOURCES(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.disabledsources").a().b("list of comma-separated disabled source ids").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("agent.java.disabled_sources")).f()),
    DISABLEDPROPAGATORS(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.disabledpropagators").a().c().b("list of comma-separated disabled propagator ids").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("agent.java.disabled_propagators")).f()),
    DEADZONES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.deadzones")).a(true).b("boolean to enable/disable loading of deadzones from policy").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.enable_deadzones")).f()),
    SOURCES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.sources")).a(true).b("boolean to enable/disable loading of sources from policy").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.enable_sources")).f()),
    DYNAMIC_SOURCES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.dynamicsources")).a(true).b("boolean to enable/disable loading of dynamic sources from policy").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.enable_dynamic_sources")).f()),
    PROPAGATORS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.propagators")).a(true).b("boolean enable/disable loading of propagators from policy").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.enable_propagators")).f()),
    TAGS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.tags")).a(true).b("boolean to enable/disable loading of tags from policy").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.enable_taggers")).f()),
    ANNOTATIONS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.annotations")).a(true).b("boolean enable/disable loading of annotations from policy").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.enable_annotations")).f()),
    RULES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.rules")).a(true).b("boolean to enable/disable loading of rules from policy").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.enable_rules")).f()),
    VALIDATORS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.validators")).a(true).b("boolean to enable/disable loading of validators from policy").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.enable_validators")).f()),
    ADAPTIVE_OPTIMIZATION(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.adaptiveoptimizations")).a(false).c().b("boolean to enable/disable the real-time learning to tune Assess rules").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.enable_adaptive_optimization")).f()),
    ADAPTIVE_OPTIMIZATION_FREQUENCY(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.adaptiveoptimizations.frequency")).a(200).c().b("how many propagation events should be sampled to find low-yield code paths (turn higher to hurt short-term performance in order to find optimizations quicker)").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.adaptive_optimization_frequency")).f()),
    ADAPTIVE_OPTIMIZATION_MAXIMUM(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.adaptiveoptimizations.max")).a(20).c().b("how many instances of a particular low-yield propagation code path can be observed before being disabled").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.adaptive_optimization_max")).f()),
    ADAPTIVE_OPTIMIZATION_PER_REQUEST(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.adaptiveoptimizations.sources.considerrequest")).a(false).c().b("controls whether data paths should be considered per-URI instead of globally").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.adaptive_optimization_per_request")).f()),
    VALIDATOR_SCOPES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.validator.scopes")).a(true).b("boolean to enable/disable loading of validator-scopes").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.enable_validator_scopes")).f()),
    INTERN_PREVENTION_SCOPES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.internPrevention.scopes")).a(true).c().b("boolean to enable/disable loading of intern-prevention-scopes").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.enable_intern_scopes")).f()),
    MAX_CONTEXT_SOURCE_EVENTS(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.assess.context.max.sources")).a(100).c().b("the maximum number of untrusted data flows to observe per request").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.max_context_source_events")).f()),
    MAX_CONTEXT_PROPAGATION_EVENTS(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.assess.context.max.propagations")).a(250).c().b("the maximum number of untrusted data flow propagations to observe per request").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.max_propagation_events")).f()),
    MAX_GLOBAL_TRACE_MAP_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(1050).c().b("the maximum number of objects to store in the global trace map").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.global.max_global_trace_map_size")).f()),
    MAX_TRACE_TTL(com.contrastsecurity.agent.config.b.a(Long.class).a((Long)((Object)"contrast.trace.ttl.max")).a(15000L).c().b("the number of milliseconds to retain a trace with a strongly held reference").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.trace_max_ttl_ms")).f()),
    TRACE_MAP_STRATEGY(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.trace.map").a("" + (Object)((Object)TraceMapStrategy.BOTH)).c().b("the strategy for tracking data: 'global', which allows data to be tracked across threads and requests, 'context', which limits data flows to a single request/response scope, or 'both', which tries to use context scope, but defaults to both").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.trace_map_strategy")).f()),
    PROPERTIES(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.properties").a().c().b("location of file containing Java properties style key, value pairs. ").d("Like contrast.config.path, impossible to set via YAML").a(Category.GENERAL_PROPERTIES).f()),
    PROTECT_ENABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.enabled")).a(false).b("If present, used to determine if the Protect feature should be enabled. If not present, decision delegated to Contrast UI").a(Category.PROTECT_MODE_CONFIG).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getProtect() != null) {
            return serverSettingsDTM.getProtect().getEnable();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("protect.enable")).f()),
    PROTECT_APPCHECK_ENABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.appcheck.enabled")).a(true).c().b("boolean to enable/disable AppCheck when Contrast is in PROTECT mode").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.enable_appcheck")).f()),
    PROTECT_API_BODY_READ(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.api.bodyread")).a(true).b("boolean to enable/disable whether API request bodies should be scanned for attacks if no known deserializers are in use").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.enable_api_request_body_reading")).f()),
    PROTECT_BOT_BLOCKER_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.botblocker")).a(false).b("configures Contrast to use simple signaturing to block traffic from scrapers, attack tools, and other unwanted automation.").a(Category.PROTECT_MODE_CONFIG).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getProtect() != null && serverSettingsDTM.getProtect().getRules() != null && serverSettingsDTM.getProtect().getRules().getBotBlocker() != null) {
            return serverSettingsDTM.getProtect().getRules().getBotBlocker().getEnabled();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("protect.rules.bot-blocker.enable")).f()),
    PROTECT_SINKS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sinks")).a(true).c().b("boolean to enable/disable monitoring sinks when Contrast is in PROTECT mode").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.enable_sinks")).f()),
    DESERIALIZER_TRACE_BODY_READ(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.deserializer.trace.body.read")).a(false).c().b("Outputs stack trace when agent fails to analyze request body deserialization").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.enable_body_stacktraces")).f()),
    XSS_KEYWORDS(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.xss.keywords").a().c().b("File path to overriding XSS keywords file").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.xss_keywords_file")).f()),
    XSS_PATTERNS(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.xss.patterns").a().c().b("Location of XSS patterns file").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.xss_patterns_file")).f()),
    XSS_THRESHOLD_DISABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.xss.threshold")).a(false).c().b("boolean to enable/disable the threshold after which an input is no longer checked against possible attack patterns").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.enable_xss_threshold")).f()),
    SQLINJECTION_KEYWORDS(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.sqlinjection.keywords").a().c().b("File path to overriding SQL Injection keywords file").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.sql-injection.keywords_file")).f()),
    SQLINJECTION_PATTERNS(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.sqlinjection.patterns").a().c().b("Location of SQL Injection patterns file").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.sql-injection.patterns_file")).f()),
    SQLINJECTION_THRESHOLD_DISABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.sqlinjection.threshold")).a(false).c().b("boolean to enable/disable the threshold after which an input is no longer checked against possible SQL Injection attack patterns").a(Category.PROTECT_MODE_CONFIG).d("CONTRAST-30448").f()),
    CMDINJECTION_THRESHOLD_DISABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.cmdinjection.threshold")).a(false).c().b("boolean to enable/disable the threshold after which an input is no longer checked against possible Command Injection attack patterns").a(Category.PROTECT_MODE_CONFIG).d("CONTRAST-30449").f()),
    CMDINJECTION_KEYWORDS(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.cmdinjection.keywords").a().c().b("File path to overriding Command Injection keywords file").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.cmd-injection.keywords_file")).f()),
    CMDINJECTION_PATTERNS(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.cmdinjection.patterns").a().c().b("Location of Command Injection patterns file").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.cmd-injection.patterns_file")).f()),
    PATH_TRAVERSAL_KEYWORDS(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.pathtraversal.keywords").c().a().b("File path to overriding Path traversal keywords file").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.path-traversal.keywords_file")).f()),
    PATH_TRAVERSAL_PATTERNS(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.pathtraversal.patterns").c().a().b("Location of Path traversal patterns file").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.path-traversal.patterns_file")).f()),
    PATH_TRAVERSAL_THRESHOLD_DISABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.pathtraversal.threshold")).a(false).c().b("boolean to enable/disable the threshold after which an input is no longer checked against possible Path traversal attack patterns").a(Category.PROTECT_MODE_CONFIG).d("JAVA-3554").f()),
    PROTECT_INEFFECTIVE_SAMPLES(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.defend.ineffective.samples")).a(50).b("Max number of detailed reports generated for ineffective attacks detected during a reporting period").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.samples.probed")).f()),
    PROTECT_PROBE_ANALYSIS_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).b("Set to `false` to disable probe analysis").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("protect.probe_analysis.enable")).f()),
    PROTECT_BLOCKED_SAMPLES(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.defend.blocked.samples")).a(25).b("Max number of detailed reports generated for blocked attacks detected during a reporting period").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.samples.blocked")).f()),
    PROTECT_PERIMETER_BLOCKED_SAMPLES(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.defend.blockedperimeter.samples")).a(25).b("Max number of detailed reports generated for perimeter blocked attacks detected during a reporting period").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.samples.blocked_at_perimeter")).f()),
    PROTECT_EXPLOITED_SAMPLES(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.defend.exploited.samples")).a(100).b("Max number of detailed reports generated for exploited attacks during a reporting period").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.samples.exploited")).f()),
    PROTECT_SUSPICIOUS_SAMPLES(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.protect.suspicious.samples")).a(100).b("Max number of detailed reports generated for suspicious attacks during a reporting period").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.samples.suspicious")).f()),
    PROTECT_DISABLED_RULES(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.defend.disabled.rules").a("").b("Comma separated list of protect rules to disable for this JVM").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.rules.disabled_rules")).f()),
    USE_URL_IN_HASH(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.assess.hashing.includeurl")).a(false).b("Set to \"true\" to factor in request URL when computing hash for reported finding").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("assess.include_url_in_finding_hash")).f()),
    USE_METHOD_CACHE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.assess.methodcache")).a(true).c().b("used to tell whether we should attempt to conserve heap by caching method signatures").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.enable_method_cache")).f()),
    WEBSERVICE_RESPONSE_TRACK(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Configures Contrast Assess analysis for responses from requests to web services.\nTRUE:   The agent will treat web service responses as untrusted and track propagation of data from web service responses.\nFALSE:  The agent will treat web service responses as trusted.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_web_service_response_tracking")).f()),
    WEBSPHERE_SHARED_LIB_DIR(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.websphere.shared.libs").a().b("Location of shared library directory on WebSphere").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.websphere_shared_libs_directory")).f()),
    ASSESS_AUTODETECT_CONTROLS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.assess.autodetect.controls")).a(true).b("boolean to enable/disable detecting security sensors").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("assess.enable_sensor_autodetection")).f()),
    ASSESS_REGEX_SECURITY_CONTROLS_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable regex security control analysis for performance reasons").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.regex_security_controls_enable")).f()),
    ASSESS_DETECT_CANARIES(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.assess.secondorder.canary").a().b("A value that will be fed by attack testing tools in order to test stored XSS or other second-order injection attacks to be detected coming out of databases").a(Category.DIAGNOSTICS).a(com.contrastsecurity.agent.config.a.a("assess.second_order_canary")).f()),
    ASSESS_THRESHOLD_ENTRIES(com.contrastsecurity.agent.config.b.a(Integer.class).a(100).b("The maximum number of vulnerabilities per rule type that can be discovered within a period defined by contrast.assess.threshold.period").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.threshold.entries")).f()),
    ASSESS_THRESHOLD_PERIOD_MS(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.assess.threshold.period.ms")).a(60000).b("The period, in milliseconds, in which a maximum number of vulnerabilities per rule type can be discovered").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.threshold.period_ms")).f()),
    LIBRARY_UPDATE_QUEUE_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.agent.reporting.library_update.queue.size")).a(20000).b("size of queue that holds library update events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.library_update.observations.queue.size")).f()),
    ENABLE_REPORTING_COMBINED_SERVER_APP_STARTUP(com.contrastsecurity.agent.config.b.a(Boolean.class).c().a(false).b("Enables reporting both server and app startup to a single endpoint. If false, the agent will report server startup and app startup to 2 separate legacy endpoints.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.reporting.enable_combined_server_app_startup")).a(serverSettingsDTM -> serverSettingsDTM != null && serverSettingsDTM.getTeamServerDateVersion() >= 20240703).f()),
    TEAMSERVER_REPORTING_MAX_RETRY(com.contrastsecurity.agent.config.b.a(Integer.class).c().a(3).b("Set the number of times the to retry recoverable network and HTTP failures when communicating with Contrast UI.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("api.max_retries")).f()),
    TEAMSERVER_REPORTING_RETRY_INTERVAL(com.contrastsecurity.agent.config.b.a(Integer.class).c().a(1000).b("Set the interval (in milliseconds) the agent will wait before retrying a recoverable network or HTTP failure when communicating with Contrast UI.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("api.retry_interval")).f()),
    REPORTING_THREAD_GRACE_PERIOD_MS(com.contrastsecurity.agent.config.b.a(Long.class).a(120000L).b("Set the grace period (in milliseconds) after agent shutdown to allow draining pending reports.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.shutdown_grace_period_ms")).f()),
    REPORTING_THREAD_POOL_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).c().a(1).b("Set size of reporting service's thread pool. More threads may increase reporting throughput at the expense of increased contention for CPU resources.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.thread_pool_size")).f()),
    ROUTE_OBSERVATION_QUEUE_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.agent.reporting.route_coverage.queue.size")).a(3000).b("size of queue that holds route observation events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.route_coverage.observations.queue.size")).f()),
    ROUTE_OBSERVATION_MAP_DEDUPLICATION_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).c().a(3070).b("size of map that holds route observation events to check for duplicates in a given time window before being sent to TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.route_coverage.observations.dedup.map.size")).f()),
    ROUTE_OBSERVATION_DEDUPLICATION_TIME(com.contrastsecurity.agent.config.b.a(Long.class).c().a(300000L).b("The time window (in milliseconds) of a route being observed more than once to be considered a duplicate and not reported to team server. If <= 0, no duplicate check will occur").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.route_coverage.observations.dedup.window.time")).f()),
    ROUTE_OBSERVATION_MIDDLEWARE_ENABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).c().a(false).b("Boolean as to whether Route Observation should run for middleware").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.route_coverage.observation.middleware")).a(serverSettingsDTM -> serverSettingsDTM != null && serverSettingsDTM.getTeamServerDateVersion() >= 20241009).f()),
    ROUTE_MIDDLEWARE_REPORTING_ENABLED(com.contrastsecurity.agent.config.b.a(Boolean.class).c().a(false).b("Boolean as to whether routes for middleware are reported to the backend for both discovered and observed routes. If this is false then we won't find discovered middleware routes. However, we will still find observed middleware routes, but will not report them").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.route_coverage.middleware.send")).a(serverSettingsDTM -> {
        if (serverSettingsDTM == null) {
            return false;
        }
        ServerSettingsAssessDTM serverSettingsAssessDTM = serverSettingsDTM.getAssess();
        return serverSettingsAssessDTM != null && serverSettingsAssessDTM.reportMiddlewareRoutes();
    }).f()),
    SILENT_TELEMETRY_QUEUE_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.agent.reporting.silent_telemetry.queue.size")).a(3000).c().b("size of queue that holds silent telemetry events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.silent_telemetry.observations.queue.size")).f()),
    APP_INVENTORY_QUEUE_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.agent.reporting.app_inventory.queue.size")).a(300).b("size of queue that holds app inventory events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.app_inventory.observations.queue.size")).f()),
    SERVER_INVENTORY_QUEUE_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(10).b("size of queue that holds server inventory events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.server_inventory.observations.queue.size")).f()),
    EFFECTIVE_CONFIG_QUEUE_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(100).c().b("size of queue that holds effective config reports that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.effective_config.observations.queue.size")).f()),
    ARCHITECTURE_COMPONENT_QUEUE_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(300).b("size of queue that holds app architecture component events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.architecture_component.observations.queue.size")).f()),
    CLASS_EVENT_QUEUE_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(1024).c().b("size of queue that holds class load events prior to being processed. Must be a power of 2.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.class_load_event.queue_size")).f()),
    SMAP_QUEUE_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(1024).c().b("size of queue that holds SMAP data prior to being processed. Must be a power of 2.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.smap.queue_size")).f()),
    LEGACY_REPORTING_PERIOD(com.contrastsecurity.agent.config.b.a(Long.class).a((Long)((Object)"contrast.reporting.period")).a(5000L).b("Set the polling period for spooling reports.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.polling.reporting_period_ms")).f()),
    REPORTING_PERIOD(com.contrastsecurity.agent.config.b.a(Integer.class).a(500).c().b("Specifies period between sending single report to TeamServer through the agent reporting service.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.reporting.period")).f()),
    DUP_DELAY(com.contrastsecurity.agent.config.b.a(Long.class).a((Long)((Object)"contrast.duplicate.delay")).a(5000L).b("The period for which duplicate traces, based on Contrast hashing methods, will be supressed (in milliseconds)").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("assess.duplicate_delay_ms")).f()),
    CSRF_IDEMPOTENT_URLS(com.contrastsecurity.agent.config.b.a(String.class).a().b("Set the path to a file containing line-separated URLs patterns which don't require CSRF tokens").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.csrf_exempt_urls_file")).f()),
    CSRF_PROTECTED_URLS(com.contrastsecurity.agent.config.b.a(String.class).a().b("Set the path to a file containing line-separated URLs patterns which require CSRF tokens").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.csrf_protected_urls_file")).f()),
    SCAN_CODE_SOURCES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.process.codesources")).a(true).c().b("By default, the Java agent will visit all classes at startup to look for vulnerabilities which may be detected by scanning a class (for example, hardcoded passwords). Set this property to `false` to disable the default behavior so that the agent will instead only visit classes which are likely to require sensors. This can improve application startup time, but may produce less findings (most likely those which require static analysis).").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.scan_all_code_sources")).f()),
    INSPECT_ALL_CLASSES(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.inspect.allclasses")).a(true).c().b("By default, the Java agent will deeply inspect all jar and war files loaded by the JVM in order to build a comprehensive understanding of the type hierarchy. Building this comprehensive understanding allows Contrast to instrument sensors into types that it might otherwise overlook. In most cases this produces a slight increase in accuracy at the cost of increased application startup time. Customers can disable this scanning by setting this property to `false`.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.scan_all_classes")).f()),
    HIERARCHY_OVERRIDE(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.hierarchy.path").a().c().b("A path on disk where additional hierarchy information can be found (as XML)").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.hierarchy_file")).f()),
    PACKAGES_TO_SCAN(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.user.packages").a().c().b("A comma-separated list of packages that Contrast should deeply scan for SMAP information, vulnerabilities, and other app-related analysis").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.user_packages")).f()),
    PREFLIGHT_FAIL_OPEN(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.preflight.open")).a(false).b("boolean to enable/disable preflight reporting fail open. In this case, fail open means that in the event of an error during a preflight check, all reports will be sent to TeamServer. Typically, the Contrast Agent uses a preflight hashing mechanism to avoid duplicate reporting, reducing load on TeamServer. Occasionally, this process can be overwhelmed, and TeamServer cannot reply quickly enough. In this case, in order to avoid losing any vulnerability data, the Agent will send any reports that are being filtered by preflight. While TeamServer can usually recover and resume preflight, it sometimes falls behind (for instance if the application being monitored is placed under a load test). To ensure that TeamServer has a chance to catch up, you can set this flag to false; however, it is worth noting that doing so may result in lost vulnerability information as all reports will be disregarded.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_preflight_fail_open")).f()),
    INSPECT_PARAMETERS_AS_XML(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.parameters.xml")).a(false).c().b("boolean to enable/disable XML scanning inside of individual parameters").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.enable_xml_parameter_inspection")).f()),
    INSPECT_PARAMETERS_AS_JSON(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.defend.parameters.json")).a(false).c().b("boolean to enable/disable JSON scanning inside of individual parameters").a(Category.PROTECT_MODE_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.enable_json_parameter_inspection")).f()),
    DELAYED_STARTUP(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.startup.delay")).a(0).c().b("this is the number of milliseconds to delay startup of the agent, if 0 or less, no startup delay").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.startup_delay_ms")).f()),
    DELAYED_STARTUP_STRATEGY(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.startup.strategy").a("activation").c().b("can be 'activation' or 'boot'; when doing delayed startup, what strategy should be used.  For `activation` booting and instrumentation do take place but the sensors are only enabled later.  For `boot` very little action is taken at agent startup, the agent booting and instrumentation occur later after the delay period.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.delayed_startup_strategy")).f()),
    DELAYED_C2_COMPILATION(com.contrastsecurity.agent.config.b.a(BooleanOrDefault.class).a(BooleanOrDefault.DEFAULT).c().b("Delay JVM C2 compilation until after the first request (on JVM 9+). This can speed up startup in CPU constrained environments.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.delayed_c2_compilation")).f()),
    DELAYED_C2_COMPILATION_TIMEOUT_MS(com.contrastsecurity.agent.config.b.a(Long.class).a(900000L).c().b("Timeout after which C2 compilation will be re-enabled (if it is not re-enabled after the first request).").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.delayed_c2_compilation_timeout_ms")).f()),
    ALLOW_INSTRUCTION_CACHE(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.instrcache.allow")).a(true).c().b("whether instruction caching is allowed").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("agent.java.allow_instruction_caching")).f()),
    SERVER_ENVIRONMENT(com.contrastsecurity.agent.config.b.a(com.contrastsecurity.agent.s.b.class).a((com.contrastsecurity.agent.s.b)((Object)"contrast.env")).a().b("the name of the environment this server should be associated with in the TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("server.environment")).a(serverSettingsDTM -> {
        if (serverSettingsDTM == null) {
            return com.contrastsecurity.agent.s.b.a;
        }
        com.contrastsecurity.agent.s.b b2 = serverSettingsDTM.getEnvironment();
        return b2 != null ? b2 : com.contrastsecurity.agent.s.b.a;
    }).f()),
    DISCOVER_CLOUD_RESOURCE_ID(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).b("Set to false to disable detection of cloud provider metadata such as resource identifiers.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("server.discover_cloud_resource")).f()),
    GROUP(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.group").a().b("the name of the application group this application should be associated with in the TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("application.group", true)).f()),
    APP_CODE(com.contrastsecurity.agent.config.b.a(String.class).a().b("the 'application code' for the application to be used in TeamServer").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("application.code", true)).f()),
    FREEZE_THRESHOLD(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.freeze.threshold")).a(140).c().b("Number of summarized events in a trace before trace is frozen").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.trace_summary.freeze_threshold")).f()),
    SUMMARIZATION_THRESHOLD(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.summarization.threshold")).a(100).c().b("Number of events in a trace before summarization kicks in").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.trace_summary.threshold")).f()),
    SUMMARIZATION_LEADING_EVENTS(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.summarization.leading.events")).a(10).c().b("Number of leading events to preserve when summarizing a trace").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.trace_summary.leading_events")).f()),
    SUMMARIZATION_TRAILING_EVENTS(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.summarization.trailing.events")).a(10).c().b("Minimum number of trailing events to preserve when summarizing a trace").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.trace_summary.trailing_events")).f()),
    USER_NAME(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.user.name").a().b("Overrides the Contrast user name.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("api.user_name", Lists.of("contrast.user_name"))).f()),
    API_KEY(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.api.key").a().b("Overrides the Contrast api key.").a(Category.GENERAL_PROPERTIES).d().a(com.contrastsecurity.agent.config.a.a("api.api_key", Lists.of("contrast.api_key"))).f()),
    SERVICE_KEY(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.service.key").a().b("Overrides the Contrast service key.").a(Category.GENERAL_PROPERTIES).d().a(com.contrastsecurity.agent.config.a.a("api.service_key", Lists.of("contrast.service_key"))).f()),
    TOKEN(com.contrastsecurity.agent.config.b.a(String.class).a().b("Overrides the Contrast token, which is parsed out into individual config properties").a(Category.GENERAL_PROPERTIES).d().a(com.contrastsecurity.agent.config.a.a("api.token")).f()),
    VM_ID(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.vm.id").a("Java").c().b("Override the reported VM").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.vm_id")).f()),
    APPLICATION_PATH(com.contrastsecurity.agent.config.b.a(String.class).a().b("Overrides the detected context path (location) of the application. This affects the \"Application-Path\" header value when sending reports. Overriding this could cause reports to be thrown away.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("application.path")).f()),
    ENABLE_TRANSFORM_PRIMORDIAL_TASK(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("Used for testing purposes, in cases that require a faked ContrastEngine to be started to mimic agent startup (e.g., needing access to the generated dispatcher instances). Overriding this property forces an early return in ContrastEngine startup tasks (TransformPrimordialTask & AddTransformerTask) to avoid errors caused by the faked ContrastEngine.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_transform_primordial")).f()),
    TRANSFORM_PRIMORDIAL_BATCH_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(-1).c().b("Configures the batch size to use for primordial transformations. Larger batches will consume more CPU and start the agent faster while smaller batches will consume less CPU and start the agent slower. Defaults to Integer.MAX_VALUE. Currently the only supported batch sizes are 1 and Integer.MAX_VALUE.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.transform_primordial_batch_size")).f()),
    STRICT_STARTUP(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.agent.java.strict.startup")).a(false).c().b("Prevent the application from starting if Contrast fails to start. Use with caution.").a(Category.INTERNAL_USAGE).d("The YAML property cannot be used since this property is obtained before the Config object is created. This property can only be set as a system property: -Dcontrast.agent.java.strict.startup").f()),
    INVENTORY_CACHE_LIBRARY_FACTS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.inventory.cache.library.facts")).a(true).b("Controls caching of basic information gathered from detected libraries.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.cache_library_facts")).f()),
    INVENTORY_MAX_JAR_SIZE_TO_BUFFER_IN_MEM(com.contrastsecurity.agent.config.b.a(Integer.class).a(0x3200000).b("Controls the maximum size of the in memory buffer for parsing jar contents in bytes. Min size supported is 512KB").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.inventory.jar_mem_buffer_size")).c().f()),
    ROUTE_COVERAGE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).b("Toggle the route based coverage feature").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.route_coverage.enable")).f()),
    INVENTORY_DENYLIST(com.contrastsecurity.agent.config.b.a(String.class).a().c().b("List of JAR, EAR, or WAR file names to skip during library scanning").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("inventory.blacklist")).f()),
    ENABLE_INTEGRATION_TEST_SERVICES(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Enables the agent's integration test services which expose certain features in tests via IntegrationTestServices.").a(Category.GENERAL_PROPERTIES).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_integration_test_services")).f()),
    ENABLE_RELOADABLE_BEANS(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.agent.java.enable_reloadable_beans")).a(false).c().b("Set to true to enable functionality in the com.contrastsecurity.agent.reloadable package. This is only needed for our legacy integration tests").a(Category.GENERAL_PROPERTIES).d("This should be removed along with the integration tests").f()),
    ENABLE_AGENT_CHANNEL_HUB(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.agent.java.agent_channel_hub")).a(false).c().b("Set to true to register the AgentChannelHub. This is only needed for our legacy integration tests").a(Category.INTERNAL_USAGE).d("This should be removed along with the integration tests").f()),
    SILENT_TELEMETRY_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Toggle the diagnostics telemetry feature").a(Category.GENERAL_PROPERTIES).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getTelemetry() != null) {
            return serverSettingsDTM.getTelemetry().getEnable();
        }
        return null;
    }).a(com.contrastsecurity.agent.config.a.a("agent.silent_telemetry.enable")).f()),
    MAX_REQUEST_BODY_ASSESS_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(4096).c().b("Assess maximum request body size to buffer").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.max_request_bytes_buffer")).f()),
    MAX_REQUEST_BODY_ANALYSIS_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(Integer.MAX_VALUE).c().b("Maximum number of request body bytes that will be captured for analysis. Note that individual plugins may specify lower values for this property than the default.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.max_request_body_bytes_captured")).f()),
    MAX_RESPONSE_BODY_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(524288).c().b("The maximum number of bytes of the HTTP response that will be captured for analysis.  A value of 0 will disable capturing the response").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.max_response_body_bytes_captured")).f()),
    CAPTURE_NON_DOCUMENT_REQUEST_BODY(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Whether the agent should capture request bodies of requests with non-document Content-Types. After a number of bytes, request bodies are interrogated for document body syntax. Those that do not meet requirements are no longer captured nor evaluated.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("agent.java.capture_non_document_request_bodies")).f()),
    MAX_CONTEXT_SNAPSHOT_CACHE_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"contrast.assess.context.max.snapshots")).a(100).c().b("the maximum number of cached method object snapshots per context").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.max_cached_context_snapshots")).f()),
    MAX_SNAPSHOT_TOSTRING_LENGTH(com.contrastsecurity.agent.config.b.a(Integer.class).a(10000).c().b("Maximum length a String snapshot can be in SnapshotFactory. Object's with toString implementations that produce longer Strings than this max will be denylisted and their class name used instead.").a(Category.PERFORMANCE).a(com.contrastsecurity.agent.config.a.a("assess.max_snapshot_tostring_length")).f()),
    CMD_INJECTION_V2_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Enable/disable path traversal using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.cmd_injection.engine_v2")).f()),
    PATH_TRAVERSAL_V2_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Enable/disable path traversal using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.path_traversal.engine_v2")).f()),
    SQL_INJECTION_V2_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Enable/disable SQLi using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.sql_injection.engine_v2")).f()),
    SQL_INJECTION_PATTERNS_V2_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Set to true to use the v2 patterns for SQLi").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("protect.sql_injection.v2_patterns.enable")).f()),
    UNSAFE_FILE_UPLOAD_V2_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Enable/disable UnsafeFileUpload using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.INTERNAL_USAGE).a(com.contrastsecurity.agent.config.a.a("protect.unsafe_file_upload.engine_v2")).f()),
    XSS_V2_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).c().b("Enable/disable SQLi using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.RULES_CONFIG).a(com.contrastsecurity.agent.config.a.a("protect.xss.engine_v2")).f()),
    SMTP_INJECTION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("smtp-injection.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    SSRF_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("ssrf.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    UNSAFE_XML_DECODE_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("unsafe-xml-decode.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    HARDCODED_PASSWORD_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("hardcoded-password.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    HARDCODED_PASSWORD_EXCLUSION(com.contrastsecurity.agent.config.b.a(String.class).a().b("Comma separated list of classes to ignore when checking for hardcoded passwords").a(Category.INTERNAL_USAGE).c().a(com.contrastsecurity.agent.config.a.a("agent.java.assess.rules.hardcoded_password_exclusion")).f()),
    HARDCODED_KEY_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("hardcoded-key.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    HARDCODED_KEY_EXCLUSION(com.contrastsecurity.agent.config.b.a(String.class).a().b("Comma separated list of classes to ignore when checking for hardcoded encryption keys").a(Category.INTERNAL_USAGE).c().a(com.contrastsecurity.agent.config.a.a("agent.java.assess.rules.hardcoded_key_exclusion")).f()),
    SPRING_UNCHECKED_AUTOBINDING_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("spring-unchecked-autobinding.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    SCALA_PLAY_UNCHECKED_AUTOBINDING_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("scala-play-unchecked-autobinding.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    XXE_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("xxe.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    INSECURE_AUTH_PROTOCOL_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("insecure-auth-protocol.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    CLICKJACKING_CONTROL_MISSING_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("clickjacking-control-missing.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    SESSION_REWRITING_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("session-rewriting.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    PARAMETER_POLLUTION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("parameter-pollution.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    CACHE_CONTROLS_MISSING_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("cache-controls-missing.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    AUTOCOMPLETE_MISSING_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("autocomplete-missing.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    CSRF_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("csrf.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    INSECURE_JSP_ACCESS_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("insecure-jsp-access.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    SESSION_TIMEOUT_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("session-timeout.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    VERB_TAMPERING_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("verb-tampering.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    OVERLY_PERMISSIVE_CROSS_DOMAIN_POLICY_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("overly-permissive-cross-domain-policy.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    CMD_INJECTION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("cmd-injection.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    COOKIE_FLAGS_MISSING_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("cookie-flags-missing.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    CRYPTO_BAD_CIPHERS_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("crypto-bad-ciphers.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    CRYPTO_BAD_MAC_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("crypto-bad-mac.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    CRYPTO_WEAK_RANDOMNESS_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("crypto-weak-randomness.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    EXPRESSION_LANGUAGE_INJECTION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("expression-language-injection.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    HTTPONLY_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("httponly.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    LDAP_INJECTION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("ldap-injection.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    LOG_INJECTION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("log-injection.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    PATH_TRAVERSAL_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("path-traversal.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    REFLECTED_XSS_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("reflected-xss.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    REFLECTION_INJECTION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("reflection-injection.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    HQL_INJECTION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("hql-injection.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    NOSQL_INJECTION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("nosql-injection.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    NOSQL_INJECTION_DYNAMODB_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("nosql-injection-dynamodb.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    SQL_INJECTION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("sql-injection.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    TRUST_BOUNDARY_VIOLATION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("trust-boundary-violation.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    TOMCAT_CONTEXT_CONFIG_WORKAROUND(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable the Tomcat ContextConfig workaround for Contrast classes").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_tomcat_context_config_workaround")).f()),
    UNSAFE_READLINE_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("unsafe-readline.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    UNVALIDATED_FORWARD_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("unvalidated-forward.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    UNVALIDATED_REDIRECT_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("unvalidated-redirect.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    XPATH_INJECTION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("xpath-injection.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    HEADER_INJECTION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("header-injection.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    UNTRUSTED_DESERIALIZATION_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("untrusted-deserialization.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    HSTS_HEADER_MISSING_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("hsts-header-missing.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    XCONTENTTYPE_HEADER_MISSING_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("xcontenttype-header-missing.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    XXSSPROTECTION_HEADER_DISABLED_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("xxssprotection-header-disabled.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    CSP_HEADER_MISSING_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("csp-header-missing.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    CSP_HEADER_INSECURE_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("csp-header-insecure.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    REDOS_SAFE_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a("redos.safetags").a().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).c().d("Safe-tags are not supported by the Common Config spec").f()),
    NONEXISTENT_CONFIG_PROPERTY(com.contrastsecurity.agent.config.b.a(String.class).a("config.does-not-exist").a().b("A nonexistent config property that will always return null").a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    TEST_CONFIG_STRING_PROPERTY(com.contrastsecurity.agent.config.b.a(String.class).a("config.test.string").a("foo").b("Test config property used in unit tests for the Config or ConfigProviders").a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    TEST_CONFIG_INT_PROPERTY(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"config.test.int")).a(420).b("Test config property used in unit tests for the Config or ConfigProviders").a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    TEST_CONFIG_BOOLEAN_PROPERTY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"config.test.boolean")).a(false).b("Test config property used in unit tests for the Config or ConfigProviders").a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    TEST_CONFIG_ENUM_PROPERTY(com.contrastsecurity.agent.config.b.a(LogLevel.class).a((LogLevel)((Object)"config.test.enum")).a(LogLevel.INFO).b("Test config property used in unit tests for the Config or ConfigProviders").a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    PROTECT_FAKE_RULE_MODE(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"contrast.defend.fake-rule.mode")).a().b("Test property for enabling ProtectRule").a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    FAKE_RULE_MODE_ENABLED(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"enabled-fake-rule")).a().b("Test property for enabling ProtectRule").a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    FAKE_RULE_MODE_DISABLED(com.contrastsecurity.agent.config.b.a(CommonConfigProtectionMode.class).a((CommonConfigProtectionMode)((Object)"disabled-fake-rule")).a().b("Test property for disabling ProtectRule").a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    FAKE_FEATURES_CONFIGURABLE_STRING_PROPERTY(com.contrastsecurity.agent.config.b.a(String.class).a("test-key").a().a(serverSettingsDTM -> "foo").a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    FAKE_FEATURES_CONFIGURABLE_INT_PROPERTY(com.contrastsecurity.agent.config.b.a(Integer.class).a((Integer)((Object)"test-key-int")).a(17).a(serverSettingsDTM -> 42).a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    FAKE_FEATURES_CONFIGURABLE_LONG_PROPERTY(com.contrastsecurity.agent.config.b.a(Long.class).a((Long)((Object)"test-key-long")).a(100000000000L).a(serverSettingsDTM -> 420L).a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    FAKE_FEATURES_CONFIGURABLE_BOOLEAN_PROPERTY(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"test-key-bool")).a(false).a(serverSettingsDTM -> true).a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    PROPERTY_OVERRIDE_PATTERN_JSON(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.pattern.json.override").a().a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    PROPERTY_OVERRIDE_KEYWORD_JSON(com.contrastsecurity.agent.config.b.a(String.class).a("contrast.keyword.json.override").a().a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    PROPERTY_OVERRIDE_BREAK_ON_THRESHOLD(com.contrastsecurity.agent.config.b.a(Boolean.class).a((Boolean)((Object)"contrast.break.on.threshold")).a(true).a(Category.INTERNAL_USAGE).c().d("Test properties cannot be set via YAML").f()),
    AGENT_TELEMETRY_OPT_OUT(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).b("Opt out of the collection of metrics and their submission to the remote endpoint.").a(Category.TELEMETRY).c().a(com.contrastsecurity.agent.config.a.a("agent.telemetry.optout")).f()),
    SUPPORTER_TELEMETRY(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).c().b("boolean to enable/disable support for telemetry").a(Category.FRAMEWORK_SUPPORT).a(com.contrastsecurity.agent.config.a.a("agent.java.enable_telemetry_support")).f()),
    AGENT_TELEMETRY_INITIAL_DELAY(com.contrastsecurity.agent.config.b.a(Long.class).a(TimeUnit.MINUTES.toMillis(2L)).b("Grace period following startup. Metric publishing will not take place until the grace period has elapsed.").a(Category.TELEMETRY).c().a(com.contrastsecurity.agent.config.a.a("agent.telemetry.metrics.initial_delay_ms")).f()),
    AGENT_TELEMETRY_SUBMISSION_CADENCE(com.contrastsecurity.agent.config.b.a(Long.class).a(TimeUnit.HOURS.toMillis(3L)).b("Time between submissions of metric registry contents to remote endpoint in ms.").a(Category.TELEMETRY).c().a(com.contrastsecurity.agent.config.a.a("agent.telemetry.metrics.interval_ms")).f()),
    AGENT_TELEMETRY_SUBMISSION_ENDPOINT(com.contrastsecurity.agent.config.b.a(String.class).a("https://telemetry.java.contrastsecurity.com/api/v1/telemetry/").b("The URL where metrics and errors will be sent at submission.").a(Category.TELEMETRY).c().a(com.contrastsecurity.agent.config.a.a("agent.telemetry.endpoint")).f()),
    AGENT_TELEMETRY_SUBMISSION_TIMEOUT(com.contrastsecurity.agent.config.b.a(Integer.class).a(30000).b("The connect timeout for submitting to Telemetry.").a(Category.TELEMETRY).c().a(com.contrastsecurity.agent.config.a.a("agent.telemetry.connect_timeout_ms")).f()),
    AGENT_TELEMETRY_USE_AUTH(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).b("Whether to use authentication headers Authorization and API-Key for the Telemetry client.").a(Category.TELEMETRY).c().a(com.contrastsecurity.agent.config.a.a("agent.telemetry.use_auth")).f()),
    AGENT_TELEMETRY_CUSTOM_TAGS(com.contrastsecurity.agent.config.b.a(String.class).a().b("Allows specific tags to be set for Telemetry. Two tags can be set using this value separated by a comma. Commas are not allowed as tag values. Any leading or trailing whitespace will be trimmed for each tag value. The first tag will be named 'customTag1' and the second 'customTag2'.").a(Category.TELEMETRY).c().a(com.contrastsecurity.agent.config.a.a("agent.telemetry.tags")).f()),
    AGENT_TELEMETRY_INITIALIZE_BUCKETS(com.contrastsecurity.agent.config.b.a(String.class).a().b("Comma separated list of telemetry metric names for distributions with buckets whose columns must be initialized on the Telemetry backend in order for the front-end to render the charts.").a(Category.TELEMETRY).c().a(com.contrastsecurity.agent.config.a.a("agent.java.telemetry.initialize_buckets")).f()),
    APPMGR_JARANALYZER_TTL(com.contrastsecurity.agent.config.b.a(Long.class).a((Long)((Object)"contrast.agent.appmgr.jaranalyzer.ttl")).a(TimeUnit.MINUTES.toMillis(10L)).b("TTL for JarAnalyzer in ApplicationManager in milliseconds, default 10 minutes").a(Category.PERFORMANCE).c().d("Agent-only config").f()),
    TELEMETRY_ERROR_MAX_RETAINED_IN_MEM_BYTES(com.contrastsecurity.agent.config.b.a(Long.class).a(0x600000L).b("The max size in bytes allowed to be stored in memory before error submissions. This is a best-effort setting and the size in some JVMs may be larger than this value.").a(Category.TELEMETRY).c().a(com.contrastsecurity.agent.config.a.a("agent.telemetry.errors.max_retained_bytes")).f()),
    TELEMETRY_ERROR_MAX_QUEUE_SIZE(com.contrastsecurity.agent.config.b.a(Integer.class).a(32).b("The max number of Throwables to emit for Agent Telemetry Error Reporting.").a(Category.TELEMETRY).c().a(com.contrastsecurity.agent.config.a.a("agent.telemetry.errors.max_queue_size")).f()),
    PROTECT_PATTERN_EVALUATION_V2_ENABLE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(true).b("Whether the agent should use its v2 Protect pattern evaluation").a(Category.INTERNAL_USAGE).c().a(com.contrastsecurity.agent.config.a.a("agent.java.protect_pattern_evaluation_engine_v2")).f()),
    PROTECT_BODY_IOUTILS_NOOP(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).b("Whether the agent should match the behaviour prior to JAVA-8558 and skip the body for IOUtils to... methods handling").a(Category.GENERAL_PROPERTIES).c().a(com.contrastsecurity.agent.config.a.a("agent.java.protect_ioutils_skip")).f()),
    INPUT_EXCLUSION_NAME_STRICT_REGEX(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).b("When false, enables simple string matching of input names as a fallback for exclusions specifying an invalid input name matching pattern.  Exclusion input name matching allows a small subset of regex, including just \".\", \"\\.\", \".*\" \".+\" and \".?\".  See https://docs.contrastsecurity.com/en/add-exclusions.html for details.  The default value, false, is intended to allow a gradual migration away from legacy exclusions defined for simpler string pattern matching. ").a(Category.GENERAL_PROPERTIES).c().a(com.contrastsecurity.agent.config.a.a("agent.java.input_exclusion_name_nonregex_match")).f()),
    PROCESS_DENYLIST_OVERRIDE(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).b("Whether to override the process denylist and allow all processes to be instrumented.").a(Category.INTERNAL_USAGE).c().d("agent.java.process_denylist_override").a((Boolean)((Object)"agent.java.process_denylist_override")).f()),
    DUCKTYPE_TESTING(com.contrastsecurity.agent.config.b.a(Boolean.class).a(false).b("Enables duck-type style testing for specific classes that we've found difficult to test any other way.This should _never_ be used in production code.").a(Category.INTERNAL_USAGE).c().a(com.contrastsecurity.agent.config.a.a("agent.java.ducktype.testing")).f());

    public static final int INT_PROPERTY_NOT_SET = -1;
    public static final boolean SUPPORTER_CLASSLOADER_DEFAULT = true;
    public static final int DEFAULT_TEAMSERVER_TIMEOUT_MS = 10000;
    public static final long DEFAULT_BACKOFF_FACTOR_MS = 1000L;
    public static final long DEFAULT_MAX_TOTAL_BACKOFF_MS = 60000L;
    public static final int DEFAULT_CLASS_EVENT_QUEUE_SIZE = 1024;
    public static final int DEFAULT_SMAP_QUEUE_SIZE = 1024;
    public static final int DEFAULT_MAX_CONTEXT_SOURCE_EVENTS = 100;
    public static final int DEFAULT_MAX_CONTEXT_PROPAGATION_EVENTS = 250;
    public static final int DEFAULT_GLOBAL_TRACE_MAP_FACTOR = 3;
    public static final int DEFAULT_MAX_RESPONSE_BODY_SIZE = 524288;
    private final com.contrastsecurity.agent.config.b<?> metadata;

    private static DiagnosticsLoggerDTM getDiagnosticsLogger(ServerSettingsDTM serverSettingsDTM) {
        if (serverSettingsDTM == null) {
            return null;
        }
        DiagnosticsDTM diagnosticsDTM = serverSettingsDTM.getDiagnostics();
        if (diagnosticsDTM == null) {
            return null;
        }
        return diagnosticsDTM.getDiagnosticsLogger();
    }

    private ConfigProperty(com.contrastsecurity.agent.config.b<?> b2) {
        this.metadata = Objects.requireNonNull(b2);
    }

    public boolean isHidden() {
        return this.metadata.i();
    }

    public String legacySystemPropertyName() {
        return this.metadata.b();
    }

    public Class<?> type() {
        return this.metadata.a();
    }

    public String description() {
        return this.metadata.c();
    }

    public boolean hasNullDefaultValue() {
        return this.metadata.e();
    }

    public String deprecationAlternative() {
        return this.metadata.f();
    }

    public boolean isDeprecated() {
        return this.metadata.g();
    }

    public Object defaultValue() {
        if (this.hasNullDefaultValue()) {
            return null;
        }
        return this.metadata.d();
    }

    public boolean isAppSpecific() {
        return this.metadata.k();
    }

    public Category category() {
        return this.metadata.h();
    }

    public boolean isCommonConfigExempt() {
        return this.metadata.n() != null;
    }

    public boolean isYamlConfigurable() {
        return this.metadata.o() != null;
    }

    public String commonConfigPathOrNull() {
        return this.metadata.o() != null ? this.metadata.o().a() : null;
    }

    public final String commonConfigSystemPropertyName() {
        com.contrastsecurity.agent.config.a a2 = this.metadata.o();
        if (a2 == null) {
            throw new UnsupportedOperationException("This property does not support common config");
        }
        return "contrast." + a2.a();
    }

    public final String commonConfigEnvVarName() {
        String string = this.canonicalName();
        if (string == null) {
            throw new UnsupportedOperationException("This property does not support common config");
        }
        return ConfigProperty.commonConfigPathToEnvVarName(string);
    }

    public static String commonConfigPathToEnvVarName(String string) {
        string = StringUtils.join((Object[])StringUtils.split(string, "."), "__");
        string = "CONTRAST__" + string.toUpperCase(Locale.US);
        return string.contains("-") ? string.replace("-", "_") : string;
    }

    public final String canonicalName() {
        return this.metadata.o() != null ? this.metadata.o().a() : this.metadata.b();
    }

    public List<String> deprecatedPathsOrEmpty() {
        return this.metadata.o() != null ? this.metadata.o().b() : Collections.emptyList();
    }

    public boolean shouldMask() {
        return this.metadata.j();
    }

    public boolean supportsProfile() {
        if (this.metadata.o() != null) {
            return this.metadata.o().c();
        }
        return false;
    }

    public Object parse(String string, com.contrastsecurity.agent.config.c c2, h h2) {
        try {
            return c2.a(this.type(), string);
        }
        catch (com.contrastsecurity.agent.config.exception.c c3) {
            h2.a(this, c3.getMessage());
            return null;
        }
        catch (com.contrastsecurity.agent.config.exception.a | NumberFormatException illegalArgumentException) {
            throw new ContrastConfigurationException("Value " + string + " for config property " + this.legacySystemPropertyName() + " could not be parsed as a " + this.type().getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ContrastConfigurationException("Attempted to parse " + this.legacySystemPropertyName() + " as a " + this.type().getName() + " but " + this.type().getName() + " is not a supported configuration property type");
        }
    }

    public static ConfigProperty propertyFromString(String string) {
        Objects.requireNonNull(string);
        for (ConfigProperty configProperty : ConfigProperty.values()) {
            if (!string.equals(configProperty.legacySystemPropertyName())) continue;
            return configProperty;
        }
        return null;
    }

    public static ConfigProperty propertyFromYamlString(String string) {
        for (ConfigProperty configProperty : d.b.a()) {
            Object object;
            String string2 = configProperty.commonConfigPathOrNull();
            if (string2 != null) {
                if (string2.equals(string)) {
                    return configProperty;
                }
                object = "contrast." + string2;
                if (((String)object).equals(string)) {
                    return configProperty;
                }
            }
            object = configProperty.deprecatedPathsOrEmpty();
            Iterator<String> iterator = object.iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                if (string3.equals(string)) {
                    return configProperty;
                }
                String string4 = "contrast." + string3;
                if (!string4.equals(string)) continue;
                return configProperty;
            }
        }
        return null;
    }

    public c<?> serverSettingsExtractor() {
        return this.metadata.l();
    }

    public boolean isFeatureConfigurable() {
        return this.metadata.l() != null;
    }

    public Object fromServerSettings(ServerSettingsDTM serverSettingsDTM) {
        c<?> c2 = this.serverSettingsExtractor();
        return c2.extract(serverSettingsDTM);
    }

    public a<?> appSettingsExtractorClass() {
        return this.metadata.m();
    }

    public boolean isAppSettingsConfigurable() {
        return this.metadata.m() != null;
    }

    public Object fromAppSettings(ApplicationSettingsDTM applicationSettingsDTM) {
        a<?> a2 = this.appSettingsExtractorClass();
        return a2.extract(applicationSettingsDTM);
    }

    public String toString() {
        return this.canonicalName();
    }

    private static boolean isPositive(Integer n2) {
        return n2 != null && n2 > 0;
    }

    @DontObfuscate
    public static enum Category {
        GENERAL_PROPERTIES,
        LOGGING_ASSESS,
        LOGGING_PROTECT,
        DIAGNOSTICS,
        PERFORMANCE,
        POLICY,
        RULES_CONFIG,
        PROTECT_MODE_CONFIG,
        FRAMEWORK_SUPPORT,
        PROXY_SETTINGS,
        INTERNAL_USAGE,
        SAFE_TAGS,
        TELEMETRY;

    }
}

